<?php
/**
 * $Horde: forwards/lib/base.php,v 1.2.2.3 2004/03/30 03:34:11 chuck Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * Forwards base inclusion file.
 *
 * This file brings in all of the dependencies that every Forwards script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Forwards
@define('FORWARDS_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('forwards');
$conf = &$GLOBALS['conf'];

// Set the error reporting level in accordance with the config settings.
error_reporting($conf['debug_level']);

// Set the maximum execution time in accordance with the config settings.
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';


// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();
if (isset($session_control)) {
    switch ($session_control) {
    case 'netscape':
        if ($browser->isBrowser('netscape')) {
            session_cache_limiter('private, must-revalidate');
        }
        break;
        
    case 'cache_ssl_downloads':
        header('Vary: User-Agent');
        if ($browser->hasQuirk('cache_ssl_downloads')
            && isset($GLOBALS['HTTP_SERVER_VARS']['HTTPS'])
            && ($GLOBALS['HTTP_SERVER_VARS']['HTTPS'] == 'on')) {
            session_cache_limiter('private, must-revalidate');
        }
        break;
    }
}

// Code that should be run at the beginning of all Forwards pages
session_name($conf['session_name']);
@session_start();

// Don't allow access unless there is a Horde login
// NOTE:  We explicitely do not honor the guests flag here!!!
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getWebRoot("horde") . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    exit;
}

?>
