#ifndef TAGS_H
#define TAGS_H

#define SPACE_CHAR " "

#define ISBOLD 0x1
#define ISITALIC 0x2
#define ISUNDERLINE 0x4

#include "my_set.h"

#include <string>

using std::string;

class Tag
{
 protected:
  string TagName ;
  string color ;
  int flags ;

 public:
  Tag( const string &n ) : TagName( n ), flags( 0 ) {}
  Tag( const string &n, const string &c );

  void SetFlags( int f ) { flags = f ; }

  string GetName() const { return TagName ; }
  string GetColor() const { return color ; }
  void SetColor( const string &col ) { color = col ; }

  bool IsBold() const { return ( flags & ISBOLD ) ; }
  bool IsItalic() const { return ( flags & ISITALIC ) ; }
  bool IsUnderline() const { return ( flags & ISUNDERLINE ) ; }

  void Print() ;
} ;

struct TagLess
{
  typedef std::less<string> value_compare;

  value_compare value_comp;

 public:
  bool operator() (const Tag *t1, const Tag *t2) const
  { return value_comp(t1->GetName(),t2->GetName()); }
};

class Tags : protected set<Tag *, TagLess>
{
  typedef set<Tag *, TagLess> container_type;

 public:
  using container_type::begin;
  using container_type::end;
  using container_type::const_iterator;

  Tags() {}
  bool AddTag( Tag *t ) { return insert( t ).second ;  }
  Tag *GetTag( const string &name ) ;
} ;

inline Tag *
Tags::GetTag( const string &name )
{
  Tag *temp = new Tag (name);
  const_iterator p = find (temp);
  delete temp;
  if (p != end ())
    return *p;

  return 0;
}

void setTags( Tags *t ) ;
Tag *getTag( const string &name ) ;
const Tags *getTags();
void createDefaultTags() ;
Tag *newDefaultTag( const string &tag, const string &color ) ;

#endif
