/*----------------------------------------------------------------------------*/
/*                                                                            */
/* [cfg_abs.h]           Abstract Context Free Grammar                        */
/*                                                                            */
/* Copyright (c) 1993 by Doelle, Manns                                        */
/*----------------------------------------------------------------------------*/

/* File generated by 'ctoh'. Don't change manually. */

#ifndef cfg_abs_INCL
#define cfg_abs_INCL


#include "standard.h"
#include "hset.h"
#include "prs.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
   <p>[cfg_abs] provides functions that derives the nonterminal and production classes
   which constitutes the abstract context free grammar from a given parse table.

   <p>For further documentation of the definition of an abstract context free grammar
   follow the reference to module <a href="prs_gen.htm">[prs_gen]</a>.<br><br>
*/

/* ------------------------------- Macros ------------------------------------ */

/* 
   Properties of nonterminals and their classes
*/

#define ACFG_NTTYP_LIST     1
#define ACFG_NTTYP_CLASS    2
#define ACFG_NTTYP_OPT      4
#define ACFG_NTTYP_NIL      8
#define ACFG_NTTYP_RECTYP   16
#define ACFG_NTTYP_REF0     32
#define ACFG_NTTYP_REF1     64
#define ACFG_NTTYP_START    128
#define ACFG_NTTYP_PRIM     256
#define ACFG_NTTYP_PRIMC    512
#define ACFG_NTTYP_EMPTY    1024
#define ACFG_NTTYP_RECREF   2048
#define ACFG_NTTYP_CONSREF  4096
#define ACFG_HAS_NTTYP(v,t) ( (((int)(v)) & ((int)(t))) > 0 )

/* ------------------------------- API --------------------------------------- */

c_bool acfg_init
     (
       PLR_Tab PTab, int** aPol, HS_Set** aNtm, HS_Set** aPrd, c_bool errmsg
     )
/* creates & fills 'aPol', 'aNtm', 'aPrd' from parse table 'PTab'
   'aPol' :- polymorph 'cons' classes
   'aNtm' :- nonterminal partition
   'aPrd' :- nonterminal class productions
*/
;

c_bool acfg_init_doc
     (
       PLR_Tab PTab, int** aPol, HS_Set** aNtm, HS_Set** aPrd
     )
/* creates & fills 'aPol', 'aNtm', 'aPrd' from parse table 'PTab',
   as needed for the generation of a refernce document
   'aPol' :- nonterminal/class types/properties
   'aNtm' :- nonterminal partition
   'aPrd' :- nonterminal productions
*/
;

void acfg_quit(PLR_Tab PTab,int* aPol, HS_Set* aNtm, HS_Set* aPrd)
/* deletes 'aPol', 'aNtm' and 'aPrd'
   ( originally created from parse table 'PTab' )
 */
;



#ifdef __cplusplus
}
#endif

#endif
