#include "sendfd.h"


#ifdef LINUX

ssize_t
write_fd(int fd, void *ptr, size_t nbytes, int sendfd)
{
	struct msghdr	msg;
	struct iovec	iov[1];

#ifdef	HAVE_MSGHDR_MSG_CONTROL
	union {
	  struct cmsghdr	cm;
	  char				control[CMSG_SPACE(sizeof(int))];
	} control_un;
	struct cmsghdr	*cmptr;

	msg.msg_control = control_un.control;
	msg.msg_controllen = sizeof(control_un.control);

	cmptr = CMSG_FIRSTHDR(&msg);
	cmptr->cmsg_len = CMSG_LEN(sizeof(int));
	cmptr->cmsg_level = SOL_SOCKET;
	cmptr->cmsg_type = SCM_RIGHTS;
	*((int *) CMSG_DATA(cmptr)) = sendfd;
#else
	msg.msg_accrights = (caddr_t) &sendfd;
	msg.msg_accrightslen = sizeof(int);
#endif

	msg.msg_name = NULL;
	msg.msg_namelen = 0;

	iov[0].iov_base = ptr;
	iov[0].iov_len = nbytes;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;

	return(sendmsg(fd, &msg, 0));
}


ssize_t
Write_fd(int fd, void *ptr, size_t nbytes, int sendfd)
{
	ssize_t		n;

	if ( (n = write_fd(fd, ptr, nbytes, sendfd)) < 0)
		fprintf(stderr, "write_fd error");

	return(n);
}


int sendfd(int sockfd, int fdtosend) {
  char sendbuf[2];
  
  Write_fd(sockfd, sendbuf, sizeof(sendbuf), fdtosend);

  return 0;
}


#else

int sendfd(int sockfd, int fdtosend) {

  struct iovec iov[1];
  struct msghdr msg;

  iov[0].iov_base = (char *) 0;
  iov[0].iov_len = 0;
  msg.msg_iov = iov;
  msg.msg_iovlen = 1;
  msg.msg_name = NULL;
  msg.msg_namelen = 0;

  /* if sockfd <= 0, we are in a world of jimmy crack corn. - AK */

  msg.msg_accrights = (caddr_t) &fdtosend;
  msg.msg_accrightslen = sizeof(fdtosend);

  Sendmsg(sockfd, &msg, 0);


  return 0;
}

#endif
