/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PerspectiveDescriptor
implements IPerspectiveDescriptor,
IPluginContribution {
    private String id;
    private String pluginId;
    private String originalId;
    private String label;
    private String className;
    private String description;
    private boolean singleton;
    private boolean fixed;
    private ImageDescriptor image;
    private IConfigurationElement configElement;
    private static final String ATT_ID = "id";
    private static final String ATT_DEFAULT = "default";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_CLASS = "class";
    private static final String ATT_SINGLETON = "singleton";
    private static final String ATT_FIXED = "fixed";

    public PerspectiveDescriptor(String id, String label, PerspectiveDescriptor originalDescriptor) {
        this.id = id;
        this.label = label;
        if (originalDescriptor != null) {
            this.originalId = originalDescriptor.getOriginalId();
            this.image = originalDescriptor.image;
        }
    }

    public PerspectiveDescriptor(IConfigurationElement configElement, String desc) throws CoreException {
        this.configElement = configElement;
        this.id = configElement.getAttribute(ATT_ID);
        this.pluginId = configElement.getDeclaringExtension().getNamespace();
        this.label = configElement.getAttribute(ATT_NAME);
        this.className = configElement.getAttribute(ATT_CLASS);
        this.singleton = configElement.getAttributeAsIs(ATT_SINGLETON) != null;
        String str = configElement.getAttribute(ATT_FIXED);
        if (str != null && str.equalsIgnoreCase("true")) {
            this.fixed = true;
        }
        this.description = desc;
        if (this.label == null || this.className == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
        String icon = configElement.getAttribute(ATT_ICON);
        if (icon != null) {
            IExtension extension = configElement.getDeclaringExtension();
            String extendingPluginId = extension.getNamespace();
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, icon);
        }
    }

    public IPerspectiveFactory createFactory() throws CoreException {
        IConfigurationElement element = this.configElement;
        if (this.originalId != null) {
            IPerspectiveDescriptor desc = ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).findPerspectiveWithId(this.originalId);
            if (desc != null) {
                element = ((PerspectiveDescriptor)desc).configElement;
            }
            if (element == null) {
                return null;
            }
        } else if (this.className == null || element == null) {
            return null;
        }
        Object obj = WorkbenchPlugin.createExtension(element, ATT_CLASS);
        return (IPerspectiveFactory)obj;
    }

    public void deleteCustomDefinition() {
        ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).deleteCustomDefinition(this);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOriginalId() {
        if (this.originalId == null) {
            return this.id;
        }
        return this.originalId;
    }

    public boolean hasCustomDefinition() {
        return ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).hasCustomDefinition(this);
    }

    public boolean hasDefaultFlag() {
        if (this.configElement == null) {
            return false;
        }
        String str = this.configElement.getAttribute(ATT_DEFAULT);
        if (str == null) {
            return false;
        }
        return str.equals("true");
    }

    public boolean isPredefined() {
        return this.className != null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public IStatus restoreState(IMemento memento) {
        IMemento childMem = memento.getChild("descriptor");
        if (childMem != null) {
            this.id = childMem.getString(ATT_ID);
            this.originalId = childMem.getString("descriptor");
            this.label = childMem.getString("label");
            this.className = childMem.getString(ATT_CLASS);
            this.singleton = childMem.getInteger(ATT_SINGLETON) != null;
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.getOriginalId());
            if (descriptor != null) {
                this.image = descriptor.image;
            }
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void revertToPredefined() {
        if (this.isPredefined()) {
            this.deleteCustomDefinition();
        }
    }

    public IStatus saveState(IMemento memento) {
        IMemento childMem = memento.createChild("descriptor");
        childMem.putString(ATT_ID, this.id);
        if (this.originalId != null) {
            childMem.putString("descriptor", this.originalId);
        }
        childMem.putString("label", this.label);
        childMem.putString(ATT_CLASS, this.className);
        if (this.singleton) {
            childMem.putInteger(ATT_SINGLETON, 1);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public boolean fromPlugin() {
        return this.pluginId != null;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

