/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import swingwt.awt.AWTEvent;
import swingwt.awt.Component;
import swingwt.awt.ComponentOrientation;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ContainerEvent;
import swingwt.awt.event.ContainerListener;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class Container
extends Component {
    public Composite composite = null;
    protected LayoutManager layout = null;
    protected Vector comps = new Vector();
    protected Vector containerListeners = new Vector();
    protected boolean queuedValidateRequest = false;

    public Dimension getMinimumSize() {
        return this.layout == null ? super.getMinimumSize() : this.layout.minimumLayoutSize(this);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.layout == null ? super.getPreferredSize() : this.layout.preferredLayoutSize(this);
    }

    public Dimension getMaximumSize() {
        return this.layout instanceof LayoutManager2 ? ((LayoutManager2)this.layout).maximumLayoutSize(this) : super.getMaximumSize();
    }

    public void addContainerListener(ContainerListener l) {
        this.containerListeners.add(l);
    }

    public void removeContainerListener(ContainerListener l) {
        this.containerListeners.remove(l);
    }

    public Component add(Component c) {
        return this.doAdd(c);
    }

    public Component add(Component c, int index) {
        return this.add(c);
    }

    public Component doAdd(final Component c) {
        if (c == null) {
            return null;
        }
        final Container me = this;
        if (this.comps.indexOf(c) == -1) {
            this.comps.add(c);
        }
        c.parent = this;
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.composite)) {
            return c;
        }
        this.addComponentToLayout(c);
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                try {
                    c.setSwingWTParent(me);
                    c.setCachedProperties();
                    c.registerEvents();
                    Container.this.processContainerEvent(new ContainerEvent(me, 300, c));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Container.this.queuedValidate();
            }
        });
        return c;
    }

    protected void processEvent(AWTEvent e) {
    }

    protected void processContainerEvent(ContainerEvent e) {
        if (this.containerListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            if (e.getID() == 300) {
                ((ContainerListener)this.containerListeners.get(i)).componentAdded(e);
                continue;
            }
            ((ContainerListener)this.containerListeners.get(i)).componentRemoved(e);
        }
    }

    public void addComponentToLayout(Component c) {
        if (this.layout != null) {
            if (this.layout instanceof LayoutManager2) {
                ((LayoutManager2)this.layout).addLayoutComponent(c, c.layoutModifier);
            } else {
                this.layout.addLayoutComponent(c.getName(), c);
            }
        }
    }

    public void invalidate() {
        final Container me = this;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.composite) && this.layout != null) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    Container.this.layout.layoutContainer(me);
                }
            });
        }
    }

    public void doLayout() {
        this.invalidate();
    }

    public void validate() {
        this.invalidate();
    }

    public void revalidate() {
        this.invalidate();
    }

    public void queuedValidate() {
        if (this.queuedValidateRequest) {
            return;
        }
        this.queuedValidateRequest = true;
        SwingUtilities.invokeIn(new Runnable(){

            public void run() {
                Container.this.invalidate();
                Container.this.queuedValidateRequest = false;
            }
        }, 1);
    }

    public void add(Component c, Object layoutModifier) {
        if (c == null) {
            return;
        }
        c.layoutModifier = layoutModifier;
        if (layoutModifier instanceof String) {
            this.layout.addLayoutComponent((String)layoutModifier, c);
        }
        this.doAdd(c);
    }

    public void add(Component c, Object layoutModifier, int index) {
        this.add(c, layoutModifier);
    }

    public Component add(String name, Component c) {
        this.add(c, name);
        return c;
    }

    public void dispose() {
        if (this.comps != null) {
            for (int i = 0; i < this.comps.size(); ++i) {
                try {
                    ((Component)this.comps.get(i)).dispose();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.comps.removeAllElements();
        }
        if (this.peer != null) {
            super.dispose();
        }
        this.composite = null;
        this.peer = null;
    }

    public void remove(Component c) {
        this.comps.remove(c);
        if (this.layout != null) {
            this.layout.removeLayoutComponent(c);
        }
        c.componentOnlyDispose();
        c.setComponentRemoved();
        this.processContainerEvent(new ContainerEvent(this, 301, c));
        this.invalidate();
    }

    public void remove(int index) {
        Component c = (Component)this.comps.get(index);
        this.remove(c);
    }

    public void removeAll() {
        for (int i = 0; i < this.comps.size(); ++i) {
            Component c = (Component)this.comps.get(i);
            this.remove(c);
        }
        this.comps.removeAllElements();
        this.invalidate();
    }

    public void removeComponentFromCache(Component c) {
        this.comps.remove(c);
    }

    public LayoutManager getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutManager l) {
        this.setLayoutImpl(l);
    }

    protected void setLayoutImpl(LayoutManager l) {
        this.layout = l;
        if (this.composite == null) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Container.this.composite.setLayout(null);
                Container.this.composite.addListener(11, new Listener(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleEvent(Event e) {
                        4.access$000(this.this$1).invalidate();
                    }
                });
            }

            static /* synthetic */ Container access$000(4 x0) {
                return x0.Container.this;
            }
        });
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        if (this.layout != null) {
            this.setLayoutImpl(this.layout);
        }
        if (this.comps.size() > 0) {
            Object[] obs = this.comps.toArray();
            for (int i = 0; i < obs.length; ++i) {
                Component c = (Component)obs[i];
                this.doAdd(c);
            }
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public int getComponentCount() {
        return this.comps.size();
    }

    public Component getComponent(int i) {
        return (Component)this.comps.get(i);
    }

    public Component[] getComponents() {
        Object[] comp = this.comps.toArray();
        Component[] cps = new Component[comp.length];
        for (int i = 0; i < comp.length; ++i) {
            cps[i] = (Component)comp[i];
        }
        return cps;
    }

    public void debug_showContainmentTree() {
        System.out.println("Containment Tree: ====================");
        System.out.println(this.getClass().getName());
        this.xdebug_showChildren(this, 1);
    }

    private void xdebug_showChildren(Container c, int level) {
        String SPACE = "                   ";
        for (int i = 0; i < c.comps.size(); ++i) {
            Component d = (Component)c.comps.get(i);
            System.out.println("                   ".substring(0, level) + d.getClass().getName());
            if (!(d instanceof Container)) continue;
            this.xdebug_showChildren((Container)d, level + 1);
        }
    }
}

