/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import swingwt.awt.Dimension;
import swingwt.awt.TextComponent;
import swingwtx.accessibility.AccessibleContext;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTextArea;
import swingwtx.swing.text.BadLocationException;

public class TextArea
extends TextComponent {
    public static final int SCROLLBARS_NONE = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_BOTH = 3;

    public TextArea() {
        this("");
    }

    public TextArea(String text) {
        this(text, 0, 0);
    }

    public TextArea(int rows, int columns) {
        this("", rows, columns);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int scrollbars) {
        this.swingPeer = new JTextArea(text, rows, columns);
        this.setScrollbarVisibility(scrollbars);
    }

    private final JTextArea getSwingPeer() {
        return (JTextArea)this.swingPeer;
    }

    private void setScrollbarVisibility(int scrollbars) {
        boolean horizontal = (scrollbars | 2) != 0;
        boolean vertical = (scrollbars | 1) != 0;
        this.getSwingPeer().setHorizontalScrollPane(horizontal);
        this.getSwingPeer().setVerticalScrollPane(vertical);
    }

    public int getScrollbarVisibility() {
        int scrollbar = 0;
        scrollbar |= this.getSwingPeer().getHorizontalScrollPane() ? 2 : 0;
        return scrollbar |= this.getSwingPeer().getVerticalScrollPane() ? 1 : 0;
    }

    public void setScrollPane(JScrollPane container) {
        this.getSwingPeer().setScrollPane(container);
    }

    public AccessibleContext getAccessibleContext() {
        return this.getSwingPeer().getAccessibleContext();
    }

    public int getColumns() {
        return this.getSwingPeer().getColumns();
    }

    public int getRows() {
        return this.getSwingPeer().getRows();
    }

    public Dimension getMinimumSize(int rows, int columns) {
        return this.getSwingPeer().getMinimumSize();
    }

    public Dimension getPreferredSize(int rows, int columns) {
        return this.getSwingPeer().getPreferredSize();
    }

    public void append(String str) {
        this.appendText(str);
    }

    public void appendText(String str) {
        String text = this.getText();
        String newStr = this.getText() + str;
        this.setText(newStr);
        this.setCaretPosition(newStr.length() + 1);
    }

    public void insert(String str, int pos) {
        this.insertText(str, pos);
    }

    public void insertText(String str, int pos) {
        try {
            this.getSwingPeer().getDocument().insertString(pos, str, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void replaceRange(String str, int start, int end) {
        this.replaceText(str, start, end);
    }

    public void replaceText(String str, int start, int end) {
        String text = this.getText();
        String newStr = "";
        if (start != 0) {
            newStr = text.substring(0, start - 1);
        }
        newStr = newStr + str;
        newStr = newStr + text.subSequence(start, end);
        this.setText(newStr);
        int newPos = newStr.length() - text.length() + end;
        this.setCaretPosition(newPos);
    }

    public void setColumns(int columns) {
        this.getSwingPeer().setColumns(columns);
    }

    public void setRows(int rows) {
        this.getSwingPeer().setRows(rows);
    }
}

