/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ProgressBar;
import swingwt.awt.Container;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JProgressBar
extends JComponent
implements SwingConstants {
    private ProgressBar ppeer = null;
    private int pMin = 0;
    private int pMax = 0;
    private int pValue = 0;
    private int pOrientation = 0;
    private boolean pIndeterminate = false;

    public JProgressBar() {
    }

    public JProgressBar(int orient) {
        this.pOrientation = orient;
    }

    public JProgressBar(int min, int max) {
        this.pMin = min;
        this.pMax = max;
    }

    public JProgressBar(int orient, int min, int max) {
        this.pMin = min;
        this.pMax = max;
        this.pOrientation = orient;
    }

    public void setMaximum(final int max) {
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                JProgressBar.this.setMaximumT(max);
            }
        });
    }

    public void setMinimum(final int min) {
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                JProgressBar.this.setMinimumT(min);
            }
        });
    }

    public int getOrientation() {
        return this.pOrientation;
    }

    public void setOrientation(int orientation) {
        this.pOrientation = orientation;
    }

    public boolean isIndeterminate() {
        return this.pIndeterminate;
    }

    public void setIndeterminate(boolean b) {
        this.pIndeterminate = b;
    }

    public void setValue(final int value) {
        this.pValue = value;
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                JProgressBar.this.setValueT(value);
            }
        });
    }

    protected void setMaximumT(int max) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.pMax = max;
        } else {
            this.ppeer.setMaximum(max);
        }
    }

    protected void setMinimumT(int min) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.pMin = min;
        } else {
            this.ppeer.setMinimum(min);
        }
    }

    protected void setValueT(int value) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.ppeer.setSelection(value);
        }
    }

    public int getMaximum() {
        return this.pMax;
    }

    public int getMinimum() {
        return this.pMin;
    }

    public int getValue() {
        return this.pValue;
    }

    public double getPercentComplete() {
        return (double)(this.getValue() - this.getMinimum()) / (double)(this.getMaximum() - this.getMinimum()) * 100.0;
    }

    public void setStringPainted(boolean b) {
    }

    public boolean getStringPainted() {
        return false;
    }

    public void setString(String s) {
    }

    public String getString() {
        return "";
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new ProgressBar(parent.getComposite(), 0x800 | (this.pIndeterminate ? 2 : 0) | (!SWT.getPlatform().equals("win32") ? 65536 : 0) | (this.pOrientation == 0 ? 256 : 512));
        this.ppeer.setMaximum(this.pMax);
        this.ppeer.setMinimum(this.pMin);
        this.ppeer.setSelection(this.pValue);
        this.peer = this.ppeer;
        this.parent = parent;
    }
}

