'\"
'\" Generated from domDoc.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH domDoc n "" Tcl ""
.BS
.SH NAME
domDoc \- Manipulates an instance of a DOM document object
.SH SYNOPSIS
.nf
\&\fBdomDocObjCmd\fP \fImethod\fR ?\fIarg arg ...\fR?
.fi
.BE
.SH "DESCRIPTION "
.PP
This command manipulates one particular instance of a document
object. \fImethod\fR indicates a specific method of the document class. These
methods should closely conform to the W3C recommendation "Document Object Model
(Core) Level 1" (http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html). Look
at these documents for a deeper understanding of the functionality.
.PP
The valid methods are:
.TP
\&\fB\fBdocumentElement\fP ?\fIobjVar\fB?
\&\fRReturns the top most element in the document (the root
element).
.TP
\&\fB\fBgetElementsByTagName\fP \fIname\fB
\&\fRReturns a list of all elements in the document matching
(glob style) \fIname\fR.
.TP
\&\fB\fBgetElementsByTagNameNS\fP \fIuri\fB \fIlocalname\fB
\&\fR Returns a list of all elements in the subtree
matching (glob style) \fIlocalname\fR and having the given namespace
\&\fIuri\fR.
.TP
\&\fB\fBcreateElement\fP \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node with node name
\&\fItagName\fR, append it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given the new
node object store in this variable.
.TP
\&\fB\fBcreateElementNS\fP \fIurl\fB \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node within a namespace
having \fIuri\fR as the URI and node name \fItagName\fR, which
could include the namespace prefix, append it to the hidden fragment list in
the document object and returns the node object.  If \fIobjVar\fR is
given the new node object store in this variable.
.TP
\&\fB\fBcreateTextNode\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new text node with node value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateComment\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new comment node with value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
comment node object is stored in this variable.
.TP
\&\fB\fBcreateCDATASection\fP \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new CDATA node with node value
\&\fIdata\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateProcessingInstruction\fP \fItarget\fB \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates a process instruction, appends it to the hidden
fragment list in the document object and returns the node object.  If
\&\fIobjVar\fR is given, the new node object is stored in this variable.
.TP
\&\fB\fBdelete\fP
\&\fRExplicitly deletes the document, including the associated
Tcl object commands (for nodes, fragment/new nodes, the document object itself)
and the underlying DOM tree.
.TP
\&\fB\fBgetDefaultOutputMethod\fP
\&\fRReturns the default output method of the document. This is
usually a result of a XSLT transformation.
.TP
\&\fB\fBasXML\fP \fB?-indent none/1..8?\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB-doctypeDeclaration <boolean>\fP
\&\fRReturns the DOM tree as an (optional indented) XML string or
sends the output directly to the given channelId. If the option
\&\fI-escapeNonASCII\fR is given, every non 7 bit ASCII character in attribute
values or element PCDATA content will be escaped as character reference in
decimal representation. The flag \fI-doctypeDeclaration\fR determines, whether
there will be a DOCTYPE declaration emitted before the first node of the
document. The default is, to do not. The DOCTYPE name will always be the
element name of the document element. An external entity declaration of the
external subset is only emitted, if the document has a system identifier.
.TP
\&\fB\fBasHTML\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB?-htmlEntities?\fP \fB-doctypeDeclaration <boolean>\fP
\&\fRReturns the DOM tree serialized acording to HTML rules (HTML
elements are recognized regardless of case, without end tags for emtpy HTML
elements etc.), as string or sends the output directly to the given
channelId. If the option \fI-escapeNonASCII\fR is given, every non 7 bit ASCII
character in attribute values or element PCDATA content will be escaped as
character reference in decimal representation. If the option
\&\fI-htmlEntities\fR is given, a character is outputed using a HTML 4.01
character entity reference, if one is defined for it. The flag
\&\fI-doctypeDeclaration\fR determines, whether there will be a DOCTYPE
declaration emitted before the first node of the document. The default is, to
do not. The DOCTYPE name will always be the element name of the document
element without case normalization. An external entity declaration of the
external subset is only emitted, if the document has a system identifier. The
doctype declaration will be written from the avaliable informations, without
check, if this is a known (w3c) HTML version information or if the document
confirms to the given HTML version.
.TP
\&\fB\fBpublicId\fP \fI?publicId?\fB
\&\fRReturns the public identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the public identifier of the document is set to this
value.
.TP
\&\fB\fBsystemId\fP \fI?systemId?\fB
\&\fRReturns the system identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the system identifier of the document is set to this
value.
.TP
\&\fB\fBxslt\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-xsltmessagecmd script?\fP \fIstylesheet\fB \fI?outputVar?\fB
\&\fRApplies an XSLT transformation on the whole document of the node
object using the XSLT \fIstylesheet\fR (given as domDoc). Returns a document
object containing the result document of the transformation and stores that
document object in the optional \fIoutputVar\fR, if that was given.
.RS
.PP
The optional \fI-parameters\fR option sets top level
<xsl:param> to string values. The \fIparameterList\fR has to be a tcl
list consisting of parameter name and value pairs.
.PP
If the option \fI-ignoreUndeclaredParameters\fR is given, then parameter
names in the \fIparameterList\fR given to the \fI-parameters\fR options that
are not declared as top-level parameters in the stylesheet are silently
ignored. Without this option, an error is raised, if the user tries to set a
top-level parameter, which is not declared in the stylesheet.
.PP
The \fI-xsltmessagecmd\fR option sets a callback for xslt:message elements
in the stylesheet. The actual command consists of the script, given as argument
to the option, appended with the XML Fragment from instantiating the
xsl:message element content as string (as if the XPath string() function would
have been applied to the XML Fragment) and a flag, which indicates, if the
xsl:message has an attribute "terminate" with the value "yes".
.RE
.TP
\&\fB\fBtoXSLTcmd\fP ?\fIobjVar\fB?
\&\fRIf the DOM tree represents a valid XSLT stylesheet, this method
transforms the DOM tree into a xslt command, otherwise it returns error. The
created xsltCmd is returnd and stored in the \fIobjVar\fR, if a var name was
given. A successful transformation of the DOM tree to a xsltCmd removes the
domDoc cmd and all nodeCmds of the document.
.RS
.PP
The syntax of the created xsltCmd is:

 

.CS

\&\fBxsltCmd\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-xsltmessagecmd script?\fP \fIdocNode\fR \fI?outputVar?\fR

.CE
.PP
The options are the same as for the domDoc \fIxslt\fR method; see there for
a description. The \fIdocNode\fR argument is the XML document to transform
(given as domDoc). The command returns a document object containing the result
document of the transformation and stores it in the optional \fIoutputVar\fR,
if that was given.
.RE
.PP
Otherwise, if an unknown method name is given, the command with the
same name as the given metho within the namespace \fB::dom::domDoc\fR is
tried to be executed. This allows quick method additions on Tcl level.
.PP
Newly created nodes are appended to a hidden fragment list. If there
are not moved into the tree they are automaticaly deleted, when the whole
document gets deleted.
.SH "SEE ALSO"
dom, domNode
.SH KEYWORDS
DOM node creation, document element
