/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef APP_H_INCLUDED
#define APP_H_INCLUDED

#include <string>

#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/statusbar.h>
#include <gtk--/window.h>

#include "thoughttracker.h"
#include "database.h"
#include "entry.h"
#include "menubar.h"
#include "search.h"

class TTApplication : public Gtk::Window {
  public:
    TTApplication(const string &data_directory);
    virtual ~TTApplication() {};

    /* outputs <msg> on the status bar */
    virtual void sbar_msg(string msg) const {
      w.sbar->push(w.sbar->get_context_id("status"), msg);
    };

    /* loads/saves the config file */
    virtual void load_config();
    virtual void save_config();

    /* sets/returns the active entry ID to <id>; use -1 to clear */
    virtual void set_active(dbid_t id);
    virtual dbid_t get_active() const { return active; };

  private:
    friend class TTEntryWidget;
    friend class TTOptionsDialog;
    friend class TTSearchWidget;
    friend class TTMenuBar;

    static const char *cfgfile_name;
    string data_dir;

    TTDatabase db;
    struct {  // widgets
      Gtk::VBox *mainbox;
      TTMenuBar *mbar;
      TTEntryWidget *entry;
      TTSearchWidget *search;
      Gtk::Statusbar *sbar;
    } w;
    struct {  // options
      string fixedfont;   // name of font used as fixed width font
      bool fixeddefault;  // use fixed font by default for details fields
      bool autolink;      // suggest linking new and previously viewed entries
      bool quicksearch;   // immediately show single search results
      bool nolistlimit;   // don't truncate the list of search results
      bool savesize;      // save the main window's size
      gint panepos;       // initial pane position
    } opts;
    dbid_t prev_active, active;  // (previously) active entry's ID

    /* switches to the entry widget */
    virtual void run_entry() const;

    /* switches to the search widget */
    virtual void run_search() const;

    /* event handlers */
    virtual int delete_event_impl(GdkEventAny *event);

    /* prints an error message (adding a line feed) and exits after
       rudimentary clean-up */
    void die(const string&);

    /* in config file parsing, evaluates a value and sets a boolean variable
       accordingly; return whether the value could be evaluated */
    bool parse_bool_opt(bool &opt, const string &val);
};

#endif  /* APP_H_INCLUDED */

