/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef QUERYDLG_H_INCLUDED
#define QUERYDLG_H_INCLUDED

#include <string>

#include <gtk--/button.h>
#include <gtk--/window.h>

#include "thoughttracker.h"

typedef enum {
  TTQD_BTN_NONE   = 0,
  TTQD_BTN_OK     = 1<<0,
  TTQD_BTN_YES    = 1<<1,
  TTQD_BTN_NO     = 1<<2,
  TTQD_BTN_CANCEL = 1<<3
} TTQDButtons;

class TTQueryDialog : public Gtk::Window {
  public:
    TTQueryDialog(Gtk::Window *transient, char **xpm, const string &title,
	  const string &text, int buttons = TTQD_BTN_OK,
      TTQDButtons default_button = TTQD_BTN_OK);
    virtual ~TTQueryDialog() {};

    /* runs the dialog and returns the pressed button (if the user closes
       the pop-up dialog window via e.g. its title bar close button,
       TTDQ_BTN_CANCEL is returned) */
    virtual TTQDButtons run();

  private:
    Gtk::Button *def_btn;  // pointer to default button's widget
    TTQDButtons pressed;  // the button that was pressed

    /* handles the "clicked" event of a button of type <type> */
    virtual void button_press(TTQDButtons type) { pressed = type; };

    /* handles "delete" events */
    virtual int delete_event_impl(GdkEventAny *event) {
      pressed = TTQD_BTN_CANCEL;
      return 0;
    };
};

typedef enum {
  TTQD_ERROR_UNIMPLEMENTED,
  TTQD_ERROR_DB_READ,
  TTQD_ERROR_DB_WRITE,
  TTQD_ERROR_SEARCH,
  TTQD_ERROR_IMPOSSIBLE_SITUATION
} TTQDInternalError;

/* displays an informative message */
void message_popup(Gtk::Window *transient, const string &title,
  const string &text);

/* displays a casual error message */
void error_popup(Gtk::Window *transient, const string &text);

/* displays an internal error message for <code> */
void internal_error_popup(Gtk::Window *transient, TTQDInternalError code);

/* displays a popup prompting the user to press one button or other */
TTQDButtons query_popup(Gtk::Window *transient, const string &title,
  const string &text, int buttons, TTQDButtons default_button);

#endif  /* QUERYDLG_H_INCLUDED */

