#!/bin/bash

# Run from the toolchain-source root

DIR=`pwd`
TMP=/tmp/tool-tmp
mkdir $TMP
cd $TMP
apt-get source binutils
apt-get source gcc-3.0
cd $DIR

REBUILD=0

# Update gcc
NEW=`basename $TMP/gcc-*/gcc-*.tar.bz2 | sed -e s/gcc-// | sed -e s/.tar.bz2//`
CURR=`basename gcc-*.tar.bz2 | sed -e s/gcc-// | sed -e s/.tar.bz2//`
if dpkg --compare-versions $NEW gt $CURR; then
  echo new gcc: $NEW
  rm gcc-*.tar.bz2
  cp $TMP/gcc-*/gcc-*.tar.bz2 .
  dch -v $NEW-1 "Upstream release of gcc $NEW"
  REBUILD=1
fi

# Update binutils
NEW=`basename $TMP/binutils-*/binutils-*.tar.bz2 | sed -e s/binutils-// | sed -e s/.tar.bz2//`
CURR=`basename binutils-*.tar.bz2 | sed -e s/binutils-// | sed -e s/.tar.bz2//`
if dpkg --compare-versions $NEW gt $CURR; then
  echo new binutils: $NEW
  rm binutils-*.tar.bz2
  cp $TMP/binutils-*/binutils-*.tar.bz2 .
  dch "Upstream release of binutils $NEW"
  REBUILD=1
fi

if [ $REBUILD == 1 ]; then
  debuild
  su -c debi
  debrelease
fi

rm -r $TMP
