/*
	**
	** sort-report.h
	**
	** Sorts hosts and peers lists
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: sort-report.h,v 1.2 1999/02/04 10:22:42 dmiller Exp $
	**
 */

#ifndef _SORT_REPORT_H
#define _SORT_REPORT_H

#define SORT_NONE 					0
#define SORT_BYTES					1
#define SORT_BYTES_SENT 			2
#define SORT_BYTES_RECEIVED		3
#define SORT_PACKETS 				4
#define SORT_PACKETS_SENT  		5
#define SORT_PACKETS_RECEIVED 	6
#define SORT_CONNECTS				7
#define SORT_CONNECTS_SENT 		8
#define SORT_CONNECTS_RECEIVED	9
#define SORT_PEERS					10
#define SORT_HOSTNAME				11
#define SORT_IP_ADDR					12
#define SORT_FIRST_SEEN				13
#define SORT_LAST_SEEN				14
#define SORT_RANDOM					15

#define SORT_HOST_DEFAULT  		SORT_BYTES
#define SORT_PEER_DEFAULT  		SORT_BYTES

#include "report.h"

/* Sorts hosts table */
host_t	*sort_hosts(host_t *host_list, int host_sort_mode, int host_reverse);

/* Sort peers list */
peer_t	*sort_peers(peer_t *peer_list, int peer_sort_mode, int peer_reverse);

/* Sort all peer lists */
void sort_all_peers(host_t *h, int peer_sort_mode, int peer_reverse);

/* Parses textual host sort key into numeric identifier */
int parse_host_sort_mode(const char *sort_mode);

/* Parses textual peer sort key into numeric identifier */
int parse_peer_sort_mode(const char *sort_mode);

#endif /* _SORT_REPORT_H */
