#include <stdio.h>

#include "capanel.h"
#include "catrophy.h"

/** Constructor.
*/
CAPanel::CAPanel() {
    for( int c=0; c<CA_MAXPLAYERS; ++c ) {
        playerView[c] = new CAPlayerView( CA_APP->player[c] );
    }
}


/** Destructor.
*/
CAPanel::~CAPanel() {}


/** Displays the panel.
*/
void
CAPanel::display() {
    CL_Display::fill_rect( 0, 0, 120, CA_APP->height, 0.0,0.0,0.0,1.0 );

    CA_RES->panel_label->put_screen( 0,0 );

    // Display time:
    //
    CA_RES->font_lcd_13_green->print_left( 20, 30, CA_APP->getTimeString() );

    // Display speed view:
    //
    int speedIndex = (int)fabs(CA_APP->player[0]->getSpeed() / CA_APP->player[0]->getCarType()->maxSpeed * 10.0);
    if( speedIndex>10 ) speedIndex = 10;
    CA_RES->panel_speed->put_screen( 0, 57, speedIndex );

    // Display turbo view:
    //
    CA_RES->panel_turbolabel->put_screen( 0, 88 );
    int turboIndex = (int)fabs(CA_APP->player[0]->getTurbo() / CA_APP->player[0]->getCarType()->maxTurbo * 9.0);
    CA_RES->panel_turbo->put_screen( 0, 100, turboIndex );

    // Display player views:
    //
    for( int c=0; c<CA_MAXPLAYERS; ++c ) {
        playerView[c]->display( c+1 );
    }

    // Display frames per second:
    //
    static int counter=0;
    static int fps=0;
    counter++;

    if( counter > 200 ) {
        counter=0;
        fps = (int)(CA_APP->framesPerSec);
    }

    char str[16];
    sprintf( str, "FPS: %d", fps );
    CL_Display::fill_rect( 10, CA_APP->height-20, 110, CA_APP->height-10, 0.0,0.0,0.0,1.0 );
    CA_RES->font_normal_14_white->print_left( 10, CA_APP->height-20, str );
}



// EOF
