

#include "tse3/file/Write.h"

#include "tse3/file/XML.h"
#include "tse3/KeySigTrack.h"

#include <strstream>

void TSE3::File::write(XmlFileWriter &writer, TSE3::KeySigTrack &kst)
{
    TSE3::File::XmlFileWriter::AutoElement ae(writer, "KeySigTrack");

    writer.element("Status", kst.status());

    TSE3::File::XmlFileWriter::AutoElement ae2(writer, "Events");
    for (size_t n = 0; n < kst.size(); ++n)
    {
        // This will be a stringstream
        char buffer[256];
        std::ostrstream ev(buffer, 256);
        ev << kst[n].time << ":" << kst[n].data.incidentals
           << "/" << kst[n].data.type << std::ends;
        writer.element("Event", buffer);
    }
}
