#include "ttfprint.h"

#include <math.h>
#include <memory.h>
#include <ctype.h>
#include <string.h>

#ifdef SYSCC
struct adjust
  {
  int xcoor;
  int ycoor;
  };

  
struct adjust adjust_array[][2]=
	{
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{14,14}},
	{{0,0},{12.06,13.44}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{0,0}},
	{{0,0},{12.5,12.5}},
	{{0,0},{12.5,12.5}},
	{{0,0},{0,0}},
	{{0,0},{12.06,12.24}},
	{{0,0},{12.06,12.24}},
	{{0,0},{0,0}},
/*	{{0,0},(0,0}}*/
	};
#endif

#define PAPERS 16  


extern void q_prog();

extern PRECISION tm;	/* top margin           */
extern PRECISION bm;    /* bottom margin        */
extern PRECISION lm;    /* left margin          */
extern PRECISION rm;    /* right margin         */
extern PRECISION fs;    /* font size            */
extern PRECISION cs;    /* character space      */
extern PRECISION ls;    /* line space           */
extern int cpl;         /* char per line        */
extern int lpp;         /* line per page        */
/*int pt=A4;               paper type           */
extern pt;		/* paper type 		*/
extern int px;          /* paper width (in dot) */
extern int py;          /* paper width (in dot) */
extern int cx;          /* char per line        */
extern int cy;          /* line per page        */
extern BOOL land;	/* Landscape		*/
/*extern int font_dict;    number font dict     */
extern BOOL wrap;       /* wrap or not          */
extern BOOL pgno;	/* print Page no or not */
extern BOOL logps;	/* log ps data or not 	*/
extern FILE *ps_file;
/*extern FILE *mphdr_file;
extern FILE *hdr_file;*/
/*End global Variables for page description */     

extern char mphdr[];
/*extern char hdr_fn[];*/
extern char *hdr_path;
extern char hdr[];

extern char *psf_buffer;
extern char *fixpsf_buffer;

extern struct font_data fontpool[];
extern char *tm_str;
extern unsigned int page_count;                                                                                                               

void ttf2ps();

void print_file(FILE *tempfile,FILE *out_file)
  {
  FILE *hdr_file = NULL;
  char tempstr[MAXLINE*2],fontstr[6],charstr[MAXLINE*2],hdr_str[300];
  char hdr_fn[80];
  int i,j,font_seq;
  int line_count,ccount;
  int length,char_count,real_char;

  if ((psf_buffer = (char *) malloc(20480)) == NULL)
    {
    printf ("\n\a\aError allocate font outline for function print_file\n");
    q_prog (E_MALLOC,"psf_buffer");
    } 

  if (strcmp(mphdr,"@!~") != 0)
    {
    sprintf (hdr_fn,"%s/%s",hdr_path,mphdr);
    hdr_file = fopen (hdr_fn,"r");
    if (hdr_file == NULL)
      {
      printf ("Error opening multi-page header file %s\n\n",hdr_fn);
      q_prog (E_NO_MPHDRF,hdr_fn);
      }
    }
  else if (strcmp(hdr,"@!~") != 0)
    {
    fprintf (out_file,"\nBeginEPSF\n%%%%BeginDocument: Header\n");
    if (logps == TRUE)
      fprintf (ps_file,"\nBeginEPSF\n%%%%BeginDocument: Header\n");
    sprintf (hdr_fn,"%s/%s",hdr_path,hdr);
    hdr_file = fopen (hdr_fn,"rb");
    if (hdr_file == NULL)
      {
      printf ("Error opening header file %s\n\n",hdr_fn);
      q_prog (E_NO_HDRF,hdr_fn);
      }
      
    while (fgets(hdr_str,290,hdr_file))
      {
      fprintf (out_file,"%s",hdr_str);
      if (logps == TRUE)
        fprintf (ps_file,"%s",hdr_str);
      }
    
    fprintf (out_file,"\n%%%%EndDocument\nEndEPSF\n");
    
    if (logps == TRUE)
      fprintf (ps_file,"\n%%%%EndDocument\nEndEPSF\n");
    fclose (hdr_file);
    hdr_file = NULL;
    }  

  page_count = 0;
  line_count = 0;
  fseek (tempfile,0,SEEK_SET);

  while (fgets(tempstr,MAXLINE*2,tempfile))
    {
    ccount =0;
    char_count=0;
    real_char=0;
    
    if (line_count == 0)
      {
      if (hdr_file)
        {
        fseek (hdr_file,0,SEEK_SET);
        fprintf (out_file,"\nBeginEPSF\n%%%%BeginDocument: Header\n");
        if (logps == TRUE)
          fprintf (ps_file,"\nBeginEPSF\n%%%%BeginDocument: Header\n");
      
        while (fgets(hdr_str,290,hdr_file))
          {
          fprintf (out_file,"%s",hdr_str);
          if (logps == TRUE)
            fprintf (ps_file,"%s",hdr_str);
          }
    
        fprintf (out_file,"\n%%%%EndDocument\nEndEPSF\n");
    
        if (logps == TRUE)
          fprintf (ps_file,"\n%%%%EndDocument\nEndEPSF\n");
        }
      }
    
    length = strlen(tempstr);
    for (i = 0 ;i< length;i++)
      {
      /* flush out unprinted English characters */
      if (ccount > cpl)
        {
        if (char_count !=0)
          {
          for (j=0;j<char_count;j++)
            charstr[j]=tempstr[i-char_count+j];
          charstr[char_count]=0;
#ifdef SYSCC
          fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);   
#else
          fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);   
#endif 
          }
        if (wrap == FALSE)
          break;
        line_count++;
        if (line_count == lpp)
          {
          if (pgno == TRUE)
            {
            fprintf (out_file,"P (%d) Q\n",++page_count);
            if (logps == TRUE)
              fprintf (ps_file,"P (%d) Q\n",page_count);
            }
          else
            {
            fprintf (out_file,"P O\n");
            if (logps == TRUE)
              fprintf (ps_file,"P O\n");
            }
          line_count = 0;
          }
        ccount = 0;
        char_count = 0;
        real_char = 0;
        }
      
      
      /* printout the Chinese characters */
      if ((tempstr[i]=='\\') && (tempstr[i+1] == 'g') && (isxdigit(tempstr[i+2])))
        {
        if (char_count!=0)
          {
          for (j=0;j<char_count;j++)
            charstr[j]=tempstr[i-char_count+j];
          charstr[char_count]=0;
#ifdef  SYSCC
          fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
#else
          fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
#endif
          char_count = 0;
          real_char = 0;
	  }
	         
	fontstr[0]='0';
	fontstr[1]='x';   
        fontstr[2]=tempstr[i+2];
        fontstr[3]=tempstr[i+3];
        fontstr[4]=tempstr[i+4];
        fontstr[5]=0;
	sscanf(fontstr,"%x",&font_seq);

#ifdef SYSCC        
        if (fontpool[font_seq].dict == TRUE)
          {
	  fprintf (out_file,"%.1f %.1f N g%03x D\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,font_seq);
	  if (logps == TRUE)
	    fprintf (ps_file,"%.1f %.1f N g%03x D\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,font_seq);
	  }  
        else if (fontpool[font_seq].count != 1)
          {
          fprintf (out_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,fontpool[font_seq].outline);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,fontpool[font_seq].outline);
          }
        else
          {
          ttf2ps(fontpool[font_seq].code);
          fprintf (out_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,psf_buffer);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm-fs-ls+adjust_array[pt][land].ycoor,psf_buffer);
          }
#else
        if (fontpool[font_seq].dict == TRUE)
          {
	  fprintf (out_file,"%.1f %.1f N g%03x D\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,font_seq);
	  if (logps == TRUE)
	    fprintf (ps_file,"%.1f %.1f N g%03x D\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,font_seq);
	  }  
        else if (fontpool[font_seq].count != 1)
          {
          fprintf (out_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,fontpool[font_seq].outline);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,fontpool[font_seq].outline);
          }
        else
          {
          ttf2ps(fontpool[font_seq].code);
          fprintf (out_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,psf_buffer);
          if (logps == TRUE)
            fprintf (ps_file,"%.1f %.1f N %sD\n",ccount*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm-fs-ls,psf_buffer);
          }
#endif
        i= i+4;
        ccount = ccount + 2;
        }
      else 
      /* Process English characters */
        {
        if (tempstr[i] == FF)
          {

          if (char_count != 0)
            {
            charstr[char_count] = 0;
#ifdef SYSCC           
            fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
            if (logps == TRUE)
              fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
#else
            fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
            if (logps == TRUE)
              fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
#endif
            }

          if (pgno == TRUE)
            {
      	    fprintf (out_file,"P (%d) Q \n",++page_count);
      	    if (logps == TRUE)
      	      fprintf (ps_file,"P (%d) Q \n",page_count);
      	    }
      	  else
      	    {
      	    fprintf (out_file,"P O \n");
      	    if (logps == TRUE)
      	      fprintf (ps_file,"P O \n");
      	    }
    	  char_count = 0;
    	  ccount = 0;
    	  real_char = 0;
    	  line_count = 0;
          }
        
        /* Proecess special characters such as '\' '(' and ')' */
        else 
          {
          if ((tempstr[i]=='\\') && ((tempstr[i+1]=='(') || (tempstr[i+1]==')') ||(tempstr[i+1]=='\\')))
            charstr[char_count++] = tempstr[i++];
        
          real_char ++;
          ccount ++;
          charstr[char_count++] = tempstr[i];
          }
        }
      }
    
    
      if (char_count != 0)
        {
        charstr[char_count]=0;
#ifdef SYSCC
        fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
        if (logps == TRUE)
          fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm-adjust_array[pt][land].xcoor,py-line_count*(fs+ls)-tm+fs/6-fs-ls+adjust_array[pt][land].ycoor,(cs-fs/10),charstr);
#else
        fprintf (out_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
        if (logps == TRUE)
          fprintf (ps_file,"%.1f %.1f M %.2f 0 (%s) S\n",(ccount-real_char)*(fs+cs*2)/2+lm,py-line_count*(fs+ls)-tm+fs/6-fs-ls,(cs-fs/10),charstr);
#endif
        }    
      
      line_count ++;

    if (line_count == lpp)
      {
      if (pgno == TRUE)
        {
        fprintf (out_file,"P (%d) Q\n",++page_count);
        if (logps == TRUE)
          fprintf (ps_file,"P (%d) Q\n",page_count);
        }
      else
        {
        fprintf (out_file,"P O \n");
        if (logps == TRUE)
          fprintf (ps_file,"P O \n");
        }
      line_count = 0;
      }
    }
    
  if (line_count !=0)
    {
    if (pgno  == TRUE)
      {
      fprintf (out_file,"P (%d) Q\n",++page_count);
      if (logps == TRUE)
        fprintf (ps_file,"P (%d) Q\n",page_count);
      }  
    else
      {
      fprintf (out_file,"P O \n");
      if (logps == TRUE)
        fprintf (ps_file,"P O \n");
      }
    }
  }