#include "ttfprint.h"
#include "barcode.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

extern char *psf_buffer,*fixpsf_buffer;
extern int total_tplpage;
extern struct tpl_pagedata *tpl_page[];
/*extern char tpl_fn[];*/
extern char *tpl_path;
extern FILE *tpl_file;
extern FILE *out_file;
extern FILE *ps_file;
extern FILE *ttf_file;
extern void q_prog();
extern char cur_font_fn[];
extern char font_fn[];
extern char font_path[];
extern void ttf2ps();
extern BOOL logps;

static char tpl_fn[100];

void template()
  {
  int i,j;
  int ccount;
  struct tpl_cmd *tmpcmd;
  unsigned char hbyte,lbyte,code[2];
  char tpl_str[400];
  
  psf_buffer=fixpsf_buffer;
  if (total_tplpage != 0)
    for (i=1 ;i<=total_tplpage;i++)
      {
      if (tpl_page[i] != NULL)
        {
        if (tpl_page[i]->tpl_fn != NULL)
          {
          sprintf (tpl_fn,"%s/%s",tpl_path,tpl_page[i]->tpl_fn);
          if ((tpl_file = fopen (tpl_fn,"rb")) == NULL)
            {
            printf ("Error opening template file %s\n\n",tpl_fn);
            q_prog (E_NO_TPLF,tpl_fn);
            }

          fprintf (out_file,"\nBeginEPSF\n%%%%BeginDocument: template.%d\n",i);
            if (logps == TRUE)
              fprintf (ps_file,"\nBeginEPSF\n%%%%BeginDocument: template.%d\n",i);
          while (fgets(tpl_str,390,tpl_file))
            {
            fprintf (out_file,"%s",tpl_str);
            if (logps == TRUE)
              fprintf (ps_file,"%s",tpl_str);
            }
    
          fprintf (out_file,"\n%%%%EndDocument\nEndEPSF\n");
          if (logps == TRUE)
            fprintf (ps_file,"\n%%%%EndDocument\nEndEPSF\n");
          }
      
        tmpcmd = tpl_page[i]->cmdlist;
      
        while (tmpcmd != NULL)
          {
          switch (tmpcmd->cmd)
            {
            case TPL_HPRINT : if (strcmp(cur_font_fn,tmpcmd->ft) !=0)
                                {
                                strcpy (cur_font_fn,tmpcmd->ft);
                                sprintf (font_fn,"%s/%s.ttf",font_path,cur_font_fn);
                                ttf_file = fopen(font_fn,"rb");
                                if (ttf_file == NULL)
                                  {
                                  printf ("Error open ttf file %s \n",font_fn);
                                  q_prog(E_NO_FONTF,font_fn);
                                  }
                                }
                              fprintf (out_file,"\n\ngsave /Courier-Bold findfont %.2f scalefont setfont\n",tmpcmd->fs);
                              if (logps == TRUE)
                         	fprintf (ps_file,"\n\ngsave /Courier-Bold findfont %.2f scalefont setfont\n",tmpcmd->fs);       
                              for (j = 0;j < strlen(tmpcmd->print_str);j++)
          		        {
          		        hbyte =  tmpcmd->print_str[j];
            		        lbyte =  tmpcmd->print_str[j+1];
                                if ((hbyte > 0xa0) && (hbyte < 0xfa) && (((lbyte > 0x3f) &&(lbyte < 0x7f))\
|| ((lbyte > 0xa0) && (lbyte < 0xff))))
	    			  {
	    			  code[0]=hbyte;
	    			  code[1]=lbyte;
	    			  ttf2ps(code);
	    			  fprintf (out_file,"gsave %.2f %.2f translate %.4f dup scale newpath %s D\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor),tmpcmd->fs/1000 ,psf_buffer);
	    			  if (logps == TRUE)
	    			    fprintf (ps_file,"gsave %.2f %.2f translate %.4f dup scale newpath %s D\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor),tmpcmd->fs/1000 ,psf_buffer);
	    			  j++;
	    			  }
          		        else if ((hbyte == ')') || (hbyte == '('))
          		          {
            			  fprintf (out_file,"%.2f %.2f M (\\%c) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor + tmpcmd->fs/6),hbyte); 
            			  if (logps == TRUE)
            			    fprintf (ps_file,"%.2f %.2f M (\\%c) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor + tmpcmd->fs/6),hbyte); 
            			  }
	  		        else if (hbyte =='\\')
	  		          {
	    			  fprintf (out_file,"%.2f %.2f M (\\\\) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor + tmpcmd->fs/6));
	    			  if (logps == TRUE)
	    			    fprintf (ps_file,"%.2f %.2f M (\\\\) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor + tmpcmd->fs/6));
	    			  }  
	  		        else
	  		          {
    	    			  fprintf (out_file,"%.2f %.2f M (%c) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor+tmpcmd->fs/6),hbyte);
    	    			  if (logps == TRUE)
    	    			    fprintf (ps_file,"%.2f %.2f M (%c) show\n",tmpcmd->xcoor+((tmpcmd->fs+tmpcmd->cs*2)*j/2),(float) (tmpcmd->ycoor+tmpcmd->fs/6),hbyte);
    	    			  }
          		        }
          		      fprintf (out_file,"grestore\n");
          		      if (logps == TRUE)
          		        fprintf (ps_file,"grestore\n");
          		      break;
            case TPL_VPRINT : if (strcmp(cur_font_fn,tmpcmd->ft) !=0)
                                {
                                strcpy (cur_font_fn,tmpcmd->ft);
                                sprintf (font_fn,"%s/%s.ttf",font_path,cur_font_fn);
                                ttf_file = fopen(font_fn,"rb");
                                if (ttf_file == NULL)
                                  {
                                  printf ("Error open ttf file %s \n",font_fn);
                                  q_prog (E_NO_FONTF,font_fn);
                                  }
                                }
                              ccount = 0;
                              fprintf (out_file,"\n\ngsave /Courier-Bold findfont %.2f scalefont setfont\n",tmpcmd->fs);
                              if (logps== TRUE)
                                fprintf (ps_file,"\n\ngsave /Courier-Bold findfont %.2f scalefont setfont\n",tmpcmd->fs);
                              for (j = 0;j < strlen(tmpcmd->print_str);j++)
          		        {
          		        hbyte =  tmpcmd->print_str[j];
            		        lbyte =  tmpcmd->print_str[j+1];
                                if ((hbyte > 0xa0) && (hbyte < 0xfa) && (((lbyte > 0x3f) &&(lbyte < 0x7f))\
|| ((lbyte > 0xa0) && (lbyte < 0xff))))
	    			  {
	    			  code[0]=hbyte;
	    			  code[1]=lbyte;
	    			  ttf2ps(code);
	    			  fprintf (out_file,"gsave %.2f %.2f translate %.4f dup scale newpath %s D\n",tmpcmd->xcoor,tmpcmd->ycoor - (tmpcmd->fs + tmpcmd->cs) * ccount,tmpcmd->fs/1000,psf_buffer);
	    			  if (logps == TRUE)
	    			    fprintf (ps_file,"gsave %.2f %.2f translate %.4f dup scale newpath %s D\n",tmpcmd->xcoor,tmpcmd->ycoor - (tmpcmd->fs + tmpcmd->cs) * ccount,tmpcmd->fs/1000,psf_buffer);
	    			  ccount++;
	    			  j++;
	    			  }
          		        else if ((hbyte == ')') || (hbyte == '('))
          		          {
            			  fprintf (out_file,"%.2f %.2f M (\\%c) show\n",tmpcmd->xcoor+tmpcmd->fs/4,(tmpcmd->ycoor-(tmpcmd->fs+tmpcmd->cs) * ccount++ + tmpcmd->fs/6),hbyte);
            			  if (logps == TRUE)
            			    fprintf (ps_file,"%.2f %.2f M (\\%c) show\n",tmpcmd->xcoor+tmpcmd->fs/4,(tmpcmd->ycoor-(tmpcmd->fs+tmpcmd->cs) * (ccount-1) + tmpcmd->fs/6),hbyte);
            			  }
	  		        else if (hbyte == '\\')
	  		          {
	    			  fprintf (out_file,"%.2f %.2f M (\\\\) show\n",tmpcmd->xcoor + tmpcmd->fs/4,(tmpcmd->ycoor - (tmpcmd->fs + tmpcmd->cs) * ccount++ + tmpcmd->fs/6));
	    			  if (logps == TRUE)
	    			    fprintf (ps_file,"%.2f %.2f M (\\\\) show\n",tmpcmd->xcoor + tmpcmd->fs/4,(tmpcmd->ycoor - (tmpcmd->fs + tmpcmd->cs) * (ccount-1) + tmpcmd->fs/6));
	    			  }
	  		        else 
	  		          {
    	    			  fprintf (out_file,"%.2f %.2f M (%c) show\n",tmpcmd->xcoor+tmpcmd->fs/4,(tmpcmd->ycoor-(tmpcmd->fs+tmpcmd->cs) * (ccount++) + tmpcmd->fs/6),hbyte);
    	    			  if (logps == TRUE)
    	    			    fprintf (ps_file,"%.2f %.2f M (%c) show\n",tmpcmd->xcoor+tmpcmd->fs/4,(tmpcmd->ycoor-(tmpcmd->fs+tmpcmd->cs) * (ccount-1) + tmpcmd->fs/6),hbyte);
    	    			  }
          		        }
          		      fprintf (out_file,"grestore \n");
          		      if (logps == TRUE)
          		        fprintf (ps_file,"grestore \n");
          		      break;
          
            case TPL_BC39 : strcat (b_str,bc39[38]);
        		    for (j=0 ;j < strlen (tmpcmd->print_str);j++)
          		      {
          		      if (isalpha(tmpcmd->print_str[j]))
            		        strcat (b_str,bc39[toupper(tmpcmd->print_str[j])-'A']);
          		      else if (isdigit(tmpcmd->print_str[j]))
            		        strcat (b_str,bc39[tmpcmd->print_str[j]-'0'+26]);
          		      else if (isspace(tmpcmd->print_str[j]))
            		        strcat (b_str,bc39[40]);
          		      else if (tmpcmd->print_str[j]=='+')
            		        strcat (b_str,bc39[36]);
            		      else if (tmpcmd->print_str[j]=='-')
            		        strcat (b_str,bc39[37]);
          		      else if (tmpcmd->print_str[j]=='/')
      		                strcat (b_str,bc39[39]);
		              else 
            		        strcat (b_str,bc39[41]);
           		      }
        		    strcat (b_str,bc39[38]);

        		    fprintf (out_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(tmpcmd->print_str)*48+96),(int)tmpcmd->fs,b_str);
			    if (logps == TRUE)
			      fprintf (ps_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(tmpcmd->print_str)*48+96),(int)tmpcmd->fs,b_str);
			    b_str[0]=0;
			    break;        

            case TPL_BC25 : if ((strlen(tmpcmd->print_str) % 2) != 0)
             		      {
             		      strcpy (bc25_str,tmpcmd->print_str);     
             		      }
             		    else
             		      {
             		      strcpy (bc25_str,"0");
             		      strcat (bc25_str,tmpcmd->print_str);
             		      }
             		    
             		    strcpy (b_str,bc25_start);
             		    
             		    for (j =0 ;j < strlen (bc25_str)-2;j=j+2)
             		      {
             		      if ((isdigit (bc25_str[j])) && (isdigit (bc25_str[j+1])))
             		        {
             		        strncpy (bc25_dual,&bc25_str[j],2);
             		        bc25_dual[2] = 0;
             		        bc25_cn = atoi(bc25_dual);
             		        strcat (b_str,bc25[bc25_cn]);
             		        }
             		      else
             		        {
             		        strcat (b_str,bc25_error);
             		        }
             		      }
             		      
             		    strcat (b_str,bc25_stop);
             		    
            		    switch (strlen (b_str) % 4)
            		      {
            		      case 1 	: strcat (b_str,"000");
            		      		  break;
            		      case 2 	: strcat (b_str,"00");
            		      		  break;
            		      case 3 	: strcat (b_str,"0");
            		      }
            		      
            		    strcpy(bc25_hex,"");
            		    for (j =0 ;j < strlen (b_str); j= j+4)
            		      {
            		      strncpy (bc25_dual,&b_str[j],4);
            		      bc25_cn = atoi (bc25_dual);
            		      switch (bc25_cn)
            		        {
            		        case 1111 	: strcat (bc25_hex,"0");
            		        		  break;
            		        case 1110	: strcat (bc25_hex,"1");
            		        		  break;
            		        case 1101	: strcat (bc25_hex,"2");
            		        		  break;
            		        case 1100	: strcat (bc25_hex,"3");
            		        		  break;
            		        case 1011	: strcat (bc25_hex,"4");
            		        		  break;
            		        case 1010	: strcat (bc25_hex,"5");
            		        		  break;
            		        case 1001	: strcat (bc25_hex,"6");
            		        		  break;
            		        case 1000	: strcat (bc25_hex,"7");
            		        		  break;
            		        case 111	: strcat (bc25_hex,"8");
            		        		  break;
            		        case 110	: strcat (bc25_hex,"9");
            		        		  break;
            		        case 101	: strcat (bc25_hex,"A");
            		        		  break;
            		        case 100	: strcat (bc25_hex,"B");
            		        		  break;
            		        case 11		: strcat (bc25_hex,"C");
            		        		  break;
            		        case 10		: strcat (bc25_hex,"D");
            		        		  break;
            		        case 1		: strcat (bc25_hex,"E");
            		        		  break;
            		        case 0		: strcat (bc25_hex,"F");
            		        		  break;
            		        }
            		      }
            		    if ((strlen(bc25_hex) %2) != 0)
            		      {
            		      strcat (bc25_hex,"F");
            		      }
            		    
                	    fprintf (out_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(bc25_hex)*4),(int)tmpcmd->fs,bc25_hex);
			    if (logps == TRUE)
			      fprintf (ps_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(bc25_hex)*4),(int)tmpcmd->fs,bc25_hex);
			    b_str[0]=0;
			    break;        
			    
            case TPL_CODABAR : strcpy (b_str,"");
             		    for (j =0 ;j < strlen (tmpcmd->print_str)-1;j++)
             		      {
             		      if (isdigit(tmpcmd->print_str[j]))
             		        strcat (b_str,codabar[(tmpcmd->print_str[j]-'0')]);
             		      else
             		        switch (tmpcmd->print_str[j])
             		          {
             		          case 'a'	:
             		          case 'A'	: strcat (b_str,codabar[10]);
             		          		  break;
             		          case 'b'	:
             		          case 'B'	: strcat (b_str,codabar[11]);
             		          		  break;
             		          case 'c'	:
             		          case 'C'	: strcat (b_str,codabar[12]);
             		          		  break;
             		          case 'd'	:
             		          case 'D'	: strcat (b_str,codabar[13]);
             		          		  break;
             		          case '-'	: strcat (b_str,codabar[14]);
             		          		  break;
             		          case '$'	: strcat (b_str,codabar[15]);
             		          		  break;
             		          case '.'	: strcat (b_str,codabar[16]);
             		          		  break;
             		          case '/'	: strcat (b_str,codabar[17]);
             		          		  break;
             		          case ':'	: strcat (b_str,codabar[18]);
             		          		  break;
             		          case '+'	: strcat (b_str,codabar[19]);
             		          		  break;
             		          default 	: strcat (b_str,codabar_error);
             		          		  break;
             		          }
             		      }
             		      
            		    switch (strlen (b_str) % 4)
            		      {
            		      case 1 	: strcat (b_str,"000");
            		      		  break;
            		      case 2 	: strcat (b_str,"00");
            		      		  break;
            		      case 3 	: strcat (b_str,"0");
            		      }
            		      
            		    strcpy(bc25_hex,"");
            		    for (j =0 ;j < strlen (b_str); j= j+4)
            		      {
            		      strncpy (bc25_dual,&b_str[j],4);
            		      bc25_cn = atoi (bc25_dual);
            		      switch (bc25_cn)
            		        {
            		        case 1111 	: strcat (bc25_hex,"0");
            		        		  break;
            		        case 1110	: strcat (bc25_hex,"1");
            		        		  break;
            		        case 1101	: strcat (bc25_hex,"2");
            		        		  break;
            		        case 1100	: strcat (bc25_hex,"3");
            		        		  break;
            		        case 1011	: strcat (bc25_hex,"4");
            		        		  break;
            		        case 1010	: strcat (bc25_hex,"5");
            		        		  break;
            		        case 1001	: strcat (bc25_hex,"6");
            		        		  break;
            		        case 1000	: strcat (bc25_hex,"7");
            		        		  break;
            		        case 111	: strcat (bc25_hex,"8");
            		        		  break;
            		        case 110	: strcat (bc25_hex,"9");
            		        		  break;
            		        case 101	: strcat (bc25_hex,"A");
            		        		  break;
            		        case 100	: strcat (bc25_hex,"B");
            		        		  break;
            		        case 11		: strcat (bc25_hex,"C");
            		        		  break;
            		        case 10		: strcat (bc25_hex,"D");
            		        		  break;
            		        case 1		: strcat (bc25_hex,"E");
            		        		  break;
            		        case 0		: strcat (bc25_hex,"F");
            		        		  break;
            		        }
            		      }
            		    if ((strlen(bc25_hex) %2) != 0)
            		      {
            		      strcat (bc25_hex,"F");
            		      }
            		    
                	    fprintf (out_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(bc25_hex)*4),(int)tmpcmd->fs,bc25_hex);
			    if (logps == TRUE)
			      fprintf (ps_file,"gsave  %.2f %.2f translate %.2f 1.00 scale\n%d %d 1 [1 0 0 1 1 1] <%s> image\ngrestore\n",\
tmpcmd->xcoor,tmpcmd->ycoor,tmpcmd->cs,(strlen(bc25_hex)*4),(int)tmpcmd->fs,bc25_hex);
			    b_str[0]=0;
			    break;        			    
            }
          tmpcmd = tmpcmd->next;
          }
        }
      fprintf (out_file,"F\nshowpage\n");
      if (logps == TRUE)
        fprintf (ps_file,"F\nshowpage\n");
      }
  }
