<?php
/*
 * $Horde: turba/addobject.php,v 1.7.2.12 2005/01/03 11:26:03 jan Exp $
 *
 * Turba: Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once TURBA_BASE . '/lib/AbstractObject.php';

$title = _("Add a new contact");
$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_BASE . '/menu.php';

$source = Horde::getFormData('source');
if ($source == null || !isset($cfgSources[$source])) {
    $options = '';
    $count = 0;
    foreach ($cfgSources as $key => $curSource) {
        if (empty($curSource['readonly']) || (isset($curSource['admin']) && in_array(Auth::getAuth(), $curSource['admin']))) {
            $options .= '<option value="' . $key . '">' . $curSource['title'] . '</option>';
            $source = $key;
            $count++;
        }
    }
} else {
    $count = 1;
}

if ($count == 0) {
    include TURBA_TEMPLATES . '/add/noadd.inc';
} elseif ($count == 1) {
    $driver = &Turba_Source::singleton($source, $cfgSources[$source]);
    if (PEAR::isError($driver)) {
        Horde::raiseMessage(_("Failed to connect to the specified directory."), HORDE_ERROR);
        include TURBA_BASE . '/status.php';
    } else {
        $object = new Turba_AbstractObject($driver);
        $view = new Turba_ObjectView($object, TURBA_TEMPLATES . '/add/add.inc');
        $view->display();
    }
} else {
    include TURBA_TEMPLATES . '/add/select.inc';
}

require TURBA_TEMPLATES . '/common-footer.inc';
