<?php
/*
 * $Horde: turba/editobjectaction.php,v 1.7.2.8 2005/01/03 11:26:04 jan Exp $
 *
 * Turba: Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

$edited_object = Horde::getFormData('object');
$object = $driver->getObject($edited_object['__key']);

foreach ($edited_object as $key => $value) {
    if ($key != '__key') {
        if ($attributes[$key]['type'] == 'date') {
            if ($value['month'] == '' || $value['day'] == '' || $value['year'] == '') {
                $value = null;
            } else {
                $value = mktime(0, 0, 0, $value['month'], $value['day'], $value['year']);
            }
        }
        $object->setValue($key, $value);
    }
}

// store
$object->store();

// get out of here
if (!$object->isGroup()) {
    $url = Turba::addParameter('displayobject.php', 'source=' . urlencode($source));
    $url = Turba::addParameter($url, 'key=' . urlencode($object->getValue('__key')));
    header('Location: ' . Horde::applicationUrl($url, true));
} else {
    $url = Turba::addParameter('browse.php', 'source=' . urlencode($source));
    header('Location: ' . Horde::applicationUrl($url, true));
}
