<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup department
 * @module department_show
 * @package department
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'address_tools.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'bug.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("department","show");
 loadlayout();

 /**
  * display a department
  */
 class department_show extends layout {
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     if ( isset($this->obj->location) ) {
       $cols = count($this->obj->location);
     } else {
       $cols = 0;
     }
     if ( $cols < 3 ) {
       $cols = 3;
     }

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"". $cols ."\">". sprintf($lang['Showing'],$lang[$this->obj->getType()]) ."</th>\n";

     echo "</tr><tr>\n";
     echo $this->showfield($lang['AdrName']);
     echo $this->showdata($this->obj->name , ($cols - 1));

     echo "</tr><tr>\n";
     echo $this->showfield($lang['Company']);
     echo $this->showdata($this->obj->company->getLink(),($cols-1));
     echo "</tr>\n";

     # Locations
     if ( isset($this->obj->location) && count($this->obj->location) > 0 ) {
       Show_LocFields($this->user,$lang['AdrDescription'],$this->obj,"lname",1);
       Show_LocFields($this->user,$lang['Phone'],$this->obj,"phone_1",1);
       Show_LocFields($this->user,$lang['AdrFax'],$this->obj,"fax_1",1);
       Show_LocFields($this->user,$lang['AdrEmail'],$this->obj,"email_1",1);
       Show_LocFields($this->user,$lang['Street'],$this->obj,"street1",1);
       Show_LocFields($this->user,$lang['Street'],$this->obj,"street2",1);
       Show_LocFields($this->user,$lang['City'],$this->obj,"city",1);
       Show_LocFields($this->user,$lang['ZIP'],$this->obj,"zip",1);
       Show_LocFields($this->user,$lang['State'],$this->obj,"state",1);
       Show_LocFields($this->user,$lang['Country'],$this->obj,"country",1);
       Show_LocFields($this->user,$lang['acc_info1'],$this->obj,"acc_info1",1);
       Show_LocFields($this->user,$lang['acc_info2'],$this->obj,"acc_info2",1);
       Show_LocFields($this->user,$lang['acc_nr'],$this->obj,"acc_nr",1);
     }

     $ra = $this->dbconn->Exec($this->q);
     if ( $ra->numrows() > 0 ) {
       echo "<tr>\n";
       echo " <th colspan=\"". $cols  ."\">". $lang['DepartmentMembers'] ."</th>\n";

       echo "<tr>\n";
       echo " <td colspan=\"". $cols ."\">\n";
       address_overview($this,$ra,$this->ashow,$this->atool);
       echo " </td>\n";
       echo "</tr>\n";
     }
     $ra->free();

     # Project Roles
     product::infolist($this->user,$this->obj,$cols,$this->format);
     # Older Appointments
     appointment::infolist($this->user,$this->obj,$cols,$this->format);
     # References to modules
     show_module_infolists($this->user,$this->obj,$cols,$this->format);

     echo $this->obj->getHistoryLink($cols);
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['DepartmentDetail'];
     $this->obj = new department($this->dbconn);
     if (!isset($_GET['id'])) {
       $msg .= "Missing ID";
       $this->stop = true;
     } else {
       $this->obj->read($_GET['id']);
       $this->obj->read_locs_data();
     }

     adr_tool_init($this->atool,$this->ashow);

     $this->ashow['f_name'] = 1;
     $this->ashow['l_name'] = 1;
     $this->ashow['email'] = 1;
     $this->ashow['phone'] = 1;
     $this->ashow['desc1'] = 1;

     $this->atool['link1'] = "department_show.php";
     $this->atool['link2'] = "department_show.php";

     $this->atool['link1'] = addUrlParameter($this->atool['link1'],"id=". $this->obj->id);
     $this->atool['link2'] = addUrlParameter($this->atool['link2'],"id=". $this->obj->id);

     $this->q = "SELECT distinct(a.id),a.* FROM ". $this->dbconn->prefix ."addresses a, ". $this->dbconn->prefix ."location l, ". $this->dbconn->prefix ."adrloc r WHERE l.d_id = ". $this->obj->id ." AND a.id = r.adr_id AND r.loc_id = l.id ";

     if ( isset($_GET['xf']) && isset($_GET['xo']) ) {
       $this->q .= " ORDER by " . $_GET['xf'];
       if ( $_GET['xo'] == 1 ) {
         $this->q .= " ASC ";
       } else {
         $this->q .= " DESC ";
       }
       $this->atool['link1'] = addUrlParameter($this->atool['link1'],"xf=".UrlEncode($_GET['xf']));
       $this->atool['link1'] = addUrlParameter($this->atool['link1'],"xo=".$_GET['xo']);
     } else {
       $this->q .= " ORDER by l_name";
     }

     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( $this->obj->id > 0 ) {
       $this->name .= ": ". $this->obj->getFullName();
     }
     # menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);

     $x =  department::getaddlink($this->user,$this->obj,$lang['NewEntry']);
     $this->addMenu($x);
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "department_new.php?id=".$this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['DepChgInfo'],$this->obj->getFullName()),
                   category => array("company","mod","obj")
                 );
       $this->addMenu($x);
     }

     if ( class_exists( 'appointment') ) {
       $x = appointment::getaddlink($this->user,$this->obj);
       $this->addMenu($x);
     }

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new department_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: department_show.php,v 1.49 2003/03/25 19:18:29 gokohnert Exp $
    $Author: gokohnert $
-->