<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * create a new product or modify an existing one
 *
 * @modulegroup product
 * @module product_new
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'bug.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','new');
 loadlayout();

 /**
  * change/modify a project
  */
 class product_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"productadd\" action=\"product_ins.php\" method=\"post\">\n";
     if ( $this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
     }
     echo $this->DataTableStart();
     echo " <tr>\n";
     echo "  <th colspan=\"5\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo " </tr>\n";
     if ( $this->obj->id > 0 ) {
       echo " <tr>\n";
       echo "  <td colspan=\"4\">". sprintf ($lang['ProdCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo "  <td align=\"right\" colspan=\"1\">". acl_link($this->obj) ."</td>\n";
       # Its an update
       echo " </tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdName'],1,"name");
     echo " <td colspan=\"4\"><input id=\"name\" size=\"". min($table['product']['name'][size],40) ."\" maxlength=\"". $table['product']['name'][size] ."\" name=\"name\" value=\"". myentities($this->obj->name) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdVersion'],0,"version");
     echo " <td colspan=\"4\"><input id=\"version\" size=\"". min($table['product']['version'][size],20) ."\" maxlength=\"". $table['product']['version'][size] ."\" name=\"version\" value=\"". myentities($this->obj->version) ."\">\n";
     echo "&nbsp;<span class=\"desc\">". $lang['ProdState'] ."</span>&nbsp;\n";
     echo "<select name=\"state\">\n";
#   $ar = array (0,4,5,1,2,3);
     foreach ($lang['ProdStates'] as $f => $i) {
       if ( $f >= 0 ) {
         echo " <option value=\"". $f ."\" ". ($f == $this->obj->state ? "selected":"") .">". myentities($lang['ProdStates'][$f]) ."</option>\n";
       }
     }
     echo "</select>\n";
     echo "&nbsp;<span class=\"desc\">". $lang['ProdProb'] ."</span>&nbsp;\n";
     echo "<input id=\"prob\" size=\"3\" maxlength=\"3\" name=\"prob\" value=\"". $this->obj->probability ."\"> %\n";
     echo "</td>\n";
     echo "</tr>\n";

     # Roles of peoples and teams etc.
     echo "<tr>\n";
     echo $this->showfield($lang['ProdRoles']);
     echo " <th>". $lang['ProdFunc'] ."</th><th>". $lang['AdrName'] ."</th><th>". $lang['ProdRoleDesc'] ."</th><th>&nbsp;</th>\n";
     echo "</tr>\n";

     # List all roles in this project
     if ( $this->obj->id > 0 ) {
       $n = 0;
       foreach ($lang['ProdRole'] as $role => $x) {
         if ( isset($this->obj->role[$role]) ) {
           foreach ($this->obj->role[$role] as $i => $o) {
             if ( $o->id < 1 ) {
               continue;
             }
             if ( $o->getType() == "product" ) {
               continue;
             }
             echo "<tr>\n";
             echo " <td>&nbsp;</td>\n";
             echo " <td>". $lang['ProdRole'][$role] ."</td>";
             echo " <td>". $o->getLink() ."</td>";
             echo " <td>". $this->obj->roledesc[$role][$i] ."&nbsp;</td>";
             $val = $o->id .",". $role;
             if ( ! isset($this->obj->rdel[$val]) ) {
               $this->obj->rdel[$val] = "";
             }
             echo " <td align=\"right\"><input id=\"del[]\" type=\"checkbox\" name=\"del[]\" value=\"". $val ."\"". $this->obj->rdel[$val] .">&nbsp;". $lang['Remove'] ."</td>";
             $n++;
             echo "</tr>\n";
           }
         }
       }
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdRolesNew']);
     echo " <td>\n";
     echo "  <select name=\"role1\">\n";
     foreach ($lang['ProdRole'] as $role => $x) {
       # No Product Roles
       if ( $tutos[rolecheck][$role] == "p") {
         continue;
       }
       echo "   <option value=\"". $role ."\"". ($role == $this->obj->rsel1 ? " selected":"") .">". myentities($lang['ProdRole'][$role]) ."</option>\n";
     }
     echo "  </select>\n";
     echo " </td>\n";
     echo " <td>\n";
     select_from_array_or_input($this->obj,"r1",$this->obj->r1,1);
     echo " </td>\n";

     echo " <td colspan=\"2\"><input id=\"r1desc\" name=\"r1desc\" value=\"". myentities($this->r1desc) ."\" size=\"40\" maxlength=\"40\"></td>\n";
     echo "</tr>\n";

     #
     # Relations to other Products
     #
     echo "<tr>\n";
     echo $this->showfield($lang['ProdProd']);
     echo " <th>". $lang['ProdFunc'] ."</th><th>". $lang['AdrName'] ."</th><th>". $lang['ProdRoleDesc'] ."</th><th>&nbsp;</th>\n";
     echo "</tr>\n";
     # List all projectroles in this project
     if ( $this->obj->id > 0 ) {
       $n = 0;
       foreach ($lang['ProdRole'] as $role => $x) {
         if ( isset($this->obj->role[$role]) ) {
           foreach ($this->obj->role[$role] as $i => $o) {
             if ( $o->id < 1 ) {
               continue;
             }
             if ( $o->getType() != "product" ) {
               continue;
             }
             echo "<tr>\n";
             echo " <td>&nbsp;</td>\n";
             echo " <td>". $lang['ProdRole'][$role] ."</td>";
             echo " <td>". $o->getLink() ."</td>";
             echo " <td>". $this->obj->roledesc[$role][$i] ."&nbsp;</td>";
             $val = $o->id .",". $role;
             if ( ! isset($this->obj->rdel[$val]) ) {
               $this->obj->rdel[$val] = "";
             }
             echo " <td align=\"right\"><input id=\"del[]\" type=\"checkbox\" name=\"del[]\" value=\"". $val ."\"". $this->obj->rdel[$val] .">&nbsp;". $lang['Remove'] ."</td>";
             $n++;
             echo "</tr>\n";
           }
         }
       }
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdProdNew']);
     echo " <td>\n";
     echo "  <select name=\"role2\">\n";
     foreach ($lang['ProdRole'] as $role => $x) {
       # No Product Roles
       if ( $tutos[rolecheck][$role] != "p") {
         continue;
       }
       echo "   <option value=\"". $role ."\"". ($role == $this->obj->rsel2 ? " selected":"") .">". myentities($lang['ProdRole'][$role]) ."</option>\n";
     }
     echo "  </select>\n";
     echo " </td>\n";
     echo " <td>\n";
     select_from_array_or_input($this->obj,"r2",$this->obj->r2,1);
     echo " </td>\n";

     echo " <td colspan=\"2\"><input id=\"r2desc\" name=\"r2desc\" value=\"". myentities($this->r2desc) ."\" size=\"40\" maxlength=\"40\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdDesc'],0,"desc0");
     echo " <td colspan=\"4\"><input id=\"desc0\" size=\"40\" maxlength=\"40\" name=\"description\" value=\"". myentities($this->obj->description) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdDesc1'],0,"desc1");
     echo " <td colspan=\"4\"><input id=\"desc1\" size=\"50\" maxlength=\"250\" name=\"desc1\" value=\"". myentities($this->obj->desc1) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdDesc2'],0,"desc2");
     echo " <td colspan=\"4\"><input id=\"desc2\" size=\"50\" maxlength=\"250\" name=\"desc2\" value=\"". myentities($this->obj->desc2) ."\"></td>\n";
     echo "</tr>\n";

     # Classification
     for ( $cl = 1;$cl <= $this->obj->classes; $cl++) {
       echo "<tr>\n";
       $wanted = 0;
       if( $tutos[classify_products] ) {
         $wanted = 1;
       }
       echo $this->showfield($lang['ProdClass'.$cl], $wanted, "cl".$cl);
       echo " <td colspan=\"4\">\n";
       $this->obj->class_select($cl);
       echo " </td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdPrice'],0,"price");
     echo " <td colspan=\"4\">\n";
     echo "  <input id=\"price\" size=\"10\" maxlength=\"10\" name=\"price\" value=\"". $this->obj->price ."\">\n";
     echo "  &nbsp;<span class=\"desc\"><label for=\"cost\">". $lang['ProdCost'] ."</label></span>\n";
     echo "  <input id=\"cost\" size=\"10\" maxlength=\"10\" name=\"cost\" value=\"". $this->obj->cost ."\">\n";
     Currency_Select("currency",$this->obj->currency);
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdStart'],0,"p_start_d");
     echo " <td colspan=\"4\">\n";
     $this->obj->p_start->EnterDate("p_start",1);
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdEnd'],0,"p_end_d");
     echo " <td colspan=\"4\">\n";
     $this->obj->p_end->EnterDate("p_end",1);
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ProdPath'],0,"path");
     echo " <td colspan=\"4\"><input id=\"path\" size=\"". min($table['product']['path'][size],60) ."\" maxlength=\"". $table['product']['path'][size] ."\" name=\"path\" value=\"". myentities($this->obj->path) ."\"></td>\n";
     echo "</tr>\n";

     module_addforms($this->user,$this->obj,5);

     echo "<tr>\n";
     if ( $this->obj->id != -1 ) {
       submit_reset(0,1,1,1,1,1);
     } else {
       submit_reset(0,-1,1,1,1,1);
     }
     echo "</tr>\n";
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("productadd.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['Product'];
     $this->obj = new product($this->dbconn);
     $this->r1desc = "";
     $this->r2desc = "";

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = $lang['ProdModifyT'] .": ". $this->obj->getFullName();
       $this->obj->readroles();
     } else {
       $this->name = $lang['ProdCreateT'];
       $this->obj->r1 = $this->user;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['version']) ) {
       $this->obj->version = StripSlashes($_GET['version']);
     }
     if ( isset($_GET['desc1']) ) {
       $this->obj->desc1 = StripSlashes($_GET['desc1']);
     }
     if ( isset($_GET['desc2']) ) {
       $this->obj->desc2 = StripSlashes($_GET['desc2']);
     }
     if ( isset($_GET['description']) ) {
       $this->obj->description = StripSlashes($_GET['description']);
     }
     if ( isset($_GET['path']) ) {
       $this->obj->path = StripSlashes($_GET['path']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['price']) ) {
       $this->obj->price = $_GET['price'];
     }
     if ( isset($_GET['cost']) ) {
       $this->obj->cost = $_GET['cost'];
     }
     if ( isset($_GET['currency']) ) {
       $this->obj->currency = $_GET['currency'];
     }
     if ( isset($_GET['prob']) ) {
       $this->obj->probability = $_GET['prob'];
     }
     if ( isset($_GET['p_start']) ) {
       $this->obj->p_start->setDateTime($_GET['p_start']);
     }
     if ( isset($_GET['p_end']) ) {
       $this->obj->p_end->setDateTime($_GET['p_end']);
     }
     # People Team Relations
     if ( isset($_GET['r1id']) ) {
       $this->obj->role[1]->id = $_GET['r1id'];
     }
     if ( isset($_GET['r1fn']) ) {
       $this->obj->xfn['r1'] = StripSlashes($_GET['r1fn']);
       unset($this->obj->r1);
     }
     if ( isset($_GET['r1l']) ) {
       foreach($_GET['r1l'] as $x => $f) {
         $a = getObject($this->dbconn,$f);
         $this->obj->xl['r1'][$f] = $a;
       }
     }
     if ( isset($_GET['role1']) ) {
       $this->obj->rsel1 = $_GET['role1'];
     } else {
       $this->obj->rsel1 = 1;
     }
     # Product Relations
     if ( isset($_GET['r2id']) ) {
       $this->obj->role[1]->id = $_GET['r2id'];
     }
     if ( isset($_GET['r2fn']) ) {
       $this->obj->xfn['r2'] = StripSlashes($_GET['r2fn']);
       unset($this->obj->r2);
     }
     if ( isset($_GET['r2l']) ) {
       foreach($_GET['r2l'] as $x => $f) {
         $a = getObject($this->dbconn,$f);
         $this->obj->xl['r2'][$f] = $a;
       }
     }
     if ( isset($_GET['role2']) ) {
       $this->obj->rsel2 = $_GET['role2'];
     } else {
       $this->obj->rsel2 = 1;
     }

     if ( isset($_GET['r1desc']) ) {
       $this->r1desc = StripSlashes($_GET['r1desc']);
     }
     if ( isset($_GET['r2desc']) ) {
       $this->r2desc = StripSlashes($_GET['r2desc']);
     }

     if ( isset($_GET['del']) ) {
       foreach($_GET['del'] as $i => $f) {
         $this->obj->rdel[$f] = "CHECKED";
       }
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useprojects,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $x = product::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($x);
     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array( url => "product_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ProdCreateInfo'],
                   category => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "product_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['ProdDelInfo'],$this->obj->getFullname()),
                   category => array("product","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new product_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_new.php,v 1.68 2003/03/25 19:18:28 gokohnert Exp $
    $Author: gokohnert $
-->