<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup product
 * @module product_overview
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','overview');
 loadlayout();

 /**
  * show a overview of projects
  */
 class product_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $plist = array();
     $n = $this->result->numrows();
	 if ($this->format == "stat" ) {
       $this->statinfo();
       $this->result->free();
       return;
	 }

     $flds = 0;
     $pf = 0;

     foreach($tutos[currencies] as $c) {
       $sum[1][$c] = 0;
       $sum[2][$c] = 0;
     }
     $sum[1][""] = 0;
     $sum[2][""] = 0;

     # Make a big array of all visible products
     $x = 0;
     while ( $x < $n ) {
       $p = new product($this->dbconn);
       $p->read_result($this->result,$x);
       $x++;
       if ( ! $p->see_ok() ) {
         unset($p);
         continue;
       }
       if ( ($this->pshow['price'] == 1) || ($this->pshow['cost'] == 1) ) {
         $sum[1][$p->currency] += $p->price;
         $sum[2][$p->currency] += $p->cost;
       }
       $plist[] = &$p;
       unset($p);
     }
     $n = count($plist);
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $this->result->free();
       return;
     }
     if ( $this->pshow['checkbox'] ) {
       echo $this->actionformStart("product_overview.php");
     }
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";

     foreach ($tutos[prodfields] as $c) {
       if ( ($c == "name") && $this->pshow[$c] ) {
         echo $this->orderHeader("name",$lang['ProdName'],$this->link2);
         $flds++;
       }
       if ( ($c == "version") && $this->pshow[$c] ) {
         echo $this->orderHeader("version",$lang['ProdVersion'],$this->link2);
         $flds++;
       }
       if ( ($c == "seller") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][4],$this->link2);
         $flds++;
       }
       if ( ($c == "manager") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][1],$this->link2);
         $flds++;
       }
       if ( ($c == "customer") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][6],$this->link2);
         $flds++;
       }
       if ( ($c == "supplier") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][7],$this->link2);
         $flds++;
       }
       if ( ($c == "reseller") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][8],$this->link2);
         $flds++;
       }
       if ( ($c == "partner") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdRole'][9],$this->link2);
         $flds++;
       }
       if ( ($c == "desc") && $this->pshow[$c] ) {
         echo $this->orderHeader("description",$lang['ProdDesc'],$this->link2);
         $flds++;
       }
       if ( ($c == "desc1") && $this->pshow[$c] ) {
         echo $this->orderHeader("desc1",$lang['ProdDesc1'],$this->link2);
         $flds++;
       }
       if ( ($c == "desc2") && $this->pshow[$c] ) {
         echo $this->orderHeader("desc2",$lang['ProdDesc2'],$this->link2);
         $flds++;
       }
       if ( ($c == "cl1") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdClass1'],$this->link2);
         $flds++;
       }
       if ( ($c == "cl2") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdClass2'],$this->link2);
         $flds++;
       }
       if ( ($c == "state") && $this->pshow[$c] ) {
         echo$this-> orderHeader("state",$lang['ProdState'],$this->link2);
         $flds++;
       }
       if ( ($c == "probability") && $this->pshow[$c] ) {
         echo $this->orderHeader("probability",$lang['ProdProb'],$this->link2);
         $flds++;
       }
       if ( ($c == "price") && $this->pshow[$c] ) {
         echo $this->orderHeader("currency,price",$lang['ProdPrice'],$this->link2);
         $flds++;
         $pf = $flds;
       }
       if ( ($c == "cost") && $this->pshow[$c] ) {
         echo $this->orderHeader("currency,cost",$lang['ProdCost'],$this->link2);
         $flds++;
         $cf = $flds;
       }
       if ( ($c == "creator") && $this->pshow[$c] ) {
         echo $this->orderHeader("",$lang['ProdCreator'],$this->link2);
         $flds++;
       }
       if ( ($c == "creation") && $this->pshow[$c] ) {
         echo $this->orderHeader("creation",$lang['ProdCreationS'],$this->link2);
         $flds++;
       }
       if ( ($c == "p_start") && $this->pshow[$c] ) {
         echo $this->orderHeader("p_start",$lang['ProdStart'],$this->link2);
         $flds++;
       }
       if ( ($c == "p_end") && $this->pshow[$c] ) {
         echo $this->orderHeader("p_end",$lang['ProdEnd'],$this->link2);
         $flds++;
       }
       if ( $this->user->feature_ok(usebugtracking,PERM_SEE) ) {
         if ( ($c == "pbugs") && $this->pshow[$c] ) {
		   echo $this->orderHeader("",$lang['Bugs'],$this->link2);
           $flds++;
         }
       }
       if ( ($c == "checkbox") && $this->pshow[$c] ) {
         # Column for checkboxes
         echo "<th>&nbsp;";
         echo " <input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\">\n";
         echo "&nbsp;</th>";
         $flds++;
       }
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->format == "paper" ) {
       $a = 0;
       $end = $n;
     } else if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }
     $line = 0;

	 $this->filter['name'] = prepare_regpattern($this->filter['name']);

     while ( ($a < $n) && ($a < $end) ) {
       $p = &$plist[$a];
       $p->readroles();

       echo $this->OverviewRowStart($line);
       foreach ($tutos[prodfields] as $c) {
  	     if (! $this->pshow[$c]) {
	       continue;
	     }
         echo "  <td valign=\"top\" nowrap>&nbsp;";

         if ( $c == "name" ) {
           $b = myentities($p->name);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo makelink($p->getUrl(),$b);
         } else if ( $c == "version" ) {
           $b = myentities($p->version);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo $b;
         } else if ( $c == "seller" ) {
           # Show all seller roles
           if (isset($p->role[4]) && (count($p->role[4]) > 0) ) {
             @reset ($p->role[4]);
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[4]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink($r->getShortname());
               $x++;
             }
           }
         } else if ( $c == "manager" ) {
           # Show all manager roles
           if (isset($p->role[1]) && (count($p->role[1]) > 0) ) {
             @reset ($p->role[1]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[1]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink($r->getShortname());
               $x++;
             }
           }
           # Show all manager 3 roles
           if (isset($p->role[3]) && (count($p->role[3]) > 0) ) {
             @reset ($p->role[3]) ;
             while ( list ($i,$r) = @each ($p->role[3]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink($r->getShortname());
               $x++;
             }
           }
         } else if ( $c == "customer" ) {
           # Customer
           if (isset($p->role[6]) && (count($p->role[6]) > 0) ) {
             @reset ($p->role[6]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[6]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink();
               $x++;
             }
           }
         } else if ( $c == "supplier" ) {
           # Supplier
           if (isset($p->role[7]) && (count($p->role[7]) > 0) ) {
             @reset ($p->role[7]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[7]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink();
               $x++;
             }
           }
         } else if ( $c == "reseller") {
           # Reseller
           if (isset($p->role[8]) && (count($p->role[8]) > 0) ) {
             @reset ($p->role[8]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[8]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink();
               $x++;
             }
           }
         } else if ( $c == "partner" ) {
           # Partner
           if (isset($p->role[9]) && (count($p->role[9]) > 0) ) {
             @reset ($p->role[9]) ;
             $x = 0;
             while ( list ($i,$r) = @each ($p->role[9]) ) {
               if ( $x > 0 ) {
                 echo "<br>\n &nbsp;";
               }
               echo  $r->getLink();
               $x++;
             }
           }
         } else if ( $c == "desc" ) {
           $b = myentities($p->description);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo $b;
         } else if ( $c == "desc1" ) {
           $b = myentities($p->desc1);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo $b;
         } else if ( $c == "desc2" ) {
           $b = myentities($p->desc2);
           if ( $this->filter['name'] != "" ) {
             $b = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$b);
           }
           echo $b;
         } else if ( $c == "state" ) {
           echo $lang['ProdStates'][$p->state];
         } else if ( $c == "probability" ) {
           echo "<div align=\"right\">". $p->probability ."%</div>";
         } else if ( $c == "price" ) {
           echo "<div align=\"right\">". number_format($p->price,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". myentities($p->currency) ."</div>";
         } else if ( $c == "cost" ) {
           echo "<div align=\"right\">". number_format($p->cost,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". myentities($p->currency) ."</div>";
         } else if ( $c == "creator" ) {
           echo $p->creator->getLink($p->creator->getShortname());
         } else if ( $c == "creation" ) {
           echo $p->creation->getLinkDate();
         } else if ( $c == "p_start" ) {
           echo $p->p_start->getLinkDate();
         } else if ( $c == "p_end" ) {
           echo $p->p_end->getLinkDate();
         } else if ( $c == "pbugs" ) {
           if ( $this->user->feature_ok(usebugtracking,PERM_SEE) ) {
	         bug::obj_read($p);
             echo $p->bugSum();
           }
         } else if ( $c == "checkbox" ) {
           echo "<div align=\"center\">";
           # Column for checkboxes
           if ( $p->mod_ok() ) {
             echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $p->id ."\">\n";
           } else {
             echo "-\n";
           }
           echo "</div>";
         }

         for ( $cl = 1;$cl <= $p->classes; $cl++) {
           if ( $c == "cl".$cl ) {
             $sep = "";
             @reset($p->cl[$cl]);
             while ( list ($i,$f) = @each ($p->cl[$cl]) ) {
               if ( isset ($lang['ProdClasses'.$cl][$f]) ) {
                 echo $sep . $lang['ProdClasses'.$cl][$f] ;
               } else {
                 echo $sep . $f ;
               }
               $sep = "<br>\n";
             }
           }
         }

         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
	   unset($plist[$a]);
       unset($p);
       $a++;
     }

     echo $this->list_navigation($this->link1,$flds,$this->start,$a,$n);

     # Sum of Prices
     if ( ($this->pshow['price'] == 1) || ($this->pshow['cost'] == 1) ) {
       echo "<tr>\n";
       $fill = 0;
       @reset($tutos[prodfields]);
       while( list ($i,$c) = @each ($tutos[prodfields])) {
         if (  $this->pshow[$c] == 0 ) {
           continue;
         }
         if ( $c == "price" ) {
           if ( $fill > 0 ) {
             echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
             $fill = 0;
           }
           echo " <td align=\"right\">\n";
           @reset($sum[1]);
           $pre = "";
           while( list ($i1,$f1) = @each ($sum[1])) {
             if ( $f1 ) {
               echo $pre . number_format($f1,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". $i1;
               $pre = "<br>\n";
             }
           }
           echo " </td>\n";
         } else if ( $c == "cost" ) {
           if ( $fill > 0 ) {
             echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
             $fill = 0;
           }
           echo " <td align=\"right\">\n";
           @reset($sum[2]);
           $pre = "";
           while( list ($i1,$f1) = @each ($sum[2])) {
             if ( $f1 ) {
               echo $pre . number_format($f1,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". $i1;
               $pre = "<br>\n";
             }
           }
           echo " </td>\n";
         } else {
           $fill++;
	     }
       }
       if ( $fill > 0 ) {
         echo " <td colspan=\"". $fill ."\">&nbsp;</td>\n";
       }
       echo "</tr>\n";
     }

     if ( $this->pshow['checkbox'] ) {
       # Mass Update
       echo $this->UpdateRowStart($flds-1);
       echo sprintf($lang['withmarked'],$lang['ProductPs']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       $ar = array (0,4,5,1,2,3);
       while ( list ($f,$i) = @each ($ar) ) {
         echo " <option value=\"". $i ."\">". sprintf($lang['SetTo'],$lang['ProdState'],$lang['ProdStates'][$i]) ."</option>\n";
       }
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(1);
     }

     echo $this->OverviewTableEnd();
     if ( $this->pshow['checkbox'] ) {
	   echo $this->actionformEnd("bug_overview.php");
     }
 }

 /* ---------------------------------------------------------------------------
  *
  */
 Function statinfo() {
   global $lang,$tutos;

   $a = 0;
   $n = $this->result->numrows();
   $cnt = 0;
   while ( $a < $n ) {
     $p = new product($this->dbconn);
     $p->read_result($this->result,$a);
     $p->readroles();
     $a++;
     if ( ! $p->see_ok() ) {
       continue;
     }
     $cnt++;

     # Manager
     if (isset($p->role[1]) && (count($p->role[1]) > 0) ) {
       @reset ($p->role[1]) ;
       $x = 0;
       while ( list ($i,$r) = @each ($p->role[1]) ) {
         if ( !isset($manager[$r->id]) ) {
           $manager[$r->id] = 0;
         }
         $manager[$r->id]++;
       }
     }
     if (isset($p->role[3]) && (count($p->role[3]) > 0) ) {
       @reset ($p->role[3]) ;
       $x = 0;
       while ( list ($i,$r) = @each ($p->role[3]) ) {
         if ( !isset($manager[$r->id]) ) {
           $manager[$r->id] = 0;
         }
         $manager[$r->id]++;
       }
     }

     # States
     if ( !isset($states[$p->state]) ) {
       $states[$p->state] = 0;
     }
     $states[$p->state]++;

     # Classifications
     for ( $c = 1;$c <= 2; $c++) {
       @reset($p->cl[$c]);
       while ( list ($i,$f) = @each ($p->cl[$c]) ) {
         if ( !isset($cl[$c][$i]) ) {
           $cl[$c][$i] = 0;
         }
         $cl[$c][$i]++;
       }
     }
     unset($p);
   }

   echo $this->DataTableStart();
   echo "<tr>\n";
   echo " <th colspan=\"6\">". $lang['ProdStatsTitle'] ."</th>\n";
   echo "</tr>\n";

   echo "<tr>\n";
   echo $this->showfield($lang['Count']);
   echo "<td colspan=\"5\">". $cnt ."\n";
   $pre = "filtered by ";
   while ( list ($i,$f) = @each ($this->filter) ) {
     if ( $f == "" ) {
       continue;
     }
     if ( $i == 'state' ) {
       $f = $f + 0;
       echo $pre . $lang['ProdState'];
       echo " ". $lang['ProdStates'][$f];
     } else if ( $i == 'cl1' ) {
       echo $pre . $lang['ProdClass1'];
       echo " ". $lang['ProdClasses1'][$f];
     } else if ( $i == 'cl2' ) {
       echo $pre . $lang['ProdClass2'];
       echo " ". $lang['ProdClasses2'][$f];
     } else if ( $i == 'name' ) {
       echo $pre . $lang['ProdDesc'];
       echo " ". $f;
     } else if ( $i == 'from' ) {
       echo $pre . $lang['DateTimeFrom'];
       echo " ". $f->getDateTime();
     } else if ( $i == 'to' ) {
       echo $pre . $lang['DateTimeTill'];
       echo " ". $f->getDateTime();
     } else {
       echo $pre . $i;
       echo " ". $f;
     }
     $pre = " and ";
   }
   echo " </td>\n";
   echo "</tr>\n";

   # State distribution
   echo "<tr>\n";
   $link = "graph_bars.php";
   $link = addSessionKey($link);
   $link = addUrlParameter($link,"type=pie");
   @reset($states);
   if ( !function_exists('ImageCreate') ) {
     echo " <td valign=\"top\" rowspan=\"". count($states) ."\"><b>". $lang['ProdState'] ."</b></td>";
   } else {
     echo $this->showfield($lang['ProdState']);
   }
   $c = 0;
   while ( list ($i,$f) = @each ($states) ) {
     $val = number_format($f * 100.0 / $cnt ,2);
     if ( !function_exists('ImageCreate') ) {
       echo " <td>". $lang['ProdStates'][$i] ."</td>\n";
       echo " <td align=\"right\">". $f ."</td>\n";
       echo " <td align=\"right\">". $val ."%</td>\n";
     }
     $link = addUrlParameter($link,"f[". $c ."]=".$val);
     $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['ProdStates'][$i]));
     $link = addUrlParameter($link,"t1[". $c ."]=".$f);
     $c++;
   }
   if ( function_exists('ImageCreate') ) {
     echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
   }
   echo "</tr>\n";

   # Classifications
   for ( $c = 1;$c <= 2; $c++) {
     echo "<tr>\n";
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($cl[$c]);
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($cl[$c]) ."\"><b>". $lang['ProdClass'.$c] ."</b></td>";
       } else {
         echo $this->showfield($lang['ProdClass'.$c]);
       }
       $x = 0;
       while ( list ($i,$f) = @each ($cl[$c]) ) {
         $val = number_format($f * 100.0 / $cnt ,2);
         if ( !function_exists('ImageCreate') ) {
           if ( isset($lang['ProdClasses'.$c][$i]) ) {
             echo " <td>". $lang['ProdClasses'.$c][$i] ."</td>\n";
           } else {
             echo " <td>". $i ."</td>\n";
           }
           echo " <td align=\"right\">". $f ."</td>\n";
           echo " <td align=\"right\">". $val ."%</td>\n";
         }
         $link = addUrlParameter($link,"f[". $x ."]=".$val);
         if ( isset($lang['ProdClasses'.$c][$i]) ) {
           $link = addUrlParameter($link,"t0[". $x ."]=". UrlEncode($lang['ProdClasses'.$c][$i]));
         } else {
           $link = addUrlParameter($link,"t0[". $x ."]=". $i);
         }
         $link = addUrlParameter($link,"t1[". $x ."]=". $f );
         $x++;
       }
       if ( function_exists('ImageCreate') ) {
         echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
       }
       echo "</tr>\n";
     }

     # Manager distribution
     echo "<tr>\n";
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($manager);
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=". count($manager) ."><b>". $lang['ProdRole'][1] ."</b></td>";
     } else {
       echo $this->showfield($lang['ProdRole'][1]);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($manager) ) {
       $m = new tutos_address($this->dbconn);
       $m->read($i);
       if ( $m->id == -1 ) {
         $m = new team($this->dbconn);
         $m->read($i);
       }
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $m->getLink() ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=". $val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($m->getShortName()));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f);
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang,$tutos;

  
     if ( $this->format != "stat" ) {
       foreach ($this->pshow as $i => $f) {
         if ( $f == 0 ) {
           $schecked[$i] = "";
         } else {
           $schecked[$i] = " checked";
         }
       }
       echo "<tr><td>";
       echo "<form name=\"ProdFields\" action=\"product_overview.php\" method=\"GET\">";
       echo "<script type=\"text/javascript\" language=\"JavaScript\">\n";
       echo "<!--\n";
       echo "function CheckAll() {\n";
       echo "  for (var i=0; i < document.forms['ProdFields'].elements.length; i++) {\n";
       echo "   var e = document.forms['ProdFields'].elements[i];\n";
       echo "   if (e.name != 'checkit')\n";
       echo "     e.checked = document.forms['ProdFields'].checkit.checked;\n";
       echo "  }\n";
       echo "}\n";
       echo "//-->\n";
       echo "</script>\n";
       DoubleTableStart(0,0);
       echo "<tr><th>". $lang['ProdFields'] ."</th></tr>\n";
       foreach ($tutos[prodfields] as $i => $c) {
         if ( ! isset($this->flds[$c]) ) {
           continue;
         }
         if ( $this->flds[$c] == '' ) {
           continue;
         }
         echo "<tr><td nowrap>\n";
         echo " <input type=\"checkbox\" name=\"ps[]\"". $schecked[$c] ." value=\"". $c ."\">&nbsp;". $lang[$this->flds[$c]] ."\n";
         echo "</td></tr>\n";
       }

       echo "<tr><td nowrap><hr noshade></td></tr>\n";
       echo "<tr><td nowrap>\n";
       echo " <input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll();\">&nbsp;". $lang['all'] ."\n";
       echo "</td></tr>\n";

       echo "<tr><td><input type=\"submit\" value=\"". $lang['show'] ."\"></td></tr>\n";
       DoubleTableEnd();
       hiddenFormElements();
       echo $this->getHidden();
       echo "</form>\n";
       echo "</td></tr>";
     }
   }
   /**
    * action
    */
   Function action() {
     global $msg,$lang;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new product($this->dbconn);
         $p->read($val);
         $p->readroles();
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->del_ok() ) {
           $msg .= sprintf($lang['ProdDelInfo'], $p->getFullName()) ."<br>";
           $msg .= $p->delete();
	     } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0023'],$lang[$p->getType()]);
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     } else {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new product($this->dbconn);
         $p->read($val);
         $p->readroles();
         if ( $p->id != $val ) {
           continue;
	     }
         if ( $p->mod_ok() ) {
           $msg .= $p->getLink() ." ". $lang['ProdState'] ." = ". $lang['ProdStates'][$_GET['action']] ."<br>";
           $msg .= $p->setState($_GET['action']);
           $msg .= $p->save();
	     } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]);
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->name = $lang['ProductsOverview'];

     $this->link1 = "product_overview.php";
     $this->flds = array();
     $this->filter = array();

     $this->flds['name']         = 'ProdName';
     $this->flds['version']      = 'ProdVersion';
     $this->flds['seller']       = 'ProdRole4';
     $this->flds['manager']      = 'ProdRole1';
     $this->flds['customer']     = 'ProdRole6';
     $this->flds['supplier']     = 'ProdRole7';
     $this->flds['reseller']     = 'ProdRole8';
     $this->flds['partner']      = 'ProdRole9';
     $this->flds['desc']         = 'ProdDesc';
     $this->flds['desc1']        = 'ProdDesc1';
     $this->flds['desc2']        = 'ProdDesc2';
     $this->flds['cost']         = 'ProdCost';
     $this->flds['price']        = 'ProdPrice';
     $this->flds['probability']  = 'ProdProb';
     $this->flds['state']        = 'ProdState';
     $this->flds['creator']      = 'ProdCreator';
     $this->flds['creation']     = 'ProdCreationS';
     $this->flds['p_start']      = 'ProdStart';
     $this->flds['p_end']        = 'ProdEnd';
     if ( $this->user->feature_ok(usebugtracking,PERM_SEE) ) {
       $this->flds['pbugs']        = 'Bugs';
     }
     $p = new product($this->dbconn);
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $x = sprintf("cl%d",$cl);
       $this->flds['cl'.$cl]     = 'ProdClass'.$cl;
     }
     $this->flds['checkbox']     = '';
     $tutos[prodfields][]  = 'checkbox';
     foreach($tutos[prodfields] as $c) {
       $this->pshow[$c] = 0;
     }
     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
     } else {
       $name = "";
     }
     if ( isset($_GET['state']) ) {
       $state = $_GET['state'];
       # remember this
#       session_register('prodsearchstate');
       $_SESSION['prodsearchstate'] = $state;
     } else {
       $state = "";
     }
     if ( isset($_GET['role']) ) {
       $role = $_GET['role'];
     } else {
       $role = "";
     }
     $rid = array();
     if ( isset($_GET['rid']) ) {
       $rid = $_GET['rid'];
     }
     /* Fields to show */
     $pscnt = 0;
     if ( isset($_GET['ps']) ) {
       # New Set Default
       @reset($_GET['ps']);
       while ( list ($i1,$f1) = @each ($_GET['ps']) ) {
         $this->pshow[$f1] = 1;
         $pscnt++;
         $this->link1 = addUrlParameter($this->link1,"ps[]=".$f1);
       }
       # remember this
#       session_register('prodshow');
       $_SESSION['prodshow'] = $this->pshow;
     } else if ( isset($_SESSION['prodshow']) ) {
       # Session Default
       foreach($_SESSION['prodshow'] as $i1 => $f1) {
         if ( $f1 != 0 ) {
           $this->pshow[$i1] = $f1;
           $pscnt++;
           $this->link1 = addUrlParameter($this->link1,"ps[]=".$i1);
         }
       }
     }
     if ( $pscnt == 0 ) {
       # Default
      $this->pshow['name'] = 1;
      $this->pshow['version'] = 1;
      $this->pshow['manager'] = 1;
      $this->pshow['state'] = 1;
     }
     if ( $tutos[massupdate] == 1 ) {
       $this->pshow['checkbox'] = 1;
     }

     $this->q = "SELECT * FROM ". $p->tablename;
     $pre = " WHERE ";
     if ( ($name != "*") && ($name != "") ) {
       $name = StripSlashes($name);
       $this->q .= $pre ."(".  $this->dbconn->Like("name",$name);
       $this->q .= " OR ". $this->dbconn->Like("description",$name);
       $this->q .= " OR ". $this->dbconn->Like("desc1",$name);
       $this->q .= " OR ". $this->dbconn->Like("desc2",$name);
       $this->q .= " OR ". $this->dbconn->Like("version",$name);
       $this->q .= ")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=".UrlEncode($name));
       $this->addHidden("name",$name);
       $this->filter['name'] = $name;
     } else {
       $this->filter['name'] = "";
     }
     # Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       # remember this
#       session_register('prodsearchfrom');
       $_SESSION['prodsearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $this->q .= $pre ."(creation >= ". $this->dbconn->Date($from) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       $this->addHidden("fd",$from->getYYYYMMDD());
       $this->filter['from'] = $from;
     }
     # End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       # remember this
#       session_register('prodsearchto');
       $_SESSION['prodsearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $this->q .= $pre ."(creation <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       $this->addHidden("td",$to->getYYYYMMDD());
       $this->filter['to'] = $to;
     }
     #
     # State to display
     #
     if ( ($state != -1) && ($state != "") ) {
       if ( $state < 0 ) {
         $this->q .= $pre . " ( state != 2 AND state != 3 and state != 5 ) " ;
       } else {
         $this->q .= $pre . " state = " . $state ;
       }
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=".$state);
       $this->addHidden("state",$state);
       $this->filter['state'] = $state;
     }
     #
     # Classifications to display
     #
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $x = sprintf("cl%d",$cl);
       if ( isset($_GET[$x]) && ($_GET[$x] != -1) ) {
         # Get all project with classification
         $q1 =  "SELECT * from ". $this->dbconn->prefix ."projectclass". $cl ." WHERE class_id = ". $_GET[$x];
         $r = $this->dbconn->Exec($q1);
         $n = $r->numrows();
         $a = 0;
         $pre1 = "";
         $z = "";
         while ($a < $n) {
           $z .= $pre1 . $r->get($a, "pro_id");
           $pre1 = ",";
           $a++;
         }
         $r->free();
         if ( $z != "" ) {
           $this->q .= $pre ." id in (". $z .")";
           $pre = " AND ";
         }

         $this->link1 = addUrlParameter($this->link1,"cl". $cl ."=".$_GET[$x]);
         $this->addHidden("cl". $cl, $_GET[$x]);
         $this->filter['cl'.$cl] = $_GET[$x];
       }
       if ( isset($_GET[$x]) ) {
         $y = sprintf("prodsearchcl%d",$cl);
         # remember this
#         session_register($y);
         $_SESSION[$y] = $_GET[$x];
       }
     }
     # Role Specific Selection
     if ( count($rid) > 0 ) {
       # Get all managed product ids
       @reset ($rid);
       $ml = "";
       $mpre = "";
       foreach( $rid as $f1) {
         $ml .= $mpre . $f1;
         $mpre = ",";
         $this->link1 = addUrlParameter($this->link1,"rid[]=".$f1);
         $this->addHidden("rid[]",$f1);
       }
       if ( isset($role) ) {
         $q1 = "SELECT pro_id FROM ". $this->dbconn->prefix ."projectroles WHERE role_id in (". $role .") AND adr_id in (". $ml .")";
         $this->link1 = addUrlParameter($this->link1,"role=".$role);
         $this->addHidden("role",$role);
       } else {
         $q1 = "SELECT pro_id FROM ". $this->dbconn->prefix ."projectroles WHERE adr_id in (". $ml .")";
       }
       $r = $this->dbconn->Exec($q1);
       $n = $r->numrows();
       $a = 0;
       $pre1 = "";
       $x = "";
       while ($a < $n) {
         $x .= $pre1 . $r->get($a, "pro_id");
         $pre1 = ",";
        $a++;
       }
       $r->free();
       if ( $x != "" ) {
         $this->q .= $pre ." id in (". $x .")";
       }
       $pre = " AND ";
     }

     check_dbacl( $this->q, $this->user->id);

     # Order of output
     $this->link2 = $this->link1;
     $this->link2 = addUrlParameter($this->link2,"format=".UrlEncode($this->format));
     $xxx = "";
     order_parse($this->q,$this->link1,$xxx,$xxx,"creation DESC");

     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "product_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     # menu
     $x = product::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addMenu($x);

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array( url => "product_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ProdCreateInfo'],
                   category => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( $this->format != "stat" ) {
       $ll = addUrlParameter($this->link1,"format=stat");
       $x = array( url => $ll,
                   text => $lang['ProdStats'],
                   info => $lang['ProdStatsInfo'],
                   category => array("product","view")
                 );
       $this->addMenu($x);
	 }

     if ( $this->format != "paper" ) {
       $ll = addUrlParameter($this->link1,"format=paper");
       $x = array( url => $ll,
                   text => $lang['Printable'],
                   info => $lang['PrintableInfo'],
                   category => array("product","view")
                 );
       $this->addMenu($x);
     }

     $x = array( url => "sales_forecast.php",
                 text => $lang['SalesForecastRep'],
                 info => $lang['SalesForecastRep'],
                 category => array("product","view")
               );
     $this->addMenu($x);

   }
 }

 $l = new product_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_overview.php,v 1.90.2.2 2003/08/22 17:48:07 gokohnert Exp $
    $Author: gokohnert $
-->
