<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_ins
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 if ($tutos[usetaskmanagement] == 1) include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
     
 if ($tutos[usenotes] == 1) loadmodule('note');
 if ($tutos[usebugtracking] == 1) loadmodule('bugtracking');
 if ($tutos[usedocmanagement] == 1) loadmodule('file');

 function get_single_obj( $id ) {
   global $dbconn, $lang, $msg, $current_user, $gotourl;
   $list = array();
   $x = getObject($dbconn,$id);
   if ( $x == -1 ) {
     $msg .= sprintf($lang['Err0040'],"Object ". $id);
   } else if ( ! $current_user->isadmin() && ! $x->del_ok() ) {
     # we need delete permissions but talk about modify !
     $msg .= sprintf($lang['Err0024'],$lang[$x->getType()]);
   } else $list[] = &$x;
   unset($x);
   return $list;
 }

 function objlist_2_idlist( $ol ) {
   $il = array();
   foreach($ol as $o) $il[] = $o->id;
   return $il;
 }
 
 function get_objectlist($ids, $recur) {
   global $dbconn, $lang, $msg, $gotourl, $current_user, $tutos;
   
   $obj = array();
   
   foreach ($ids as $id ) {
     $res = get_single_obj( $id );
     $obj = array_merge( $obj, $res );
     if (isset($res[0]) && $recur) {
       if ($tutos[usetaskmanagement] == 1) {
         task::obj_read($res[0]);
         $obj = array_merge( $obj,
                get_objectlist( objlist_2_idlist($res[0]->tasklist), true ));
       }
       if ($tutos[usedocmanagement] == 1) {
         tutos_file::obj_read($res[0]);
         $obj = array_merge( $obj,
                get_objectlist( objlist_2_idlist($res[0]->list[usedocmanagement]), true ));
       }
       if ($tutos[usebugtracking] == 1) {
         bug::obj_read($res[0]);
         $obj = array_merge( $obj,
                get_objectlist( objlist_2_idlist($res[0]->list[usebugtracking]), true ));
       }
       if ($tutos[usenotes] == 1) {
         note::obj_read($res[0]);
         $obj = array_merge( $obj,
                get_objectlist( objlist_2_idlist($res[0]->list[usenotes]), true ));
       }
     }
   }
   return $obj;
 }

 /* Check Input */
 $msg = "";

 $obj = array();

 $gotourl = "mytutos.php";
 if ( !isset($_POST['id']) ) {
   $msg .= "Missing ID<br>";
 } else {
   if (! is_Array($_POST['id'])) {
     $id[0] = $_POST['id'];
   } else {
     $id = $_POST['id'];
   }
   if (isset($_POST['recursive'])) $recursive = true;
   else $recursive = false;
   $obj = get_objectlist($id, $recursive);
   
 }
 if ( isset($_POST['keep']) ) {
   $keep = true;
 } else {
   $keep = false;
 }
 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   foreach(array_reverse($obj) as $val) {
     if ( ! $keep ) {
       unset($val->acl);
     }
     if ( isset($_POST['r']) ) {
       @reset($_POST['r']) ;
       while ( list ($i,$f) = @each ($_POST['r']) ) {
         acl_raise($val,$f,$tutos[seeok]);
       }
     }
     if ( isset($_POST['u']) ) {
       @reset($_POST['u']) ;
       while ( list ($i,$f) = @each ($_POST['u']) ) {
         acl_raise($val,$f,$tutos[useok]);
       }
     }
     if ( isset($_POST['m']) ) {
       @reset($_POST['m']) ;
       while ( list ($i,$f) = @each ($_POST['m']) ) {
         acl_raise($val,$f,$tutos[modok]);
       }
     }
     if ( isset($_POST['d']) ) {
       @reset($_POST['d']) ;
       while ( list ($i,$f) = @each ($_POST['d']) ) {
         acl_raise($val,$f,$tutos[delok]);
       }
     }
     $msg .= acl_save($val);
     if ($val->getType() != "url") {
       $gotourl = $val->getURL();
     }
   }
   $dbconn->Commit("WORK");
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: acl_ins.php,v 1.28.2.1 2004/04/14 17:39:08 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>