import sys, re, os

def lfcr(file):
    if os.path.isdir(file):
        print file, "Directory!"
        return
    data = open(file, "rb").read()
    if '\0' in data:
        print file, "Binary!"
        return
    newdata = re.sub("\r?\n", "\r\n", data)
    if newdata != data:
        print "Converting '"+file+"' to CRLF format."
        f = open(file, "wb")
        f.write(newdata)
        f.close()

def add2filelist(fp, destination, source):
    absSource = os.path.abspath(source)
    for root, dirs, filenames in os.walk(source):
        fp.write("  SetOutPath $INSTDIR\\%s"%destination)
        relpath = os.path.abspath(root)[len(absSource)+1:]
        if relpath: fp.write("\\%s"%relpath)
        fp.write("\n")
        for file in filenames:
            fp.write('  File "%s"\n'%os.path.join(root, file))
        if 'CVS' in dirs: dirs.remove('CVS')  # don't visit CVS directories
        if 'cvs' in dirs: dirs.remove('cvs')

# makes sure the text docs are in CRLF format for notepad users(!)
docs = "../docs/"
for doc in os.listdir(docs):
    fullpath = docs+doc
    if os.path.isdir(fullpath): continue
    lfcr(fullpath)

# builds 'filelist.inc'. Prevents cvs clutter from being packaged by NSIS
fp = open("filelist.inc", "w")
add2filelist(fp, "data\\stamps", "..\\stamps")
add2filelist(fp, "data\\stamps\\docs", "..\\docs")
fp.write("\n")
fp.close()

