/*
 * HypBrowser: part of Ubit demos
 * Franck Shen - Cedric Timsit. 2003
 */
#ifndef HBROWSER_HPP
#define HBROWSER_HPP
#include <ubit/ubit.hpp>
#include "hcomplex.hpp"


class NodeInfo {
  bool is_dir;
  UStr path, name;
	
public:
  NodeInfo(const UStr& dirname, const UStr& fname, bool is_dir);
  
  bool isDir() const {return is_dir;}
  const UStr& getName() const {return name;}
  const UStr& getPath() const {return path;}
};

struct PtBox{
  double x1, y1, x2, y2;
  NodeInfo* info;
};


class HBrowser : public UBox {
public:
  HBrowser(const UStr& pathname, const UArgs& a = UArgs::none);
  ~HBrowser();

  void openDir(const UStr& pathName);
  UStr currentpath, nodecount_str;

private:
  bool mousedown, secondtip;
  HComplex p1, p2;
  u_dim xoffset, yoffset;
  double scale;
  int nbnoeuds;
  PtBox* pointage;  // array
  PtBox* currentpb;
  class  HNode* T1;

protected:
  void paintCB(UEvent&);
  void mousePressCB(UEvent&);
  void mouseMoveCB(UEvent&);
  void mouseReleaseCB(UEvent&);
  int  updateScale(UEvent&);
  void delTree1();
  void drawNode(class HNode*, class UGraph& painter, bool draw_str);
};

#endif
