/* ==================================================== ======== ======= *
 *
 *  ucursor.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucursor_hpp_
#define	_ucursor_hpp_
//pragma ident	"@(#)ucursor.hpp		ubit:03.05.00"
#include <ubit/uprop.hpp>


/** Mouse cursor.
 */
class UCursor : public UProp {
public:
  static UCursor arrow, xcross, crosshair, text, hand, 
    wait, question, kill, sizing, drag, add;
  ///< predefined cursors.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UCursor(int shape_spec = 0, u_modes bmodes = 0);
  ///< creates a new Cursor with a X-Window shape number.

  UCursor(const UCursor&);
  ///< creates a new UCursor that is a copy of another UCursor.

  virtual ~UCursor() {destructs();}

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void set(const UCursor&);
  ///< copies another UCursor.

  bool equals(const UCursor&) const;
  ///< compares two cursors.

  //const char* getName() const {return name;}
  int getShape() const {return shape;}

  virtual void update();

  std::vector<class UNatCursor*>& getNatCursors() const {return natcurs;}

#ifndef NO_DOC
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  virtual void addingTo(class ULink *selflink, UGroup *parent);
  virtual void removingFrom(class ULink *selflink, UGroup *parent);
  ///< NOTE that removingFrom() requires a destructor to be defined.

  virtual bool realize(class UDisp*);
  virtual void putProp(class UContext*, class UCtrl*);

private:
  friend class UNatDisp;
  unsigned long shape;
  mutable std::vector<class UNatCursor*> natcurs;
#endif
};


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
#endif
