#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28.2.1 2001/07/19 05:46:39 peter Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void);
#else
static int yygrowstack();
#endif
#define YYPREFIX "yy"
#line 2 "config_gram.y"
/* ======================================================================
 * Copyright (c) 2002 Theo Schlossnagle
 * All rights reserved.
 * The following code was written by Theo Schlossnagle <jesus@omniti.com>
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#include "config.h"
#include "config_help.h"
#include "alarm.h"

extern int semantic_errors;
int line_num;
extern int buffsize;
extern char *yytext;
int yylex();

	char            Spread_name[80];
        int              Spread_retry_interval;
        char            Spread_group[MAX_GROUP_NAME];
	char		control_socket[MAXPATHLEN] = "";
        sp_time         Maturity_timeout = { 5*60, 0 };
        sp_time         Balance_timer = { 5*60, 0 };
        sp_time         ArpRefresh_timer = { 60, 0 };
        int             Balance_rate = 1;
        int             Complete_balance = 0;
	int             Num_pseudo = 0;
	int             Num_prefer = 0;
	int		Num_notifications = 0;
	address         Prefer_address[MAX_PSEUDO];
	entry           Allocation_table[MAX_PSEUDO];
	entry           Old_table[MAX_PSEUDO];
struct notification	Notification_table[MAX_NOTIF];

entry *tmpe = Allocation_table;
int iplistn=0;

static void add_prefer(int);
static void lookup_name(char *, struct in_addr *);
static void yystype_to_interface(YYSTYPE *, struct interface *);

#define SPIT while(0) printf
#line 65 "y.tab.c"
#define YYERRCODE 256
#define W_SPREAD 257
#define W_SPREADRETRYINTERVAL 258
#define W_LOG 259
#define W_GROUP 260
#define W_VIFS 261
#define W_IPADDR 262
#define W_PREFER 263
#define W_NOTIFY 264
#define W_NONE 265
#define W_ARPCACHE 266
#define W_AQPR 267
#define W_ALL 268
#define W_THROTTLE 269
#define W_OPENBRACE 270
#define W_CLOSEBRACE 271
#define W_EQUALS 272
#define W_STRING 273
#define W_MATURE 274
#define W_TIMEINTERVAL 275
#define W_BALANCE 276
#define W_NUMBER 277
#define W_INTERVAL 278
#define W_CONTROL 279
const short yylhs[] = {                                        -1,
    0,    1,    1,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    3,
    3,    7,    7,    7,    4,    4,    8,    8,    8,    8,
    8,    8,    5,    9,    9,   10,   11,   11,    6,   12,
   12,   13,   13,
};
const short yylen[] = {                                         2,
    1,    2,    0,    3,    3,    3,    3,    3,    3,    3,
    3,    4,    2,    2,    2,    2,    2,    2,    2,    2,
    1,    3,    3,    3,    1,    3,    4,    2,    2,    3,
    1,    1,    3,    2,    1,    3,    2,    1,    3,    2,
    1,    1,    1,
};
const short yydefred[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    1,    0,    0,    0,    0,    0,    0,   19,
   17,   15,    0,   16,   18,   25,   13,    0,   14,    0,
    0,    0,    0,    2,    4,    5,    6,    8,    7,   42,
    0,   43,    0,   41,   35,    0,    0,   32,    0,   11,
   10,    0,    0,    0,    0,    9,   38,    0,   39,   40,
   34,   33,    0,    0,   29,   26,    0,    0,   12,   20,
   37,   36,   30,    0,   23,   22,   24,   27,
};
const short yydgoto[] = {                                      12,
   13,   14,   54,   29,   25,   20,   55,   49,   46,   42,
   58,   43,   44,
};
const short yysindex[] = {                                   -257,
 -258, -240, -227, -224, -221, -252, -226, -222, -219, -218,
 -217,    0,    0, -257, -265, -232, -216, -215, -229,    0,
    0,    0, -211,    0,    0,    0,    0, -220,    0, -214,
 -213, -262, -210,    0,    0,    0,    0,    0,    0,    0,
 -208,    0, -247,    0,    0, -251, -209,    0, -237,    0,
    0, -207, -206, -212, -262,    0,    0, -234,    0,    0,
    0,    0, -205, -202,    0,    0, -230, -204,    0,    0,
    0,    0,    0, -203,    0,    0,    0,    0,
};
const short yyrindex[] = {                                     56,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -236,    0,    0,    0,
    0,    0,    0,    0, -201,    0,    0,    0,    0,    0,
    0,    0,    0, -235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
const short yygindex[] = {                                      0,
   50,    0,   13,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   26,
};
#define YYTABLESIZE 74
const short yytable[] = {                                       1,
    2,    3,    4,    5,   52,    6,    7,   35,    8,   21,
   61,   36,   22,   15,   40,   53,    9,   23,   10,   62,
   24,   11,   41,   59,   64,   31,   28,   71,   65,   31,
   28,   16,   40,   66,   31,   28,   72,   75,   26,   27,
   41,   47,   37,   28,   17,   48,   76,   18,   19,   30,
   45,   32,   31,   57,   33,    3,   38,   39,   69,   63,
   50,   51,   56,   34,   67,   68,   74,   70,   60,   21,
   77,   73,    0,   78,
};
const short yycheck[] = {                                     257,
  258,  259,  260,  261,  267,  263,  264,  273,  266,  262,
  262,  277,  265,  272,  262,  278,  274,  270,  276,  271,
  273,  279,  270,  271,  262,  262,  262,  262,  266,  266,
  266,  272,  262,  271,  271,  271,  271,  268,  265,  266,
  270,  262,  275,  270,  272,  266,  277,  272,  270,  272,
  262,  270,  272,  262,  272,    0,  273,  273,  271,  269,
  275,  275,  273,   14,  272,  272,  269,   55,   43,  271,
  275,  277,   -1,  277,
};
#define YYFINAL 12
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 279
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"W_SPREAD",
"W_SPREADRETRYINTERVAL","W_LOG","W_GROUP","W_VIFS","W_IPADDR","W_PREFER",
"W_NOTIFY","W_NONE","W_ARPCACHE","W_AQPR","W_ALL","W_THROTTLE","W_OPENBRACE",
"W_CLOSEBRACE","W_EQUALS","W_STRING","W_MATURE","W_TIMEINTERVAL","W_BALANCE",
"W_NUMBER","W_INTERVAL","W_CONTROL",
};
const char * const yyrule[] = {
"$accept : Config",
"Config : Settings",
"Settings : Setting Settings",
"Settings :",
"Setting : W_SPREAD W_EQUALS W_STRING",
"Setting : W_SPREAD W_EQUALS W_NUMBER",
"Setting : W_SPREADRETRYINTERVAL W_EQUALS W_TIMEINTERVAL",
"Setting : W_GROUP W_EQUALS W_STRING",
"Setting : W_LOG W_EQUALS W_STRING",
"Setting : W_CONTROL W_EQUALS W_STRING",
"Setting : W_MATURE W_EQUALS W_TIMEINTERVAL",
"Setting : W_ARPCACHE W_EQUALS W_TIMEINTERVAL",
"Setting : W_BALANCE W_OPENBRACE BParams W_CLOSEBRACE",
"Setting : W_NOTIFY W_ARPCACHE",
"Setting : W_NOTIFY ClosedNOTIFYList",
"Setting : W_PREFER W_NONE",
"Setting : W_PREFER W_STRING",
"Setting : W_PREFER W_IPADDR",
"Setting : W_PREFER ClosedPIPList",
"Setting : W_VIFS ClosedVIFList",
"BParams : BParam BParams",
"BParams : BParam",
"BParam : W_AQPR W_EQUALS W_NUMBER",
"BParam : W_AQPR W_EQUALS W_ALL",
"BParam : W_INTERVAL W_EQUALS W_TIMEINTERVAL",
"ClosedNOTIFYList : W_NONE",
"ClosedNOTIFYList : W_OPENBRACE NIPList W_CLOSEBRACE",
"NIPList : NIPList W_IPADDR W_THROTTLE W_NUMBER",
"NIPList : NIPList W_IPADDR",
"NIPList : NIPList W_ARPCACHE",
"NIPList : W_IPADDR W_THROTTLE W_NUMBER",
"NIPList : W_IPADDR",
"NIPList : W_ARPCACHE",
"ClosedPIPList : W_OPENBRACE PIPList W_CLOSEBRACE",
"PIPList : PIPList W_IPADDR",
"PIPList : W_IPADDR",
"ClosedIPList : W_OPENBRACE IPList W_CLOSEBRACE",
"IPList : IPList W_IPADDR",
"IPList : W_IPADDR",
"ClosedVIFList : W_OPENBRACE VIFList W_CLOSEBRACE",
"VIFList : VIFList VIF",
"VIFList : VIF",
"VIF : W_IPADDR",
"VIF : ClosedIPList",
};
#endif
#ifndef YYSTYPE
typedef int YYSTYPE;
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 277 "config_gram.y"
int yyerror(char *str) {
  fprintf(stderr, "Parser error on or before line %d\n", line_num);
  fprintf(stderr, "Offending token: %s\n", yytext);
  return -1;
}

static void add_prefer(int addr) {
  if(Num_prefer >= MAX_PSEUDO) {
    Alarm(PRINT, "Only %d prefered allowed.\n", MAX_PSEUDO);
    return;
  }
  Prefer_address[Num_prefer++] = addr;
}
static void lookup_name(char *name, struct in_addr *ipaddr) {
}
static void yystype_to_interface(YYSTYPE *in, struct interface *out) {
  unsigned int mask;
  mask = (0xffffffff << (32-in->ip.mask));
  memcpy(out->ifname,
	 in->ip.iface, IFNAMSIZ);
  out->ipaddr = in->ip.addr;
  out->netmask.s_addr = mask;
  out->bcast.s_addr =
	((in->ip.addr.s_addr & mask) | (~mask));
}
#line 285 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 53 "config_gram.y"
{ int i, n;
			  SPIT("Main config:\n");
			  for(i=0;i<Num_pseudo;i++) {
			    entry *ve = &Allocation_table[i];
			    SPIT("\tVIF:\t[%s] %s ",
				ve->pseudo_if.ifname,
				inet_ntoa(ve->pseudo_if.ipaddr));
			    SPIT("netmask %s ",
				inet_ntoa(ve->pseudo_if.netmask));
			    SPIT("broadcast %s\n",
				inet_ntoa(ve->pseudo_if.bcast));
			    for(n=0;
				n<MAX_PSEUDO && ve->extra_ifs[n].ipaddr.s_addr;
				n++) {
			      SPIT("\t\tVE:\t[%s] %s ",
				ve->extra_ifs[n].ifname,
				inet_ntoa(ve->extra_ifs[n].ipaddr));
			      SPIT("netmask %s ",
				inet_ntoa(ve->extra_ifs[n].netmask));
			      SPIT("broadcast %s\n",
				inet_ntoa(ve->extra_ifs[n].bcast));
			    }
			  }
			}
break;
case 4:
#line 83 "config_gram.y"
{ snprintf(Spread_name, 80, "%s", yyvsp[0].string);
			  SPIT("Setting Spread: %s\n", Spread_name); }
break;
case 5:
#line 86 "config_gram.y"
{ snprintf(Spread_name, 80, "%d", yyvsp[0].number);
			  SPIT("Setting Spread: %s\n", Spread_name); }
break;
case 6:
#line 89 "config_gram.y"
{ Spread_retry_interval = yyvsp[0].tv.tv_sec;
			  SPIT("Setting SpreadRetryInteral: %d seconds\n", Spread_retry_interval); }
break;
case 7:
#line 92 "config_gram.y"
{ snprintf(Spread_group, MAX_GROUP_NAME, "%s", yyvsp[0].string);
			  SPIT("Setting Group: %s\n", Spread_group); }
break;
case 9:
#line 96 "config_gram.y"
{ snprintf(control_socket, MAXPATHLEN, yyvsp[0].string); }
break;
case 10:
#line 98 "config_gram.y"
{ Maturity_timeout.sec = yyvsp[0].tv.tv_sec;
			  Maturity_timeout.usec = 0;
			  SPIT("Setting Maturity Interval: %ld sec\n",
				(long int)Maturity_timeout.sec);
			}
break;
case 11:
#line 104 "config_gram.y"
{ ArpRefresh_timer.sec = yyvsp[0].tv.tv_sec;
			  ArpRefresh_timer.usec = 0;
			  SPIT("Setting Maturity Interval: %ld sec\n",
				(long int)ArpRefresh_timer.sec);
			}
break;
case 13:
#line 111 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  strcpy(ni->destination.ifname, "arp-cache");
			  SPIT("Adding notification %d: arp-cache\n", Num_notifications);
			}
break;
case 15:
#line 117 "config_gram.y"
{ SPIT("Prefer NONE\n");
			  add_prefer(0);
			}
break;
case 16:
#line 121 "config_gram.y"
{ struct in_addr ipaddr;
			  lookup_name(yyvsp[-1].string, &ipaddr);
			  if(ipaddr.s_addr == 0) {
			    Alarm(PRINT, "Couldn't lookup %s.\n", yyvsp[-1].string);
			  } else {
			    add_prefer(ipaddr.s_addr);
			    SPIT("Prefer (%s) %s\n",
				yyvsp[-1].string, inet_ntoa(ipaddr));
			  }
			}
break;
case 17:
#line 132 "config_gram.y"
{ unsigned int mask;
			  address Addr;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  yyvsp[0].ip.addr.s_addr &= mask;
			  Addr = yyvsp[0].ip.addr.s_addr;
			  while((Addr & mask) == (yyvsp[0].ip.addr.s_addr & mask)) {
			    add_prefer(yyvsp[0].ip.addr.s_addr);
			    SPIT("Prefer %s\n", inet_ntoa(yyvsp[0].ip.addr));
			    yyvsp[0].ip.addr.s_addr++;
			  }
			}
break;
case 22:
#line 150 "config_gram.y"
{ Balance_rate = yyvsp[0].number;
			  SPIT("Setting Balance Rate: %d\n", Balance_rate); }
break;
case 23:
#line 153 "config_gram.y"
{ Complete_balance = 1;
			  SPIT("Setting Immediate Balance\n"); }
break;
case 24:
#line 156 "config_gram.y"
{ Balance_timer.sec = yyvsp[0].tv.tv_sec;
			  Balance_timer.usec = 0;
			  SPIT("Setting Balance Interval: %ld sec\n",
				(long int)Balance_timer.sec); }
break;
case 27:
#line 165 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  yystype_to_interface(&(yyvsp[-2]), &(ni->destination));
			  ni->throttle = yyvsp[0].number;
			  SPIT("Adding notification %d: %s:%s:%s (%d/sec)\n", Num_notifications, ni->destination.ifname, inet_ntoa(ni->destination.ipaddr), inet_ntoa(ni->destination.netmask), ni->throttle);
			}
break;
case 28:
#line 171 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  yystype_to_interface(&(yyvsp[0]), &(ni->destination));
			  ni->throttle = 0;
			  SPIT("Adding notification %d: %s:%s:%s\n", Num_notifications, ni->destination.ifname, inet_ntoa(ni->destination.ipaddr), inet_ntoa(ni->destination.netmask));
			}
break;
case 29:
#line 177 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  strcpy(ni->destination.ifname, "arp-cache");
			  ni->throttle = 0;
			  SPIT("Adding notification %d: arp-cache\n", Num_notifications);
			}
break;
case 30:
#line 183 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  yystype_to_interface(&(yyvsp[-2]), &(ni->destination));
			  ni->throttle = yyvsp[0].number;
			  SPIT("Adding notification %d: %s:%s:%s (%d/sec)\n", Num_notifications, ni->destination.ifname, inet_ntoa(ni->destination.ipaddr), inet_ntoa(ni->destination.netmask), ni->throttle);
			}
break;
case 31:
#line 189 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  yystype_to_interface(&(yyvsp[0]), &(ni->destination));
			  ni->throttle = 0;
			  SPIT("Adding notification %d: %s:%s:%s\n", Num_notifications, ni->destination.ifname, inet_ntoa(ni->destination.ipaddr), inet_ntoa(ni->destination.netmask));
			}
break;
case 32:
#line 195 "config_gram.y"
{ struct notification *ni = &Notification_table[Num_notifications++];
			  strcpy(ni->destination.ifname, "arp-cache");
			  ni->throttle = 0;
			  SPIT("Adding notification %d: arp-cache\n", Num_notifications);
			}
break;
case 34:
#line 204 "config_gram.y"
{ unsigned int mask;
			  address Addr;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  yyvsp[0].ip.addr.s_addr &= mask;
			  Addr = yyvsp[0].ip.addr.s_addr;
			  while((Addr & mask) == (yyvsp[0].ip.addr.s_addr & mask)) {
			    add_prefer(yyvsp[0].ip.addr.s_addr);
			    SPIT("Prefer %s\n", inet_ntoa(yyvsp[0].ip.addr));
			    yyvsp[0].ip.addr.s_addr++;
			  }
			}
break;
case 35:
#line 216 "config_gram.y"
{ unsigned int mask;
			  address Addr;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  yyvsp[0].ip.addr.s_addr &= mask;
			  Addr = yyvsp[0].ip.addr.s_addr;
			  while((Addr & mask) == (yyvsp[0].ip.addr.s_addr & mask)) {
			    add_prefer(yyvsp[0].ip.addr.s_addr);
			    SPIT("Prefer %s\n", inet_ntoa(yyvsp[0].ip.addr));
			    yyvsp[0].ip.addr.s_addr++;
			  }
			}
break;
case 36:
#line 229 "config_gram.y"
{ if(iplistn<MAX_PSEUDO) {
			    tmpe[Num_pseudo].extra_ifs[iplistn].ipaddr.s_addr=0;
			  }
			  iplistn=0;
			}
break;
case 37:
#line 236 "config_gram.y"
{ unsigned int mask;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  memcpy(&tmpe[Num_pseudo].extra_ifs[iplistn].ifname,
				 yyvsp[0].ip.iface, IFNAMSIZ);
			  tmpe[Num_pseudo].extra_ifs[iplistn].ipaddr = yyvsp[0].ip.addr;
			  tmpe[Num_pseudo].extra_ifs[iplistn].netmask.s_addr = mask;
			  tmpe[Num_pseudo].extra_ifs[iplistn].bcast.s_addr =
				((yyvsp[0].ip.addr.s_addr & mask) | (~mask));
			  iplistn++;
			}
break;
case 38:
#line 247 "config_gram.y"
{ unsigned int mask;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  memcpy(&tmpe[Num_pseudo].pseudo_if.ifname,
				 yyvsp[0].ip.iface, IFNAMSIZ);
			  tmpe[Num_pseudo].pseudo_if.ipaddr = yyvsp[0].ip.addr;
			  tmpe[Num_pseudo].pseudo_if.netmask.s_addr = mask;
			  tmpe[Num_pseudo].pseudo_if.bcast.s_addr =
				((yyvsp[0].ip.addr.s_addr & mask) | (~mask));
			}
break;
case 40:
#line 260 "config_gram.y"
{ Num_pseudo++; }
break;
case 41:
#line 262 "config_gram.y"
{ Num_pseudo++; }
break;
case 42:
#line 265 "config_gram.y"
{ unsigned int mask;
			  mask = (0xffffffff << (32-yyvsp[0].ip.mask));
			  memcpy(&tmpe[Num_pseudo].pseudo_if.ifname,
				 yyvsp[0].ip.iface, IFNAMSIZ);
			  tmpe[Num_pseudo].pseudo_if.ipaddr = yyvsp[0].ip.addr;
			  tmpe[Num_pseudo].pseudo_if.netmask.s_addr = mask;
			  tmpe[Num_pseudo].pseudo_if.bcast.s_addr =
				((yyvsp[0].ip.addr.s_addr & mask) | (~mask));
			}
break;
#line 733 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
