
/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "bookmark.h"

@implementation Bookmark

+ alloc {
    self = [super alloc];
    return self;
}

- initWithSite: (NSString*) site withLogin: (NSString*) login withPassword: (NSString*) password {
    _site = [[NSString alloc] initWithString: site];
    _login = [[NSString alloc] initWithString: login];
    _password = [[NSString alloc] initWithString: password];
    _anonymous = NO;
    return self;
}

- initWithAnonymousSite: (NSString*) site {
    _site = [[NSString alloc] initWithString: site];
    _login = [[NSString alloc] initWithString: @"anonymous"];
    _password = [[NSString alloc] initWithString: @"test@test.com"];
    _anonymous = YES;
    return self;
}

- (NSString*) site { return _site; }
- (NSString*) login { return _login; }
- (NSString*) password { return _password; }
- (BOOL) isAnonymous { return _anonymous; }

@end
