# auth-lib.pl
# Functions for editing text and dbm user files

# list_authusers(file)
# Returns an array of user names from the given file
sub list_authusers
{
local($_, @rv);
open(HTPASSWD, $_[0]);
while(<HTPASSWD>) {
	if (/^(\S+):(\S*)/) { push(@rv, $1); }
	}
close(HTPASSWD);
return @rv;
}

# get_authuser(file, name)
sub get_authuser
{
local($_, $rv);
open(HTPASSWD, $_[0]);
while(<HTPASSWD>) {
	if (/^(\S+):(\S*)/ && $1 eq $_[1]) {
		$rv = { 'user' => $1 , 'pass' => $2 };
		}
	}
close(HTPASSWD);
return $rv;
}

# save_authuser(file, olduser, &details)
sub save_authuser
{
local($_, @htpasswd);
open(HTPASSWD, $_[0]);
@htpasswd = <HTPASSWD>;
close(HTPASSWD);
open(HTPASSWD, "> $_[0]");
foreach (@htpasswd) {
	if (/^(\S+):(\S*)/ && $1 eq $_[1]) {
		print HTPASSWD $_[2]->{'user'},":",$_[2]->{'pass'},"\n";
		}
	else { print HTPASSWD $_; }
	}
close(HTPASSWD);
}

# create_authuser(file, &details)
# Add a new user to a file
sub create_authuser
{
open(HTPASSWD, ">> $_[0]");
print HTPASSWD $_[1]->{'user'},":",$_[1]->{'pass'},"\n";
close(HTPASSWD);
}

# delete_authuser(file, user)
# Delete some user from a file
sub delete_authuser
{
local($_, @htpasswd);
open(HTPASSWD, $_[0]);
@htpasswd = <HTPASSWD>;
close(HTPASSWD);
open(HTPASSWD, "> $_[0]");
foreach (@htpasswd) {
	if (!/^(\S+):(\S*)/ || $1 ne $_[1]) { print HTPASSWD $_; }
	}
close(HTPASSWD);
}

###########################################################################
# Group Functions
###########################################################################

# list_authgroups(file)
# Returns an array of associative arrays containing information about
# groups from some text file
sub list_authgroups
{
local($_, @rv);
open(HTGROUP, $_[0]);
while(<HTGROUP>) {
	if (/^(\S+):\s*(.*)/) {
		local($gr, @mems);
		$gr = $1; @mems = split(/\s+/, $2);
		push(@rv, { 'group' => $gr, 'members' => \@mems });
		}
	}
close(HTGROUP);
return @rv;
}

# get_authgroup(file, group)
sub get_authgroup
{
local(@tmp, $t);
@tmp = &list_authgroups($_[0]);
foreach $t (@tmp) {
	if ($t->{'group'} eq $_[1]) { return $t; }
	}
return undef;
}

# create_authgroup(file, &details)
sub create_authgroup
{
open(HTGROUP, ">> $_[0]");
print HTGROUP $_[1]->{'group'},": ",join(' ', @{$_[1]->{'members'}}),"\n";
close(HTGROUP);
}

# save_authgroup(file, oldgroup, &details)
sub save_authgroup
{
open(HTGROUP, $_[0]);
@htgroup = <HTGROUP>;
close(HTGROUP);
open(HTGROUP, "> $_[0]");
foreach (@htgroup) {
	if (/^(\S+):\s*(.*)/ && $1 eq $_[1]) {
		print HTGROUP $_[2]->{'group'},": ",
			      join(' ', @{$_[2]->{'members'}}),"\n";
		}
	else { print HTGROUP $_; }
	}
close(HTGROUP);
}

# delete_authgroup(file, group)
sub delete_authgroup
{
open(HTGROUP, $_[0]);
@htgroup = <HTGROUP>;
close(HTGROUP);
open(HTGROUP, "> $_[0]");
foreach (@htgroup) {
	if (!/^(\S+):\s*(.*)/ || $1 ne $_[1]) { print HTGROUP $_; }
	}
close(HTGROUP);
}

1;

