/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

class SpeedRead {
    PrintWriter out;
    BufferedReader in;
    Socket sock;

    boolean Init(String string, int n) {
        try {
            this.sock = new Socket(string, n);
            this.out = new PrintWriter(this.sock.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        }
        catch (Exception exception) {
            System.err.println("Could not connect to the server!");
            return false;
        }
        return true;
    }

    void Close() {
        try {
            this.out.print("quit\r\n");
            this.out.flush();
            this.in.close();
            this.out.close();
            this.sock.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    SpeedInfo Read() {
        try {
            SpeedInfo speedInfo = new SpeedInfo();
            this.out.print("gos\r\n");
            this.out.flush();
            String string = this.in.readLine();
            if (!string.startsWith("000 Counters: ")) {
                throw new Exception("Server reported: " + string);
            }
            speedInfo.Cols = Integer.valueOf(string.substring(14));
            string = this.in.readLine();
            if (!string.startsWith("000 Time: ")) {
                throw new Exception("Server reported: " + string);
            }
            int n = string.indexOf(32, 10);
            speedInfo.Time = Double.valueOf(string.substring(10, n)) + Double.valueOf(string.substring(n + 1)) / 1000000.0;
            speedInfo.ColNames = new String[speedInfo.Cols];
            speedInfo.ColValues = new long[speedInfo.Cols];
            int n2 = 0;
            while (n2 < speedInfo.Cols) {
                string = this.in.readLine();
                int n3 = string.indexOf(58);
                int n4 = string.indexOf(58, n3 + 2);
                speedInfo.ColNames[n2] = string.substring(4, n3);
                speedInfo.ColValues[n2] = (Long.valueOf(string.substring(n3 + 2, n4)) << 32) + Long.valueOf(string.substring(n4 + 1));
                ++n2;
            }
            return speedInfo;
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
            return null;
        }
    }

    SpeedRead() {
    }

    class SpeedInfo {
        int Cols;
        String[] ColNames;
        long[] ColValues;
        double Time;

        public SpeedInfo Subtract(SpeedInfo speedInfo) {
            SpeedInfo speedInfo2 = new SpeedInfo();
            speedInfo2.Cols = this.Cols;
            speedInfo2.ColValues = new long[this.Cols];
            int n = 0;
            while (n < this.Cols) {
                speedInfo2.ColValues[n] = this.ColValues[n] - speedInfo.ColValues[n];
                ++n;
            }
            speedInfo2.Time = this.Time - speedInfo.Time;
            if (speedInfo2.Time < 0.1) {
                speedInfo2.Time = 1.0;
            }
            return speedInfo2;
        }

        SpeedInfo() {
            SpeedRead.this = SpeedRead.this;
        }
    }
}

