
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <list>
#include <cctype>
#include <cerrno>


#ifdef USE_FRIBIDI

// WARNING: the following line makes this file to depend on Qt
#include <qglobal.h>
#undef DEBUG
#if QT_VERSION < 300
#define DONT_USE_UTF8
#endif

extern "C" {
#include <fribidi.h>
}
#endif


#ifdef HONOR_STD
using std::istream ;
using std::ostream ;
using std::ifstream ;
using std::endl ;
#endif

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str) gettext(str)
#else
#define _(str) (str)
#endif
#define N_(str) (str)

#include "hebrew.h"

/* Support for Hebrew */
// Patch by Yedidyah Bar-David <didi@tau.ac.il>

// Ricardo Villalba <rvm@escomposlinux.org> modified it a little
// for not breaking support for the other Babylon's dictionaries.

inline
char
babylon_hebrew::bab_to_char_heb( int c )
{
    return " ;,'."[ c ] ;
}

string
babylon_hebrew::read_word_heb( unsigned int length )
{
    static char*        compact_table[] = {
	"XX", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", ""
    } ;

    string              def ;
    u16                 data ;

    def.reserve( length ) ;

    while ( length > 0 ) {
        data = read_val( file_def , 2 ) ;
        if ( data < 32768 ) {
            def += bab_to_char_heb( (int)( data & 0x1F ) ) ;
            data >>= 5 ;
            def += bab_to_char_heb( (int)( data & 0x1F ) ) ;
            data >>= 5 ;
            def += bab_to_char_heb( (int)( data & 0x1F ) ) ;
            length -= 3 ;
        } else {
            int                 lsb = (int)( data & 0xFF ) ;
            int                 msb = (int)( ( data >> 8 ) & 0x7F ) ;

            if ( lsb >= 32 ) {
		if ( lsb <= 126 )
                    def += (char)lsb ;
		else
		    if ( lsb <= 128+32 )
			def += bab_to_char_heb( (int)( lsb - 128 ) ) ;
		    else
			def += "X" ;
                -- length ;
            } else {
                def += compact_table[ lsb ] ;
                length -= 2 ;
            }
            if ( length == 0 )
                break ;
            if ( length < 0 ) {
#ifdef DEBUG
                warn( "buffer underflow" ) ;
#endif
                return string() ;
            }

            if ( msb >= 32 ) {
                def += (char)msb ;
                -- length ;
            } else if ( msb > 0 ) {
                def += compact_table[ msb ] ;
                length -= 2 ;
            } /* Note that in hebrew, msb==0 => no output at all */ 
        }
    }
    return def ;
}

/* Make a new definition node */
/* pos indicate the position of the definition in file_def file */
babylon::item
babylon_hebrew::make_definition( size_t pos )
{
    item                def ;

    file_def.seekg( pos ) ;

    def.attrib.erase() ;
    for ( int i = 0 ; i < 7 ; ++ i ) {
        int                 v = (int)read_val( file_def , 1 ) ;
        def.attrib += "0123456789ABCDEF"[ v/16 ] ;
        def.attrib += "0123456789ABCDEF"[ v%16 ] ;
    }

    int                 sz = (int)read_val( file_def , 1 ) ;

    def.word = read_word( sz ) ;

    sz = (int)read_val( file_def , 1 ) ;
#ifdef DEBUG
    if ( sz == 0 )
        warn( "Null definition" ) ;
#endif

#ifdef USE_FRIBIDI
    def.definition = reverse_visual_to_logical_hebrew(read_word_heb( sz ) );
#else
    def.definition = read_word_heb( sz ) ;
#endif
    return def;
}

/*
 * The file Engtoheb stores the hebrew definitions in 'reverse visual'
 * format. This function does a reverse to get to 'visual', and then
 * uses fribidi to convert to logical. This is not perfect, since
 * log2vis != vis2log, but they are close enough to have almost always
 * acceptable output.
 */
#ifdef USE_FRIBIDI
string
babylon_hebrew::reverse_visual_to_logical_hebrew( string s )
{
    int                vislen = s.length();
    char               *s1=(char *)malloc(2*vislen*sizeof(char));
    FriBidiChar   *logical=(FriBidiChar *)malloc(2*vislen*sizeof(FriBidiChar));
    FriBidiChar   *visual=(FriBidiChar *)malloc(2*vislen*sizeof(FriBidiChar));
    char               *outstr=(char *)malloc(2*vislen*sizeof(char));
    FriBidiCharSet     char_set;
    FriBidiCharType    base = FRIBIDI_TYPE_RTL;
    string             def;
    int                len;

    for (int i=0; i<vislen; i++) {
        s1[vislen - i - 1] = s[i];
    }
    s1[vislen]='\0';
    
    char_set = fribidi_parse_charset("ISO8859-8");
    len = fribidi_charset_to_unicode (char_set, s1, vislen, logical);
    fribidi_log2vis (logical, len, &base, visual, NULL, NULL, NULL);
#ifndef DONT_USE_UTF8
    char_set = fribidi_parse_charset("UTF-8");
#endif
    fribidi_unicode_to_charset (char_set, visual, len, outstr);

//#ifndef DONT_USE_UTF8
//    def = "\342\200\253";
//	def += (string)outstr;
//#else

    def = (string)outstr;

//#endif

    free(s1); free(logical); free(visual); free(outstr);
    return def;
}

string
babylon_hebrew::get_charset() {
#ifdef DONT_USE_UTF8
    return "ISO-8859-8";
#else
    return "UTF-8";
#endif
}
#endif //USE_FRIBIDI

#ifndef USE_FRIBIDI
string
babylon_hebrew::get_charset() {
    return "ISO-8859-8";
}
#endif
/* End of functions for Hebrew */

