/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This file is based on the qbrowser example from Qt.
    The license of the modified files are the same as the
    example.
*/

/****************************************************************************
** $Id: helpwindow.cpp,v 1.9.2.1 1999/07/13 19:17:55 reggie Exp $
**
** Copyright (C) 1992-1999 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifdef HAVE_KDELIBS3
#include "khelpwindow.h"
#include <kpopupmenu.h> //KDE 3
#include <kstatusbar.h> //KDE 3
#else
#include "helpwindow.h"
#endif

#include <qstatusbar.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qiconset.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstylesheet.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qapplication.h>
#include <qcombobox.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qobjectlist.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qglobal.h>
#include <qdragobject.h>
#include <qclipboard.h>

#include <ctype.h>

#include "back.xpm"
#include "forward.xpm"
#include "home.xpm"
#include "../intern.h"
#include "../qfunciones.h"
#include "../pixmaps/fileprint.xpm"
#include <QConfig.h>

#include <qcursor.h> //QT3

#ifdef DEFAULT_GRAPHIC
#include "image.xpm"

HWMimeSourceFactory::HWMimeSourceFactory() : QMimeSourceFactory() {
	QPixmap none( image_xpm );
	setPixmap( "no_image.xpm", none );
}
                                                                                
const QMimeSource* HWMimeSourceFactory::data(const QString & abs_name) const {
	debug("data: '%s'", abs_name.latin1());
	const QMimeSource *src=QMimeSourceFactory::data(abs_name);

	QString ext=QFileInfo(abs_name).extension();
	debug("extension: '%s'", ext.latin1());
	if ( (ext=="png") || (ext=="xpm") || (ext=="gif") ||
         (ext=="jpg") || (ext=="jpeg") || (ext=="bmp") ) 
	{
		if ( (src==NULL) || (!QImageDrag::canDecode(src)) ) {
			return QMimeSourceFactory::data("no_image.xpm");
		}
	}
	return src;
}
#endif


MyTextBrowser::MyTextBrowser( QWidget * parent, const char * name) 
	: QTextBrowser( parent, name ) 
{
#ifdef DEFAULT_GRAPHIC
	setMimeSourceFactory( new HWMimeSourceFactory() );
#endif

	QMimeSourceFactory *f=mimeSourceFactory();

	f->setText("no_html_allowed", 
                _("<qt type=\"detail\"><h2>QBROWSER ERROR</h2>"
			   "<p>Sorry, this simple html browser only can display local files.</p></qt>") );
	f->setText("no_ftp_allowed", 
                _("<qt type=\"detail\"><h2>QBROWSER ERROR</h2>"
			   "<p>Sorry, this simple html browser only can display local files.</p></qt>") );
	f->setText("no_mail_allowed", 
               _("<qt type=\"detail\"><h2>QBROWSER ERROR</h2>"
			   "<p>Sorry, this simple html browser cannot manage mail addresses.</p></qt>") );

	menu = new QPopupMenu(this, "menu_qsimpletextbrowser");
#if QT_VERSION >= 210
	menu->insertItem( _("Copy"), this, SLOT( copy() ) );
	menu->insertItem( _("Select all"), this, SLOT( selectAll() ) );
#else
	menu->insertItem( _("Copy text to clipboard"), this, SLOT( copyText() ) );
#endif
}

void MyTextBrowser::setSource( const QString & name ) {
	//debug("Name: '%s'", name.latin1());

	if ( (name.left(5) == "http:") || (name.left(5) == "HTTP:") ) {
		QTextBrowser::setSource( "no_html_allowed" );
	}
	else
	if ( (name.left(4) == "ftp:") || (name.left(4) == "FTP:") ) {
		QTextBrowser::setSource( "no_ftp_allowed" );
	}
	else
	if ( name.contains('@') ) {
		QTextBrowser::setSource( "no_mail_allowed" );
	}
	else
	QTextBrowser::setSource( name );
}

void MyTextBrowser::copyText() {
	QClipboard *cb = QApplication::clipboard();
	cb->setText( text() );
}

void MyTextBrowser::viewportMousePressEvent( QMouseEvent *e) {
	QTextBrowser::viewportMousePressEvent(e);

	if ( e->button() == RightButton ) {
		menu->popup( QCursor::pos() ); 
	}
}


HelpWindow *HelpWindow::help_window=NULL;

HelpWindow *HelpWindow::defaultHelpWindow() {
	if (HelpWindow::help_window==NULL) {
		debug("Creando HelpWindow::help_window");
		HelpWindow::help_window=new HelpWindow( QString::null, ".", 0, "helpwindow");
	}
	return HelpWindow::help_window;
}

HelpWindow::HelpWindow( const QString& inicio, const QString& _path, QWidget* parent, const char *name )
#ifdef HAVE_KDELIBS3
    : KMainWindow( parent, name, WType_TopLevel ), 
#else
    : QMainWindow( parent, name, WType_TopLevel ), 
#endif
      pathCombo( 0 ), selectedURL()
{
	fixStyleSheet();

	QString home_( quitaTipo(inicio) );

#ifdef AUTO_COMPLETE
	path= QDir( QFileInfo( home_ ).dirPath( TRUE ), "*.htm*" );
    fileList = path.entryList();
#endif

    browser = new MyTextBrowser( this );
    browser->mimeSourceFactory()->setFilePath( _path );
    browser->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    connect( browser, SIGNAL( textChanged() ),
             this, SLOT( textChanged() ) );
    setCentralWidget( browser );

    if ( !home_.isEmpty() )
        browser->setSource( home_ );

    connect( browser, SIGNAL( highlighted( const QString&) ),
             statusBar(), SLOT( message( const QString&)) );

    resize( 640,700 );

    QPopupMenu* file = new QPopupMenu( this );
    file->insertItem( _("&New Window"), this, SLOT( newWindow() ), ALT | Key_N );
    file->insertItem( _("&Open File"), this, SLOT( openFile() ), ALT | Key_O );
	file->insertItem( QPixmap(fileprint_xpm), _("&Print..."), this, SLOT( imprimir() ) );
    file->insertSeparator();
    file->insertItem( _("&Close"), this, SLOT( close() ), ALT | Key_Q );
    //file->insertItem( _("E&xit"), qApp, SLOT( closeAllWindows() ), ALT | Key_X );

    QPopupMenu* go = new QPopupMenu( this );
    backwardId = go->insertItem( QPixmap( back_xpm),
                                 _("&Backward"), browser, SLOT( backward() ),
                                 ALT | Key_Left );
    forwardId = go->insertItem( QPixmap(forward_xpm),
                                _("&Forward"), browser, SLOT( forward() ),
                                ALT | Key_Right );
    go->insertItem( QPixmap(home_xpm), _("&Home"), browser, SLOT( home() ) );

    QPopupMenu* help = new QPopupMenu( this );
    help->insertItem( _("&About ..."), this, SLOT( about() ) );
    //help->insertItem( _("About &Qt ..."), this, SLOT( aboutQt() ) );

    hist = new QPopupMenu( this );
	hist->insertItem( _("&Clear"), this, SLOT( clearHistory() ) );
	hist->insertSeparator();
    connect( hist, SIGNAL( activated( int ) ),
             this, SLOT( histChosen( int ) ) );

    bookm = new QPopupMenu( this );
    bookm->insertItem( _( "&Add Bookmark" ), this, SLOT( addBookmark() ) );
    bookm->insertSeparator();
    connect( bookm, SIGNAL( activated( int ) ),
             this, SLOT( bookmChosen( int ) ) );

    menuBar()->insertItem( _("&File"), file );
    menuBar()->insertItem( _("&Go"), go );
    menuBar()->insertItem( _("H&istory"), hist );
    menuBar()->insertItem( _("&Bookmarks"), bookm );
    menuBar()->insertSeparator();
    menuBar()->insertItem( _("&Help"), help );

    menuBar()->setItemEnabled( forwardId, FALSE);
    menuBar()->setItemEnabled( backwardId, FALSE);
    connect( browser, SIGNAL( backwardAvailable( bool ) ),
             this, SLOT( setBackwardAvailable( bool ) ) );
    connect( browser, SIGNAL( forwardAvailable( bool ) ),
             this, SLOT( setForwardAvailable( bool ) ) );


    QToolBar* toolbar = new QToolBar( this );
    addToolBar( toolbar, "Toolbar");
    QToolButton* button;

    button = new QToolButton( QPixmap(back_xpm), _("Backward"), "", browser, SLOT(backward()), toolbar );
    connect( browser, SIGNAL( backwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
    button->setEnabled( FALSE );
    button = new QToolButton( QPixmap(forward_xpm), _("Forward"), "", browser, SLOT(forward()), toolbar );
    connect( browser, SIGNAL( forwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
    button->setEnabled( FALSE );
    button = new QToolButton( QPixmap(home_xpm), _("Home"), "", browser, SLOT(home()), toolbar );

    toolbar->addSeparator();

    pathCombo = new QComboBox( TRUE, toolbar );
    connect( pathCombo, SIGNAL( activated( const QString & ) ),
             this, SLOT( pathSelected( const QString & ) ) );
    toolbar->setStretchableWidget( pathCombo );
    setRightJustification( TRUE );

    pathCombo->insertItem( home_ );

#ifdef AUTO_COMPLETE
    pathCombo->installEventFilter( this );
    QObjectList *l = queryList( "QLineEdit" );
    if ( l && l->first() )
        ( (QLineEdit*)l->first() )->installEventFilter( this );
#endif

    browser->setFocus();


	conf = new QConfig( QConfig::configName("qbrowser").latin1() );
	leeConfig();
}

void HelpWindow::fixStyleSheet() {
#if QT_VERSION < 210
    QStyleSheetItem* style;

    // Modify the application-wide default style sheet to handle
    // some extra HTML gracefully.
    //
    // Ignore any bodytext in <head>...</head>:
    style = new QStyleSheetItem( QStyleSheet::defaultSheet(), "head" );
    style->setDisplayMode(QStyleSheetItem::DisplayNone);
    //
    // Not in default style sheet, just fake it:
    style = new QStyleSheetItem( QStyleSheet::defaultSheet(), "dl" );
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style = new QStyleSheetItem( QStyleSheet::defaultSheet(), "dt" );
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setContexts("dl");
#endif

    //
    // Many HTML files omit the </p> or </li>, so we add this for efficiency:
    QStyleSheet::defaultSheet()->item("p")->setSelfNesting( FALSE );
    QStyleSheet::defaultSheet()->item("li")->setSelfNesting( FALSE );
}


QString HelpWindow::quitaTipo(const QString & url ) {
	//debug("quitaTipo");

	QString tipo;
	QString direccion;

	int pos= url.find(':');
	if (pos > -1 ) {
		tipo= url.left( pos );
		direccion= url.mid( pos+1 );
	} else {
		direccion= url;
	}

	tipo=tipo.simplifyWhiteSpace();
	direccion=direccion.simplifyWhiteSpace();

	//debug("Tipo: '%s' Direccion: '%s'", tipo.latin1(), direccion.latin1());

	if ( tipo == "file" )
		return direccion;
	else
		return url;
}

void HelpWindow::setBackwardAvailable( bool b)
{
    menuBar()->setItemEnabled( backwardId, b);
}

void HelpWindow::setForwardAvailable( bool b)
{
    menuBar()->setItemEnabled( forwardId, b);
}


void HelpWindow::textChanged()
{
    if ( browser->documentTitle().isNull() ) 
        setCaption( browser->context() );
    else 
        setCaption( browser->documentTitle() ) ;

    selectedURL = browser->context();

    if ( !selectedURL.isEmpty() && pathCombo ) {
#ifdef AUTO_COMPLETE
        path = QDir( QFileInfo( selectedURL ).dirPath( TRUE ), "*.htm*" );
        fileList = path.entryList();
#endif
        bool exists = FALSE;
        int i;
        for ( i = 0; i < pathCombo->count(); ++i ) {
            if ( pathCombo->text( i ) == selectedURL ) {
                exists = TRUE;
                break;
            }
        }
        if ( !exists ) {
            pathCombo->insertItem( selectedURL, 0 );
            pathCombo->setCurrentItem( 0 );
            mHistory[ hist->insertItem( selectedURL ) ] = selectedURL;
        } else
            pathCombo->setCurrentItem( i );
        selectedURL = QString::null;
    }
}

HelpWindow::~HelpWindow()
{
	//debug("Destruyendo qbrowser");
	delete conf;
}

void HelpWindow::about()
{
    QMessageBox::about( this, _("Simple HTML Viewer"),
		_("<p>This simple html viewer is based on a Qt example (qbrowser). "
		  "The license of this viewer is the same as that example:</p>"
		  "<p>You may use, distribute and modify it without limitation.</p>"));
}

/*
void HelpWindow::aboutQt()
{
    QMessageBox::aboutQt( this, "QBrowser" );
}
*/

void HelpWindow::openFile()
{
    QString fn = QFileDialog::getOpenFileName( QString::null, QString::null, this );
    if ( !fn.isEmpty() )
        browser->setSource( fn );
}

void HelpWindow::newWindow()
{
    ( new HelpWindow(browser->source(), "qbrowser") )->show();
}

void HelpWindow::pathSelected( const QString &_path )
{
    browser->setSource( _path );
#ifdef AUTO_COMPLETE
    path = QDir( QFileInfo( _path ).dirPath( TRUE ), "*.htm*" );
    fileList = path.entryList();
#endif
    QMap<int, QString>::Iterator it = mHistory.begin();
    bool exists = FALSE;
    for ( ; it != mHistory.end(); ++it ) {
        if ( *it == _path ) {
            exists = TRUE;
            break;
        }
    }
    if ( !exists )
        mHistory[ hist->insertItem( _path ) ] = _path;
}

#ifdef AUTO_COMPLETE
bool HelpWindow::eventFilter( QObject * o, QEvent * e )
{
    QObjectList *l = queryList( "QLineEdit" );
    if ( !l || !l->first() )
        return FALSE;

    QLineEdit *lined = (QLineEdit*)l->first();

    if ( ( o == pathCombo || o == lined ) &&
         e->type() == QEvent::KeyPress ) {

        if ( isprint(((QKeyEvent *)e)->ascii()) ) {
            if ( lined->hasMarkedText() )
                lined->del();
            QString nt( lined->text() );
            nt.remove( 0, nt.findRev( '/' ) + 1 );
            nt.truncate( lined->cursorPosition() );
            nt += (char)(((QKeyEvent *)e)->ascii());

            QStringList::Iterator it = fileList.begin();
            while ( it != fileList.end() && (*it).left( nt.length() ) != nt )
                ++it;

            if ( !(*it).isEmpty() ) {
                nt = *it;
                int cp = lined->cursorPosition() + 1;
                int l = path.canonicalPath().length() + 1;
                lined->validateAndSet( path.canonicalPath() + "/" + nt, cp, cp, l + nt.length() );
                return TRUE;
            }
        }
    }

    return FALSE;
}
#endif

void HelpWindow::histChosen( int i )
{
    if ( mHistory.contains( i ) )
        browser->setSource( mHistory[ i ] );
}

void HelpWindow::bookmChosen( int i )
{
    if ( mBookmarks.contains( i ) )
        browser->setSource( mBookmarks[ i ] );
}

void HelpWindow::addBookmark()
{
    mBookmarks[ bookm->insertItem( browser->context() ) ] = browser->context();
}

void HelpWindow::clearHistory() {
    QMap<int, QString>::Iterator it = mHistory.begin();
    for ( ; it != mHistory.end(); ++it ) {
		hist->removeItem( it.key() );
	}

	mHistory.clear();
}

void HelpWindow::goTo(const QString & direccion) {
	QString url= quitaTipo( direccion );
	browser->setSource( url );
}

void HelpWindow::closeEvent(QCloseEvent *e) {
	guardaConfig();
	e->accept();
}

void HelpWindow::leeConfig() {
	conf->setGroup("Appearance");
	QSize s( size() );
	//QSize s(570, 336);                              // Tamao por defecto
	resize( conf->readSizeEntry("WSize", s) );

	QString nombre;
	int lineas=0;

	//HISTORY
	conf->setGroup("History");
	lineas = conf->readNumEntry( "lines", 0 );
	for (int n=0; n < lineas; n++) {
		nombre.sprintf( "line%d", n );
		QString s= conf->readEntry( nombre.latin1(), "" );
        mHistory[ hist->insertItem( s ) ] = s;
	}

	//BOOKMARKS
	conf->setGroup("Bookmarks");
	lineas = conf->readNumEntry( "lines", 0 );
	for (int n=0; n < lineas; n++) {
		nombre.sprintf( "line%d", n );
		QString s= conf->readEntry( nombre.latin1(), "" );
        mBookmarks[ bookm->insertItem( s ) ] = s;
	}
}

void HelpWindow::guardaConfig() {
	conf->setGroup("Appearance");
	conf->writeSizeEntry("WSize", size() );

	QString nombre;
	int contador=0;

	//HISTORY
	conf->setGroup("History");
	contador=0;
    QMap<int, QString>::Iterator it = mHistory.begin();
    for ( ; it != mHistory.end(); ++it ) {
		nombre.sprintf( "line%d", contador );
		conf->writeEntry( nombre.latin1(), (*it).latin1() );
		contador++;
	}
	conf->writeNumEntry( "lines", contador );

	//BOOKMARKS
	conf->setGroup("Bookmarks");
	contador=0;
    QMap<int, QString>::Iterator it2 = mBookmarks.begin();
    for ( ; it2 != mBookmarks.end(); ++it2 ) {
		nombre.sprintf( "line%d", contador );
		conf->writeEntry( nombre.latin1(), (*it2).latin1() );
		contador++;
	}
	conf->writeNumEntry( "lines", contador );

	conf->sync();
}

void HelpWindow::imprimir() {
	imprimir_textview(browser);
}

#ifdef HAVE_KDELIBS3
#include "khelpwindow.moc.cpp"
#else
#include "helpwindow.moc.cpp"
#endif

