// $Id: CallbacksBrowseOperations.cpp,v 1.10 2003/02/27 23:44:53 zongo Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string>
#include <sstream>
#include <iostream>

#include <math.h>
#ifdef WIN32
# define M_PI  3.1416f
#endif

#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"

#include "../Application.h"
#include "../Main.h"

#include "../EntityTool.h"
#include "../EntityOps.h"

#include "CallbacksBrowse.h"
#include "UIGtk.h"

// Helper function
static std::string GetStringFromFloat(scalar f)
{
    std::ostringstream out;
    out << f;
    return out.str();
}

// Update Informations
void UpdateBrowseInfo(const Ark::Vector3& camera, const Ark::Vector3& lookat)
{
    if (!g_MainWindow) return;

    GtkWidget* longitude = lookup_widget(GTK_WIDGET(g_MainWindow),
					  "BILongitudeEntry");

    GtkWidget* latitude = lookup_widget(GTK_WIDGET(g_MainWindow),
					"BILatitudeEntry");

    GtkWidget* height = lookup_widget(GTK_WIDGET(g_MainWindow),
				      "BIHeightEntry");

    GtkWidget* distance = lookup_widget(GTK_WIDGET(g_MainWindow),
					"BIDistanceEntry");

    GtkWidget* angle = lookup_widget(GTK_WIDGET(g_MainWindow),
				     "BIAngleEntry");

    std::string out;
    out = GetStringFromFloat( lookat.X );
    gtk_entry_set_text( GTK_ENTRY(longitude), out.c_str());

    out = GetStringFromFloat( lookat.Z );
    gtk_entry_set_text( GTK_ENTRY(latitude), out.c_str());

    out = GetStringFromFloat( lookat.Y );
    gtk_entry_set_text( GTK_ENTRY(height), out.c_str());

    Ark::Vector3 diff(lookat - camera);
    
    out = GetStringFromFloat( diff.GetMagnitude() );
    gtk_entry_set_text( GTK_ENTRY(distance), out.c_str());

    out = GetStringFromFloat( 180.0f - 180.0f / M_PI * atan2f(diff.X, diff.Z) );
    gtk_entry_set_text( GTK_ENTRY(angle), out.c_str());

}

static int s_EntityOp = 0;

static void CreateAndSetNewTool()
{
  Application* a = Application::GetApplication();
  a->SetTool(a->NewEntityTool(s_EntityOp));
}

// A entity mode has been selected for editing
void SelectEntityMode(int op)
{
   s_EntityOp = op;
   CreateAndSetNewTool();
}


// Browse tool has been chosen
void UpdateBrowse()
{
  CreateAndSetNewTool();
}


// Set the transform list to the list given
void InitEntityOps(const EntityOpList& ops)
{
  // FIXME non const char for CLists sucks
  gchar *columns[] = { (char*)"" };

  GtkWidget* widget = lookup_widget( GTK_WIDGET(g_MainWindow),
				     "EntityModeList");
  GtkCList* list = GTK_CLIST( widget );

  gtk_clist_freeze(list);
  gtk_clist_clear(list);

  // FIXME use for_each algorithm
  for (EntityOpList::const_iterator i = ops.begin() ;
        i != ops.end() ; 
        ++i)
  {
    char* name = const_cast<char*>((*i)->m_Name.c_str());
    GdkPixmap* pixmap;
    GdkBitmap* bitmap;

    gint row = gtk_clist_append(list, columns);
    
    GtkPixmap* w = GTK_PIXMAP(create_pixmap(g_MainWindow,
					    (*i)->m_Icon.c_str()));
    gtk_pixmap_get(w, &pixmap, &bitmap);
    gtk_clist_set_pixtext(list, row, 0, name, 4, pixmap, bitmap);

  }
  
  gtk_clist_thaw(list);  
}
