/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Preferences_H
#define	FSK441Preferences_H

#include <wx/wx.h>
#include <wx/notebook.h>

#include "common/PersonalPreferences.h"
#include "common/MessagePreferences.h"
#include "common/SoundPreferences.h"
#include "common/PTTPreferences.h"

#include "FSK441ProtocolPreferences.h"

class CFSK441Preferences : public wxDialog {

    public:
	CFSK441Preferences(wxWindow* parent, int id = -1);
	virtual ~CFSK441Preferences();

	virtual void onOK(const wxCommandEvent& event);
	virtual void onCancel(const wxCommandEvent& event);

    private:
	CPersonalPreferences*       m_personal;
	CMessagePreferences*        m_message;
	CSoundPreferences*          m_sound;
	CPTTPreferences*            m_ptt;
	CFSK441ProtocolPreferences* m_protocol;

	DECLARE_EVENT_TABLE()
};

#endif
