/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonEnumeration;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public class SingletonNodeSet
extends NodeSetValue {
    protected NodeInfo node = null;

    public SingletonNodeSet() {
        this.node = null;
    }

    public SingletonNodeSet(NodeInfo nodeInfo) {
        this.node = nodeInfo;
    }

    public Expression simplify() throws SAXException {
        if (this.node == null) {
            return new EmptyNodeSet();
        }
        return this;
    }

    public Value evaluate(Context context) throws SAXException {
        return this;
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws SAXException {
        return this;
    }

    public void setSorted(boolean bl) {
    }

    public boolean isSorted() {
        return true;
    }

    public String asString() throws SAXException {
        if (this.node == null) {
            return "";
        }
        return this.node.getValue();
    }

    public boolean asBoolean() throws SAXException {
        return this.node != null;
    }

    public int getCount() throws SAXException {
        return this.node == null ? 0 : 1;
    }

    public boolean isEmpty() throws SAXException {
        return this.node == null;
    }

    public boolean isSingular() throws SAXException {
        return this.node != null;
    }

    public boolean contains(NodeInfo nodeInfo) throws SAXException {
        return nodeInfo == this.node;
    }

    public Vector getVector() throws SAXException {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        if (this.node != null) {
            vector.addElement(this.node);
        }
        return vector;
    }

    public NodeInfo[] getNodes() throws SAXException {
        if (this.node == null) {
            return new NodeInfo[0];
        }
        NodeInfo[] nodeInfoArray = new NodeInfo[]{this.node};
        return nodeInfoArray;
    }

    public NodeSetValue sort() {
        return this;
    }

    public NodeInfo getFirst() throws SAXException {
        return this.node;
    }

    public boolean equals(Value value) throws SAXException {
        if (this.node == null) {
            if (value instanceof BooleanValue) {
                return !value.asBoolean();
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            String string = this.node.getValue();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (!nodeEnumeration.nextElement().getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            return Value.stringToNumber(this.node.getValue()) == value.asNumber();
        }
        if (value instanceof StringValue) {
            return this.node.getValue().equals(value.asString());
        }
        if (value instanceof BooleanValue) {
            return value.asBoolean();
        }
        if (value instanceof FragmentValue || value instanceof ObjectValue) {
            return this.equals(new StringValue(value.asString()));
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public boolean notEquals(Value value) throws SAXException {
        if (this.node == null) {
            if (value instanceof BooleanValue) {
                return value.asBoolean();
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            String string = this.node.getValue();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (nodeEnumeration.nextElement().getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            return Value.stringToNumber(this.node.getValue()) != value.asNumber();
        }
        if (value instanceof StringValue) {
            return !this.node.getValue().equals(value.asString());
        }
        if (value instanceof BooleanValue) {
            return !value.asBoolean();
        }
        if (value instanceof FragmentValue || value instanceof ObjectValue) {
            return !this.equals(new StringValue(value.asString()));
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public NodeEnumeration enumerate() throws SAXException {
        return new SingletonEnumeration(this.node);
    }
}

