/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.ProxyEmitter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.SAXException;

public class CDATAFilter
extends ProxyEmitter {
    private StringBuffer buffer = new StringBuffer();
    private Stack stack = new Stack();
    private Hashtable nameList = new Hashtable();

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        this.flush(this.buffer);
        this.stack.push(name);
        super.startElement(name, attributeCollection);
    }

    public void endElement(Name name) throws SAXException {
        this.flush(this.buffer);
        this.stack.pop();
        super.endElement(name);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flush(this.buffer);
        super.processingInstruction(string, string2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flush(this.buffer);
        super.comment(cArray, n, n2);
    }

    public void setEscaping(boolean bl) throws SAXException {
        boolean bl2;
        if (this.stack.isEmpty()) {
            bl2 = false;
        } else {
            String string = ((Name)this.stack.peek()).getAbsoluteName();
            boolean bl3 = bl2 = this.nameList.get(string) != null;
        }
        if (!bl2) {
            this.flush(this.buffer);
            super.setEscaping(bl);
        }
    }

    public void flush(StringBuffer stringBuffer) throws SAXException {
        Object object;
        boolean bl;
        int n = stringBuffer.length();
        if (n == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            bl = false;
        } else {
            object = ((Name)this.stack.peek()).getAbsoluteName();
            boolean bl2 = bl = this.nameList.get(object) != null;
        }
        if (bl) {
            char[] cArray;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (!this.characterSet.inCharset(stringBuffer.charAt(n3))) {
                    cArray = new char[n3 - n2];
                    stringBuffer.getChars(n2, n3, cArray, 0);
                    this.flushCDATA(cArray, n3 - n2);
                    super.setEscaping(true);
                    char[] cArray2 = new char[]{stringBuffer.charAt(n3)};
                    super.characters(cArray2, 0, 1);
                    super.setEscaping(false);
                    n2 = n3 + 1;
                }
                ++n3;
            }
            cArray = new char[n - n2];
            stringBuffer.getChars(n2, n, cArray, 0);
            this.flushCDATA(cArray, n - n2);
        } else {
            object = new char[n];
            stringBuffer.getChars(0, n, (char[])object, 0);
            super.characters((char[])object, 0, n);
        }
        stringBuffer.setLength(0);
    }

    private void flushCDATA(char[] cArray, int n) throws SAXException {
        super.setEscaping(false);
        super.characters("<![CDATA[".toCharArray(), 0, 9);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n - 2) {
            if (cArray[n2] == ']' && cArray[n2 + 1] == ']' && cArray[n2 + 2] == '>') {
                super.characters(cArray, n3, n2 + 2 - n3);
                super.characters("]]><![CDATA[".toCharArray(), 0, 12);
                n3 = n2 + 2;
            }
            ++n2;
        }
        super.characters(cArray, n3, n - n3);
        super.characters("]]>".toCharArray(), 0, 3);
        super.setEscaping(true);
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
        Vector vector = outputDetails.getCdataElements();
        int n = 0;
        while (n < vector.size()) {
            this.nameList.put(((Name)vector.elementAt(n)).getAbsoluteName(), "");
            ++n;
        }
        super.setOutputDetails(outputDetails);
    }
}

