#ifndef __FINGER_H_
#define __FINGER_H_

#include <pwd.h>

struct fng_info {		/* information level to be shown */
  int logname:1;		/* show login name */
  int realname:1;		/* show real name */
  int homedir:1;		/* show home directory */
  int shell:1;			/* show shell */

  int room:1;			/* gecos:room */
  int workphone:1;		/* gecos:work phone */
  int homephone:1;		/* gecos:home phone */
  int other:1;			/* gecos:other */

  int nmdate:1;			/* show new mail date */
  int mrdate:1;			/* show last mail read date */

  int laston:1;			/* show last login date */
  int ifon:1;			/* show if currently online */
  int origin:1;			/* show login origin */

  int plan:1;			/* show plan file */
  int project:1;		/* show project file */
  int pgp:1;			/* show pgp key file */
  int nofinger:1;		/* show nofinger file */
};

struct fng_config {		/* configuration */
  int local:1;			/* local finger */
  int match_gecos:1;		/* match gecos field */
  const char *plan_file;
  const char *project_file;
  const char *pgpkey_file;
  const char *nofinger_file;
  const char *userlist;		/* `no user' binary */
  const char *nouser;		/* no such user */
  const char *refused;
};

#define M_TALKABLE 0220

#define FIELD_WIDTH 40		/* half of a normal screen */

#define GECOS_NAME 0
#define GECOS_ROOM 1
#define GECOS_WORK 2
#define GECOS_HOME 3
#define GECOS_OTHER 4
#define GECOS_MAX 5

struct passwd *scan_gecos (const char *name);
int name_match (const char *p, const char *q);
void show_user (struct fng_info *fi, struct fng_config *fg,
		struct passwd *pwdent);
void finger_name (struct fng_info *fi, struct fng_config *fg,
	          const char *name);

#endif __FINGER_H_
