/* xkbparser.l

   Parser for xkb configuration extensions

   (C) 1999 Stanislav Meduna <stano@eunet.sk>


   The extensions are formatted as special comments.
   They can be positioned:


   Anywhere inside xkb_keymap block:

     %xkb_description% "A keyboard description"
       a brief description of the keymap

     %xkb_pixmap% "foo.xpm"
       relative path to a small pixmap used to represent
       the mapping in GUI applications


   Outside xkb_keymap block

     %xkb_file% "filename"
       next entries are prosessed as they were in this file
       (used for redefinitions)

*/

string    \"[^\n"]+\"
combegin  "#"|"//"
lbrace    "{"
rbrace    "}"
kmap      "xkb_keymap"
descr     "%xkb_description%"
pixmap    "%xkb_pixmap%"
relfile   "%xkb_file%"

%s COMMENT KMAP_SEEN BODY
%option prefix="xkbparser"
%option outfile="lex.yy.c"
%option noyywrap
%{
#include <dbaccess.h>
#include <string.h>

static int brace_level;
static int comment_caller;

static char map_name[32];
static char map_descr[256];
static char map_pixmap[512];

static char file_name[512];

static enum { NONE, NAME, DESCR, PIXMAP, RELFILE } what;

static void reset_data()
{
	map_name[0] =
	map_descr[0] =
	map_pixmap[0] =
	map_name[sizeof(map_name)-1] =
	map_descr[sizeof(map_descr)-1] =
	map_pixmap[sizeof(map_pixmap)-1] = 0;
}

static void got_data()
{
	mapinfo_cb(map_name, map_descr, map_pixmap);
}

static void got_file()
{
	filename_cb(file_name);
}

static void set_string(const char *s)
{
	int n;

	if (*s == '\"')
		s++; /* skip quote */

	n = strlen(s);
	if (n)
		n--;

	switch(what)
	{
	case NAME:
		strncpy(map_name, s, sizeof(map_name)-1);
		if (map_name[n] == '\"')
			map_name[n] = 0;
		break;

	case DESCR:
		strncpy(map_descr, s, sizeof(map_descr)-1);
		if (map_descr[n] == '\"')
			map_descr[n] = 0;
		break;

	case PIXMAP:
		strncpy(map_pixmap, s, sizeof(map_pixmap)-1);
		if (map_pixmap[n] == '\"')
			map_pixmap[n] = 0;
		break;

	case RELFILE:
		strncpy(file_name, s, sizeof(file_name)-1);
		if (file_name[n] == '\"')
			file_name[n] = 0;
		if (! brace_level)
			got_file();
		break;
		

	case NONE:
	default:
		break;
	}

	what = NONE;
}
%}
%%
	{ BEGIN(INITIAL); *file_name = file_name[sizeof(file_name)-1] = 0; }

<INITIAL>{kmap}     { brace_level = 0; what = NAME; reset_data(); BEGIN(KMAP_SEEN); }

<KMAP_SEEN>{string}   { set_string(yytext); }
<KMAP_SEEN>{lbrace}   { brace_level++; BEGIN(BODY); }

<BODY>{lbrace}   { brace_level++; }
<BODY>{rbrace}   { brace_level--; if (! brace_level) { got_data(); BEGIN(INITIAL); } }

<INITIAL,KMAP_SEEN,BODY>\n         ;
<INITIAL,KMAP_SEEN,BODY>.         ;
<INITIAL,KMAP_SEEN,BODY>{combegin} { comment_caller = YY_START; BEGIN(COMMENT); }

<COMMENT>{combegin} ;
<COMMENT>\n         { what = NONE; BEGIN(comment_caller); }
<COMMENT>{descr}    { what = DESCR; }
<COMMENT>{pixmap}   { what = PIXMAP; }
<COMMENT>{relfile}  { what = RELFILE; }
<COMMENT>{string}   { set_string(yytext); }
<COMMENT>.      ;

%%

