echo "# Stopping Xprint server"

if [ -z "${MOZ_USER_DIR}" ] ; then
    echo "Internal error: MOZ_USER_DIR not set."
    exit 1
fi

# Make sure we pick the right binary - users may share one profile
# between different architectures
uname_os="`uname -s`"
uname_cpu="`uname -p 2>/dev/null`" # uname -p may fail on old Debian
if [ "${uname_cpu}" = "unknown" -o "${uname_cpu}" = "" ] ; then
    uname_cpu="`uname -m`"
fi

MOZXPSTARTSCRIPT="${HOME}/${MOZ_USER_DIR}/xprint_xpi/${uname_os}_${uname_cpu}/run_xprint_from_tarball.sh"

if [ -f "${MOZXPSTARTSCRIPT}" ] ; then
    /bin/sh "${MOZXPSTARTSCRIPT}" stop
fi

echo "# Done."
