/*

    xpuyopuyo - phighscore.c  Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Code for high scores.
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <config.h>
#include <xpuyopuyo.h>
#include <pfile.h>
#include <pconfig.h>
#include <pwindow.h>
#include <phighscore.h>
#include <psnprintf.h>


void p_high_score_load(phigh *h) {

   char buf[P_IO_BUFFER];
   char *p;
   char *ps;
   char *pr;
   char *pc;
   FILE *f;
   int i;

   for(i = 0; i < P_HIGH_SCORE_COUNT; i++) {
      h[i].score = 0;
      p_strncpy(h[i].name, "nobody", P_PLAYER_NAME_SIZE);
      h[i].sfit = 0;
      h[i].rfit = 0;
      h[i].cfit = 0;
   }

   if((f = p_file_open_read(P_HIGH_SCORE_FILE)) == NULL) return;

   i = 0;
   while(p_file_read_line(buf, P_IO_BUFFER, f) != NULL && i < P_HIGH_SCORE_COUNT) {
      if((p = p_file_break(buf, '='))) {
         p_strncpy(h[i].name, buf, P_PLAYER_NAME_SIZE);
         ps = p_file_break(p, ':');
         pr = p_file_break(ps,':');
         pc = p_file_break(pr,':');
         if(p) h[i].score = atoi(p);
         if(ps) h[i].sfit = atoi(ps);
         if(pr) h[i].rfit = atoi(pr);
         if(pc) h[i].cfit = atoi(pc);
         i++;
      }
   }
   
   fclose(f);

}



void p_high_score_save(const phigh *h) {

   FILE *f;
   int i;
   
   if((f = p_file_open_write(P_HIGH_SCORE_FILE)) == NULL) return;
   fprintf(f, "# xpuyopuyo high scores file - automatically generated\n#\n");
   fprintf(f, "# There is no error checking on this data, so be careful what you edit\n#\n");
   for(i = 0; i < P_HIGH_SCORE_COUNT; i++) {
      fprintf(f, "%s=%d:%d:%d:%d\n", h[i].name, h[i].score, h[i].sfit, h[i].rfit, h[i].cfit);
   }
   fclose(f);

}



static void p_high_score_insert(phigh *h, int i, const pplayer *p) {

   int j;
   
   j = P_HIGH_SCORE_COUNT - 2;
   while(j >= i) {
      p_strncpy(h[j + 1].name, h[j].name, P_PLAYER_NAME_SIZE);
      h[j + 1].score = h[j].score;
      h[j + 1].sfit = h[j].sfit;
      h[j + 1].rfit = h[j].rfit;
      h[j + 1].cfit = h[j].cfit;
      j--;
   }

   p_strncpy(h[i].name, p->name, P_PLAYER_NAME_SIZE);
   h[i].score = p->score;
   h[i].sfit = p->f_pieces;
   h[i].rfit = p->f_rksent;
   h[i].cfit = p->f_rkrecv;

   return;

}



int p_high_score_add(phigh *h, const pplayer *p) {

   int j;
   
   j = 0;
   while(j < P_HIGH_SCORE_COUNT) {
      if(p->score >= h[j].score) {
         p_high_score_insert(h, j, p);
         p_high_score_save(h);
         return(j);
      }
      j++;
   }
   return(-1);
   
}


