/*-
# X-BASED OCTAHEDRON
#
#  OctP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Oct */

#ifndef _OctP_h
#define _OctP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Oct.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->oct.hPen = CreatePen(PS_SOLID, 1, c); \
  w->oct.hOldPen = (HPEN) SelectObject(w->core.hDC, w->oct.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->oct.hOldPen); \
  (void) DeleteObject(w->oct.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->oct.hPen = CreatePen(PS_SOLID, 1, c); \
  w->oct.hOldPen = (HPEN) SelectObject(w->core.hDC, w->oct.hPen); \
  w->oct.hBrush = CreateSolidBrush(c); \
  w->oct.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->oct.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->oct.hOldBrush); \
  (void) DeleteObject(w->oct.hBrush); \
  (void) SelectObject(w->core.hDC, w->oct.hOldPen); \
  (void) DeleteObject(w->oct.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->oct.hPen = CreatePen(PS_SOLID, 1, c); \
  w->oct.hOldPen = (HPEN) SelectObject(w->core.hDC, w->oct.hPen); \
  LINE(w,x1,y1,x2,y2); \
  (void) SelectObject(w->core.hDC, w->oct.hOldPen); \
  (void) DeleteObject(w->oct.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->oct.hPen = CreatePen(PS_SOLID, 1, c); \
  w->oct.hOldPen = (HPEN) SelectObject(w->core.hDC, w->oct.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->oct.hOldPen); \
  (void) DeleteObject(w->oct.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->oct.hPen = CreatePen(PS_SOLID, 1, c); \
  w->oct.hOldPen = (HPEN) SelectObject(w->core.hDC, w->oct.hPen); \
  w->oct.hBrush = CreateSolidBrush(c); \
  w->oct.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->oct.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->oct.hOldBrush); \
  (void) DeleteObject(w->oct.hBrush); \
  (void) SelectObject(w->core.hDC, w->oct.hOldPen); \
  (void) DeleteObject(w->oct.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
		  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyOct(HBRUSH brush);
extern void ResizeOct(OctWidget w);
extern void SizeOct(OctWidget w);
extern void InitializeOct(OctWidget w, HBRUSH brush);
extern void ExposeOct(const OctWidget w);
extern void HideOct(const OctWidget w);
extern void SelectOct(OctWidget w,
	const int x, const int y, const int control);
extern void ReleaseOct(OctWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticeOct(OctWidget w);
extern void PracticeOctMaybe(OctWidget w);
extern void PracticeOct2(OctWidget w);
extern void RandomizeOct(OctWidget w);
extern void RandomizeOctMaybe(OctWidget w);
extern void RandomizeOct2(OctWidget w);
extern void ClearOct(OctWidget w);
extern void GetOct(OctWidget w);
extern void WriteOct(OctWidget w);
extern void UndoOct(OctWidget w);
extern void SolveOct(OctWidget w);
extern void IncrementOct(OctWidget w);
extern Boolean DecrementOct(OctWidget w);
extern void OrientizeOct(OctWidget w);
extern void StickyModeOct(OctWidget w);
extern void PeriodModeOct(OctWidget w, const int mode);
extern void Period3ModeOct(OctWidget w);
extern void Period4ModeOct(OctWidget w);
extern void BothModeOct(OctWidget w);
extern void EnterOct(OctWidget w);
extern void LeaveOct(OctWidget w);
extern void MoveOctInput(OctWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MoveOctDir(OctWidget w, const int direction);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Oct.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
		  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _OctClassPart {
	int         ignore;
} OctClassPart;

typedef struct _OctClassRec {
	CoreClassPart core_class;
	OctClassPart oct_class;
} OctClassRec;

extern OctClassRec octClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BR 3
#define BOTTOM 4
#define BL 5
#define LEFT 6
#define TL 7
#define COORD 8
#define CW 9
#define CCW 15

#define MAXFACES 8
#define SAME 0
#define OPPOSITE 1
#define UP 1
#define DOWN 0
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _OctLoc {
	int         face, rotation;
} OctLoc;

typedef struct _OctPart {
	OctLoc     *facetLoc[MAXFACES];
	OctLoc     *faceLoc;
	OctLoc     *rowLoc[MAXORIENT / 2];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	int         size, sizeSize, mode;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength, viewMiddle;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        username[81];
	char        faceChar[MAXFACES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} OctPart;

typedef struct _OctRec {
	CorePart    core;
	OctPart     oct;
} OctRec;

extern OctLoc *startLoc[MAXFACES];
extern void SetOct(OctWidget w, int reason);
extern void MoveOct(OctWidget w, int face, int position, int direction, int style, int control);

#if 0
/* For future auto-solver */
extern void SolvePolyhedrons(OctWidget w);

#endif
extern void DrawAllPieces(OctWidget w);
extern Boolean CheckSolved(OctWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style, int control);
extern void GetMove(int *face, int *position, int *direction, int *style, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(OctWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, OctWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, OctWidget w);
extern void PrintStartPosition(FILE * fp, OctWidget w);
extern void SetStartPosition(OctWidget w);

#endif /* _OctP_h */
