#if !defined(__INC_UCXX_PYTHON_METHOD_H)
#define __INC_UCXX_PYTHON_METHOD_H

/*
 * Here we define a new python type, a Callable behaving like a
 * set of overloaded functions (or generic function in Scheme
 * nomenclature).  It isn't based on normal function pointers, but,
 * for increased flexibility, on SigC++'s slots.
 */

#include "python-script.h"

namespace Yehia
{
  
namespace Script
{

typedef struct
{
    PyObject_HEAD
    GSList *slots;
} pythonGenericFunction;

extern PyTypeObject pythonGenericFunctionType;

inline bool pythonGenericFunction_Check(PyObject *obj)
{
  return obj->ob_type == &pythonGenericFunctionType;
}

PyObject *pythonGenericFunction_New();
void pythonGenericFunction_AddSlot(PyObject *generic, const ObjectSlot& slot);

} // namespace Script

}

#endif
