/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include "yehia/script/any.h"
#include "yehia/script/base.h"

namespace Yehia
{

namespace Script
{

GStringChunk *Any::strchunk_ = 0;

Any::Any()
{
  typecode_ = TC_VOID;
  if (strchunk_ == 0)
  {
    strchunk_ = g_string_chunk_new(1024);
    g_atexit(&Any::free_strchunk);
  }
}

Any::~Any()
{
  clear();
}

void Any::free_strchunk()
{
  g_string_chunk_free(strchunk_);
}

void Any::clear()
{
  if (typecode_ == TC_LIST)
    delete listval_;
  else if (typecode_ == TC_SLOT)
    delete slotval_;
  else if (typecode_ == TC_INSTANCE)
    if (instval_.instance) instval_.instance->unreference();

  typecode_ = TC_VOID;
}

void Any::operator <<=(const Any& a)
{
  clear();
  switch (a.typecode_)
  {
    case TC_VOID:
      break;
    case TC_LONG:
      lval_ = a.lval_;
      break;
    case TC_ULONG:
      ulval_ = a.ulval_;
      break;
    case TC_BOOL:
      bval_ = a.bval_;
      break;
    case TC_REAL:
      rval_ = a.rval_;
      break;
    case TC_STRING:
      sval_ = a.sval_;
      break;
    case TC_LIST:
      listval_ = new std::list<Any>(*a.listval_);
      break;
    case TC_SLOT:
      slotval_ = new SlotValue(*a.slotval_);
      break;
    case TC_INSTANCE:
      instval_ = a.instval_;
      if (instval_.instance)
        instval_.instance->reference();
      break;
  }
  
  typecode_ = a.typecode_;
}

void Any::operator <<=(const InstanceValue& h)
{
  clear();
  typecode_ = TC_INSTANCE;
  instval_ = h;
  if (instval_.instance)
    instval_.instance->reference();
}

}

}
