// -*- c++ -*-
/* This is a generated file, do not edit.  Generated from template.macros.m4 */

#ifndef _INC_UCXX_SCRIPT_ANY_H
#define _INC_UCXX_SCRIPT_ANY_H

#include <glib.h>
#include <typeinfo>
#include <string>
#include <list>

#include <sigc++/object.h>

#include <yehia/script/types.h>

namespace Yehia
{

namespace Script
{


class Object;


//
// Any class
//
class Any
{
    template <class R>
    friend bool operator >>=(const Any&, SigC::Slot0<R>&);
    template <class R>
    friend void operator <<=(Any& a, SigC::Slot0<R>& slot);

    template <class R,class P1>
    friend bool operator >>=(const Any&, SigC::Slot1<R,P1>&);
    template <class R,class P1>
    friend void operator <<=(Any& a, SigC::Slot1<R,P1>& slot);

    template <class R,class P1,class P2>
    friend bool operator >>=(const Any&, SigC::Slot2<R,P1,P2>&);
    template <class R,class P1,class P2>
    friend void operator <<=(Any& a, SigC::Slot2<R,P1,P2>& slot);

    template <class R,class P1,class P2,class P3>
    friend bool operator >>=(const Any&, SigC::Slot3<R,P1,P2,P3>&);
    template <class R,class P1,class P2,class P3>
    friend void operator <<=(Any& a, SigC::Slot3<R,P1,P2,P3>& slot);

    template <class R,class P1,class P2,class P3,class P4>
    friend bool operator >>=(const Any&, SigC::Slot4<R,P1,P2,P3,P4>&);
    template <class R,class P1,class P2,class P3,class P4>
    friend void operator <<=(Any& a, SigC::Slot4<R,P1,P2,P3,P4>& slot);

    template <class R,class P1,class P2,class P3,class P4,class P5>
    friend bool operator >>=(const Any&, SigC::Slot5<R,P1,P2,P3,P4,P5>&);
    template <class R,class P1,class P2,class P3,class P4,class P5>
    friend void operator <<=(Any& a, SigC::Slot5<R,P1,P2,P3,P4,P5>& slot);

  public:
    struct InstanceValue
    {
        SigC::Object *instance;
        const std::type_info *tinfo;
    };
    struct SlotValue
    {
	SlotValue() {}
        SlotValue(const Slot& sl, const Signature& si) : slot(sl), sig(si) {}
        Slot slot;
        Signature sig;
    };
    enum TypeCode
    {
      TC_VOID,
      TC_LONG,
      TC_ULONG,
      TC_BOOL,
      TC_REAL,
      TC_STRING,
      TC_LIST,
      TC_SLOT,
      TC_INSTANCE
    };
    
    Any();
    Any(const Any& a) {
      typecode_ = TC_VOID;
      *this <<= a;
    }
    template <class T>
    Any(const T& v) {
      typecode_ = TC_VOID;
      if (strchunk_ == 0)
        strchunk_ = g_string_chunk_new(1024);
      *this <<= v;
    }
    ~Any();
    
    TypeCode typecode() const { return typecode_; }
    void clear();
    bool empty() const { return typecode_ == TC_VOID; }

    Any& operator =(const Any& a) {
      *this <<= a;
      return *this;
    }
    void operator <<=(long l) {
      clear();
      typecode_ = TC_LONG;
      lval_ = l;
    }
    void operator <<=(unsigned long ul) {
      clear();
      typecode_ = TC_ULONG;
      ulval_ = ul;
    }
    void operator <<=(bool b) {
      clear();
      typecode_ = TC_BOOL;
      bval_ = b;
    }
    void operator <<=(double d) {
      clear();
      typecode_ = TC_REAL;
      rval_ = d;
    }
    void operator <<=(const char *s) {
      clear();
      typecode_ = TC_STRING;
      sval_ = g_string_chunk_insert_const(strchunk_, s);
    }
    void operator <<=(const std::string& s) {
      clear();
      typecode_ = TC_STRING;
      sval_ = g_string_chunk_insert_const(strchunk_, s.c_str());
    }
    template <class T>
    void operator <<=(const std::list<T>& l) {
      clear();
      typecode_ = TC_LIST;
      listval_ = new std::list<Any>();
      for (typename std::list<T>::const_iterator it = l.begin(); it != l.end(); ++it)
        listval_->push_back(Any(*it));
    }
    void operator <<=(const InstanceValue& h);
    void operator <<=(const SlotValue& sval) {
      clear();
      typecode_ = TC_SLOT;
      slotval_ = new SlotValue(sval);
    }
    void operator <<=(const Any& a);

    bool operator >>=(long& l) const {
      return typecode_ == TC_LONG ? (l = lval_, true) :
        typecode_ == TC_ULONG ? (l = ulval_, true) : false;
    }
    bool operator >>=(unsigned long& ul) const {
      return typecode_ == TC_ULONG ? (ul = ulval_, true) :
        typecode_ == TC_LONG ? (ul = lval_, true) : false;
    }
    bool operator >>=(bool& b) const {
      return typecode_ == TC_BOOL ? (b = bval_, true) :
        typecode_ == TC_LONG ? (b = lval_, true) : 
        typecode_ == TC_ULONG ? (b = ulval_, true) : false;
    }
    bool operator >>=(double& d) const {
      return typecode_ != TC_REAL ? false : (d = rval_, true);
    }
    bool operator >>=(std::string& s) const {
      return typecode_ != TC_STRING ? false : (s = sval_, true);
    }
    bool operator >>=(char *& s) const {
      return typecode_ != TC_STRING ? false : (s = sval_, true);
    }
    bool operator >>=(std::list<Any>& l) const {
      return typecode_ != TC_LIST ? false : (l = *listval_, true);
    }
    bool operator >>=(SlotValue& sval) const {
      return typecode_ != TC_SLOT ? false : (sval = *slotval_, true);
    }
    bool operator >>=(InstanceValue& ih) const {
      return typecode_ != TC_INSTANCE ? false : (ih = instval_, true);
    }
    bool operator >>=(Any& a) const { a <<= *this; return true; }
  private:
    TypeCode typecode_;
    union
    {
        long lval_;
        unsigned long ulval_;
	bool bval_;
	double rval_;
        char *sval_;
        std::list<Any> *listval_;
	SlotValue *slotval_;
        InstanceValue instval_;
    };
    static GStringChunk *strchunk_;

    static void free_strchunk();
};

class BadAnyCast : public std::bad_cast
{
  public:
    virtual const char *what() const throw() {
        return "uC::BadAnyCast: "
          "failed conversion using uC::any_cast";
      }
};

template <typename ValueType> 
ValueType any_cast(const Any& operand)
{
  ValueType result;
  if(!(operand >>= result))
    throw BadAnyCast();
  return result;
}

} // namespace Script

} // namespace Yehia

#endif

