#if !defined(__INC_DECLARE_H)
#define __INC_DECLARE_H

#include <glib.h>

#include "tree.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif

enum
{
  DECL_CLASS,
  DECL_NAMESPACE
};

typedef struct
{
    int id;
    const char *filename;
    int lineno;
} MemberCommon;

typedef struct Namespace_
{
    MemberCommon common;
    const char *identifier;
    struct Namespace_ *parent;
    GHashTable *members;
} Namespace;

typedef struct
{
    MemberCommon common;
    const char *identifier;
    Tree defined_by;
    unsigned definition : 1;
    Namespace *scope;
} Class;

typedef union
{
    MemberCommon common;
    Namespace ns;
    Class cl;
} Member;

Namespace *decl_get_root_namespace(void);
Namespace *decl_namespace(Namespace *parent, const char *ident,
                          const char *fname, int lineno);
Class *    decl_class(Namespace *ns, const char *identfier, Tree defined_by,
                      gboolean definition, const char *fname, int lineno);

Class *decl_find_class(Namespace *scope, Tree typname, char **scope_name);

#ifdef __cplusplus
}
#endif

#endif
