/* $Id: network-table.h,v 1.3 2005/01/31 07:21:34 mschimek Exp $ */

/* Generated file, do not edit! */

struct country {
	uint16_t		cni_8301;	/* Packet 8/30 format 1 */
	uint16_t		cni_8302;	/* Packet 8/30 format 2 */
	uint16_t		cni_pdc_b;	/* Packet X/26 (PDC B) */
	uint16_t		cni_vps;	/* VPS */
	const char		country_code[4];
	const char *		name;		/* UTF-8 */
};

struct network {
	uint16_t		cni_8301;	/* Packet 8/30 format 1 */
	uint16_t		cni_8302;	/* Packet 8/30 format 2 */
	uint16_t		cni_pdc_b;	/* Packet X/26 (PDC B) */
	uint16_t		cni_vps;	/* VPS */
	unsigned int		country;
	const char *		name;		/* UTF-8 */
};

struct ttx_header {
	const char *		name;		/* UTF-8 */
	const char *		header;		/* raw Teletext data */
};

static const struct country
country_table [] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, "AA", "Unknown" },
	{ 0x4300, 0x0000, 0x0000, 0x0A00, "AT", "Austria" },
	{ 0x3200, 0x1600, 0x0000, 0x0000, "BE", "Belgium" },
	{ 0x4100, 0x2400, 0x3400, 0x0400, "CH", "Switzerland" },
	{ 0x0000, 0x3200, 0x0000, 0x0000, "CZ", "Czech Republic" },
	{ 0x4900, 0x0D00, 0x3D00, 0x0000, "DE", "Germany" },
	{ 0x0000, 0x2900, 0x0000, 0x0000, "DK", "Denmark" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "ES", "Spain" },
	{ 0x3500, 0x2600, 0x0000, 0x0000, "FI", "Finland" },
	{ 0x3300, 0x2F00, 0x3F00, 0x0000, "FR", "France" },
	{ 0x4400, 0x2C00, 0x3C00, 0x0000, "GB", "United Kingdom" },
	{ 0x3000, 0x2100, 0x3100, 0x0000, "GR", "Greece" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "HR", "Croatia" },
	{ 0x3600, 0x0000, 0x0000, 0x0000, "HU", "Hungary" },
	{ 0x0000, 0x4200, 0x3200, 0x0000, "IE", "Ireland" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "IS", "Iceland" },
	{ 0x3900, 0x0000, 0x0000, 0x0000, "IT", "Italy" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "LU", "Luxembourg" },
	{ 0x3100, 0x4800, 0x3800, 0x0000, "NL", "Netherlands" },
	{ 0x4700, 0x0000, 0x0000, 0x0000, "NO", "Norway" },
	{ 0x4800, 0x0000, 0x0000, 0x0000, "PL", "Poland" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "PT", "Portugal" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "SE", "Sweden" },
	{ 0xAA00, 0x0000, 0x0000, 0x0000, "SI", "Slovenia" },
	{ 0x0000, 0x3500, 0x3500, 0x0000, "SK", "Slovakia" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "SM", "San Marino" },
	{ 0x9000, 0x0000, 0x0000, 0x0000, "TR", "Turkey" },
	{ 0x7700, 0x0000, 0x0000, 0x0700, "UA", "Ukraine" },
};

static const struct network
network_table [] = {
	{ 0x0000, 0x0000, 0x0000, 0x0481,  3, "TeleZüri" },
	{ 0x0000, 0x0000, 0x0000, 0x0482,  3, "Teleclub Abo-Fernsehen" },
	{ 0x0000, 0x0000, 0x0000, 0x0483,  3, "Zürich 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0484,  3, "TeleBern" },
	{ 0x0000, 0x0000, 0x0000, 0x0485,  3, "Tele M1" },
	{ 0x0000, 0x0000, 0x0000, 0x0486,  3, "Star TV" },
	{ 0x0000, 0x0000, 0x0000, 0x0487,  3, "Pro 7" },
	{ 0x0000, 0x0000, 0x0000, 0x0488,  3, "TopTV" },
	{ 0x0000, 0x0000, 0x0000, 0x0AC3,  1, "ORF 3" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACB,  1, "ORF Burgenland" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACC,  1, "ORF Kärnten" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACD,  1, "ORF Niederösterreich" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACE,  1, "ORF Oberösterreich" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACF,  1, "ORF Salzburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD0,  1, "ORF Steiermark" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD1,  1, "ORF Tirol" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD2,  1, "ORF Vorarlberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD3,  1, "ORF Wien" },
	{ 0x0000, 0x0000, 0x0000, 0x0D78,  5, "TELE-5" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7A,  5, "N24" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7C,  5, "ONYX-TV" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7E,  5, "Nickelodeon" },
	{ 0x0000, 0x0000, 0x0000, 0x0D81,  5, "ORB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D87,  5, "1A-Fernsehen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D88,  5, "VIVA" },
	{ 0x0000, 0x0000, 0x0000, 0x0D89,  5, "VIVA 2" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8A,  5, "Super RTL" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8B,  5, "RTL Club" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8C,  5, "n-tv" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8D,  5, "Deutsches Sportfernsehen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D90,  5, "RTL 2 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D91,  5, "Eurosport" },
	{ 0x0000, 0x0000, 0x0000, 0x0D92,  5, "Kabel 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0D94,  5, "PRO 7" },
	{ 0x0000, 0x0000, 0x0000, 0x0D95,  5, "SAT 1 Brandenburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0D96,  5, "SAT 1 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D97,  5, "SAT 1 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D98,  5, "SAT 1 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0D99,  5, "SAT 1 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9A,  5, "RTL Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9B,  5, "RTL Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9C,  5, "RTL Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9D,  5, "RTL Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9E,  5, "RTL Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9F,  5, "RTL Bremen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA0,  5, "RTL Nordrhein-Westfalen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA1,  5, "RTL Hessen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA2,  5, "RTL Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA3,  5, "RTL Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA4,  5, "RTL Bayern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA5,  5, "RTL Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA6,  5, "RTL Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA7,  5, "RTL Mecklenburg-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA8,  5, "RTL Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA9,  5, "RTL Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAA,  5, "RTL Brandenburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAB,  5, "RTL" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAC,  5, "Premiere" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAD,  5, "SAT 1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAE,  5, "SAT 1 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAF,  5, "SAT 1 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB0,  5, "SAT 1 Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB1,  5, "SAT 1 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB2,  5, "SAT 1 Bremen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB3,  5, "SAT 1 Nordrhein-Westfalen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB4,  5, "SAT 1 Hessen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB5,  5, "SAT 1 Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB6,  5, "SAT 1 Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB7,  5, "SAT 1 Bayern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB8,  5, "SAT 1 Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB9,  5, "SAT 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBA,  5, "NEUN LIVE" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBB,  5, "Deutsche Welle TV Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBD,  5, "Berlin Offener Kanal" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBE,  5, "Berlin-Mix-Channel 2" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBF,  5, "Berlin-Mix-Channel 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC3,  5, "ARD/ZDF Vormittagsprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC4,  5, "ARD-TV-Sternpunkt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC5,  5, "ARD-TV-Sternpunkt-Fehler" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCA,  5, "BR-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCC,  5, "BR-3 Süd" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCD,  5, "BR-3 Nord" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCE,  5, "HR-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD0,  5, "NDR-1 Dreiländerweit" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD1,  5, "NDR-1 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD2,  5, "NDR-1 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD3,  5, "NDR-1 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD4,  5, "Nord-3 (NDR/SFB/RB)" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD6,  5, "NDR-3 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD7,  5, "NDR-3 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD8,  5, "NDR-3 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD9,  5, "RB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDB,  5, "SFB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDD,  5, "SDR/SWF Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDE,  5, "SWF-1 Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE0,  5, "Südwest 3 (SDR/SR/SWF)" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE2,  5, "SW 3 Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE3,  5, "SW 3 Baden-Württemb. Süd" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE5,  5, "WDR-1 Regionalprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE7,  5, "WDR-3 Bielefeld" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE8,  5, "WDR-3 Dortmund" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE9,  5, "WDR-3 Düsseldorf" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEA,  5, "WDR-3 Köln" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEB,  5, "WDR-3 Münster" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEC,  5, "SDR-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DED,  5, "SW 3 Baden-Württemberg Nord" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEE,  5, "SW 3 Mannheim" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEF,  5, "SDR/SWF BW und Rhld-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF0,  5, "SWF-1 / Regionalprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF1,  5, "NDR-1 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF2,  5, "NDR-3 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF3,  5, "MDR-1 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF4,  5, "MDR-3 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF5,  5, "MDR Dresden" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF6,  5, "MDR-1 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF7,  5, "WDR Dortmund" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF8,  5, "MDR-3 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF9,  5, "MDR Magdeburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFA,  5, "MDR-1 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFB,  5, "MDR-3 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFC,  5, "MDR Erfurt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFD,  5, "MDR-1 Regional" },
	{ 0x01F2, 0x5BF1, 0x3B71, 0x0000, 10, "CNN International" },
	{ 0x0385, 0x0000, 0x0000, 0x0000, 12, "HRT" },
	{ 0x0404, 0x1604, 0x3604, 0x0000,  2, "VT4" },
	{ 0x0AE8, 0x0000, 0x0000, 0x0D14,  5, "PRO 7 Austria" },
	{ 0x0D8F, 0x0000, 0x0000, 0x0D8F,  5, "RTL 2" },
	{ 0x10E4, 0x2C34, 0x3C34, 0x0000, 10, "MERIDIAN" },
	{ 0x1609, 0x2C09, 0x3C09, 0x0000, 10, "CHANNEL 5 (2)" },
	{ 0x25D0, 0x2C30, 0x3C30, 0x0000, 10, "WESTCOUNTRY TV" },
	{ 0x28EB, 0x2C2B, 0x3C2B, 0x0000, 10, "CHANNEL 5 (3)" },
	{ 0x2F27, 0x2C37, 0x3C37, 0x0000, 10, "CENTRAL TV" },
	{ 0x3001, 0x2101, 0x3101, 0x0000, 11, "ET-1" },
	{ 0x3002, 0x2102, 0x3102, 0x0000, 11, "NET" },
	{ 0x3003, 0x2103, 0x3103, 0x0000, 11, "ET-3" },
	{ 0x3101, 0x4801, 0x3801, 0x0000, 18, "Nederland 1" },
	{ 0x3102, 0x4802, 0x3802, 0x0000, 18, "Nederland 2" },
	{ 0x3103, 0x4803, 0x3803, 0x0000, 18, "Nederland 3" },
	{ 0x3104, 0x4804, 0x3804, 0x0000, 18, "RTL 4" },
	{ 0x3105, 0x4805, 0x3805, 0x0000, 18, "RTL 5" },
	{ 0x3106, 0x4806, 0x3806, 0x0000, 18, "Yorin" },
	{ 0x3120, 0x4820, 0x3820, 0x0000, 18, "The BOX" },
	{ 0x3121, 0x0000, 0x0000, 0x0000, 18, "Discovery Netherlands" },
	{ 0x3122, 0x0000, 0x0000, 0x0000, 18, "Nickelodeon" },
	{ 0x3123, 0x0000, 0x0000, 0x0000, 18, "Animal Planet Benelux" },
	{ 0x3125, 0x0000, 0x0000, 0x0000, 18, "NET5" },
	{ 0x3126, 0x0000, 0x0000, 0x0000, 18, "SBS6" },
	{ 0x3128, 0x0000, 0x0000, 0x0000, 18, "V8" },
	{ 0x3130, 0x0000, 0x0000, 0x0000, 18, "TMF Netherlands" },
	{ 0x3131, 0x0000, 0x0000, 0x0000, 18, "TMF Belgian Flanders" },
	{ 0x3132, 0x0000, 0x0000, 0x0000, 18, "MTV NL" },
	{ 0x3201, 0x1601, 0x3603, 0x0000,  2, "VRT TV1" },
	{ 0x3202, 0x1602, 0x3602, 0x0000,  2, "CANVAS" },
	{ 0x3203, 0x0000, 0x0000, 0x0000,  2, "RTBF 1" },
	{ 0x3204, 0x0000, 0x0000, 0x0000,  2, "RTBF 2" },
	{ 0x3205, 0x1605, 0x3605, 0x0000,  2, "VTM" },
	{ 0x3206, 0x1606, 0x3606, 0x0000,  2, "Kanaal2" },
	{ 0x3207, 0x0000, 0x0000, 0x0000,  2, "RTBF Sat" },
	{ 0x3209, 0x0000, 0x0000, 0x0000,  2, "RTL-TV1" },
	{ 0x320A, 0x0000, 0x0000, 0x0000,  2, "CLUB-RTL" },
	{ 0x320B, 0x0000, 0x0000, 0x0000, 10, "National Geographic Channel" },
	{ 0x320C, 0x0000, 0x0000, 0x0000,  2, "AB3" },
	{ 0x320D, 0x0000, 0x0000, 0x0000,  2, "AB4e" },
	{ 0x320E, 0x0000, 0x0000, 0x0000,  2, "Ring TV" },
	{ 0x320F, 0x0000, 0x0000, 0x0000,  2, "JIM.tv" },
	{ 0x3210, 0x0000, 0x0000, 0x0000,  2, "RTL-Kempen" },
	{ 0x3211, 0x0000, 0x0000, 0x0000,  2, "RTL-Mechelen" },
	{ 0x3212, 0x0000, 0x0000, 0x0000,  2, "MCM Belgium" },
	{ 0x3213, 0x0000, 0x0000, 0x0000,  2, "Vitaya" },
	{ 0x3214, 0x0000, 0x0000, 0x0000,  2, "WTV" },
	{ 0x3215, 0x0000, 0x0000, 0x0000,  2, "FocusTV" },
	{ 0x3216, 0x0000, 0x0000, 0x0000,  2, "Canal+" },
	{ 0x3217, 0x0000, 0x0000, 0x0000,  2, "Canal+N1" },
	{ 0x3218, 0x0000, 0x0000, 0x0000,  2, "Canal+N2" },
	{ 0x3219, 0x0000, 0x0000, 0x0000,  2, "Canal+N3" },
	{ 0x321A, 0x0000, 0x0000, 0x0000,  2, "Canal+VL1" },
	{ 0x321B, 0x0000, 0x0000, 0x0000,  2, "Canal+VL2" },
	{ 0x321C, 0x0000, 0x0000, 0x0000,  2, "Canal+VLN1" },
	{ 0x321D, 0x0000, 0x0000, 0x0000,  2, "Canal+VLN2" },
	{ 0x321E, 0x0000, 0x0000, 0x0000,  2, "TV Brussel" },
	{ 0x321F, 0x0000, 0x0000, 0x0000,  2, "AVSe" },
	{ 0x3221, 0x0000, 0x0000, 0x0000,  2, "TV Limburg" },
	{ 0x3222, 0x0000, 0x0000, 0x0000,  2, "Kanaal 3" },
	{ 0x3223, 0x0000, 0x0000, 0x0000,  2, "ATV" },
	{ 0x3224, 0x0000, 0x0000, 0x0000,  2, "ROB TV" },
	{ 0x3225, 0x0000, 0x0000, 0x0000,  2, "PLUG TV" },
	{ 0x3226, 0x0000, 0x0000, 0x0000,  2, "Sporza" },
	{ 0x3230, 0x0000, 0x0000, 0x0000,  2, "Télé Bruxelles" },
	{ 0x3231, 0x0000, 0x0000, 0x0000,  2, "Télésambre" },
	{ 0x3232, 0x0000, 0x0000, 0x0000,  2, "TV Com" },
	{ 0x3233, 0x0000, 0x0000, 0x0000,  2, "Canal Zoom" },
	{ 0x3234, 0x0000, 0x0000, 0x0000,  2, "Vidéoscope" },
	{ 0x3235, 0x0000, 0x0000, 0x0000,  2, "Canal C" },
	{ 0x3236, 0x0000, 0x0000, 0x0000,  2, "Télé MB" },
	{ 0x3237, 0x0000, 0x0000, 0x0000,  2, "Antenne Centre" },
	{ 0x3238, 0x0000, 0x0000, 0x0000,  2, "Télévesdre" },
	{ 0x3239, 0x0000, 0x0000, 0x0000,  2, "RTC Télé Liège" },
	{ 0x3240, 0x0000, 0x0000, 0x0000,  2, "No tele" },
	{ 0x3241, 0x0000, 0x0000, 0x0000,  2, "TV Lux" },
	{ 0x325A, 0x0000, 0x0000, 0x0000,  2, "Kanaal Z - NL" },
	{ 0x325B, 0x0000, 0x0000, 0x0000,  2, "CANAL Z - FR" },
	{ 0x326A, 0x0000, 0x0000, 0x0000,  2, "CARTOON Network - NL" },
	{ 0x326B, 0x0000, 0x0000, 0x0000,  2, "CARTOON Network - FR" },
	{ 0x327A, 0x0000, 0x0000, 0x0000,  2, "LIBERTY CHANNEL - NL" },
	{ 0x327B, 0x0000, 0x0000, 0x0000,  2, "LIBERTY CHANNEL - FR" },
	{ 0x328A, 0x0000, 0x0000, 0x0000,  2, "TCM - NL" },
	{ 0x328B, 0x0000, 0x0000, 0x0000,  2, "TCM - FR" },
	{ 0x3298, 0x0000, 0x0000, 0x0000,  2, "Mozaiek/Mosaique" },
	{ 0x3299, 0x0000, 0x0000, 0x0000,  2, "Info Kanaal/Canal Info" },
	{ 0x330A, 0x2F0A, 0x3F0A, 0x0000,  9, "Arte" },
	{ 0x3311, 0x2F11, 0x3F11, 0x0000,  9, "RFO1" },
	{ 0x3312, 0x2F12, 0x3F12, 0x0000,  9, "RFO2" },
	{ 0x3320, 0x2F20, 0x3F20, 0x0000,  9, "Aqui TV" },
	{ 0x3321, 0x2F21, 0x3F21, 0x0000,  9, "TLM" },
	{ 0x3322, 0x2F22, 0x3F22, 0x0000,  9, "TLT" },
	{ 0x3333, 0x0000, 0x0000, 0x0000, 14, "TV3" },
	{ 0x33B2, 0x0000, 0x0000, 0x0000,  9, "Sailing Channel" },
	{ 0x33C1, 0x2FC1, 0x3F41, 0x0000,  9, "AB1" },
	{ 0x33C2, 0x2FC2, 0x3F42, 0x0000,  9, "Canal J" },
	{ 0x33C3, 0x2FC3, 0x3F43, 0x0000,  9, "Canal Jimmy" },
	{ 0x33C4, 0x2FC4, 0x3F44, 0x0000,  9, "LCI" },
	{ 0x33C5, 0x2FC5, 0x3F45, 0x0000,  9, "La Chaîne Météo" },
	{ 0x33C6, 0x2FC6, 0x3F46, 0x0000,  9, "MCM" },
	{ 0x33C7, 0x2FC7, 0x3F47, 0x0000,  9, "TMC Monte-Carlo" },
	{ 0x33C8, 0x2FC8, 0x3F48, 0x0000,  9, "Paris Première" },
	{ 0x33C9, 0x2FC9, 0x3F49, 0x0000,  9, "Planète" },
	{ 0x33CA, 0x2FCA, 0x3F4A, 0x0000,  9, "Série Club" },
	{ 0x33CB, 0x2FCB, 0x3F4B, 0x0000,  9, "Télétoon" },
	{ 0x33CC, 0x2FCC, 0x3F4C, 0x0000,  9, "Téva" },
	{ 0x33F1, 0x2F01, 0x3F01, 0x0000,  9, "TF1" },
	{ 0x33F2, 0x2F02, 0x3F02, 0x0000,  9, "France 2" },
	{ 0x33F3, 0x2F03, 0x3F03, 0x0000,  9, "France 3" },
	{ 0x33F4, 0x2F04, 0x3F04, 0x0000,  9, "Canal+" },
	{ 0x33F5, 0x2F05, 0x3F05, 0x0000,  9, "France 5" },
	{ 0x33F6, 0x2F06, 0x3F06, 0x0000,  9, "M6" },
	{ 0x3402, 0x0000, 0x0000, 0x0000,  7, "ETB 2" },
	{ 0x3403, 0x0000, 0x0000, 0x0000,  7, "CANAL 9" },
	{ 0x3404, 0x0000, 0x0000, 0x0000,  7, "PUNT 2" },
	{ 0x3405, 0x0000, 0x0000, 0x0000,  7, "CCV" },
	{ 0x340A, 0x0000, 0x0000, 0x0000,  7, "Arte" },
	{ 0x3510, 0x0000, 0x0000, 0x0000, 21, "RTP1" },
	{ 0x3511, 0x0000, 0x0000, 0x0000, 21, "RTP2" },
	{ 0x3512, 0x0000, 0x0000, 0x0000, 21, "RTPAF" },
	{ 0x3513, 0x0000, 0x0000, 0x0000, 21, "RTPI" },
	{ 0x3514, 0x0000, 0x0000, 0x0000, 21, "RTPAZ" },
	{ 0x3515, 0x0000, 0x0000, 0x0000, 21, "RTPM" },
	{ 0x3531, 0x4201, 0x3201, 0x0000, 14, "RTE1" },
	{ 0x3532, 0x4202, 0x3202, 0x0000, 14, "Network 2" },
	{ 0x3533, 0x4203, 0x3203, 0x0000, 14, "Teilifis na Gaeilge" },
	{ 0x3541, 0x0000, 0x0000, 0x0000, 15, "Rikisutvarpid-Sjonvarp" },
	{ 0x3581, 0x2601, 0x3601, 0x0000,  8, "YLE1" },
	{ 0x3582, 0x2602, 0x3607, 0x0000,  8, "YLE2" },
	{ 0x358F, 0x260F, 0x3614, 0x0000,  8, "OWL3" },
	{ 0x3601, 0x0000, 0x0000, 0x0000, 13, "MTV1" },
	{ 0x3602, 0x0000, 0x0000, 0x0000, 13, "MTV2" },
	{ 0x3611, 0x0000, 0x0000, 0x0000, 13, "MTV1 Budapest" },
	{ 0x3621, 0x0000, 0x0000, 0x0000, 13, "MTV1 Pécs" },
	{ 0x3622, 0x0000, 0x0000, 0x0000, 13, "tv2" },
	{ 0x3631, 0x0000, 0x0000, 0x0000, 13, "MTV1 Szeged" },
	{ 0x3636, 0x0000, 0x0000, 0x0000, 13, "Duna Televizio" },
	{ 0x3641, 0x0000, 0x0000, 0x0000, 13, "MTV1 Szombathely" },
	{ 0x3651, 0x0000, 0x0000, 0x0000, 13, "MTV1 Debrecen" },
	{ 0x3661, 0x0000, 0x0000, 0x0000, 13, "MTV1 Miskolc" },
	{ 0x3781, 0x0000, 0x0000, 0x0000, 25, "RTV" },
	{ 0x37E5, 0x2C25, 0x3C25, 0x0000, 10, "SSVC" },
	{ 0x3901, 0x0000, 0x0000, 0x0000, 16, "RAI 1" },
	{ 0x3902, 0x0000, 0x0000, 0x0000, 16, "RAI 2" },
	{ 0x3903, 0x0000, 0x0000, 0x0000, 16, "RAI 3" },
	{ 0x3904, 0x0000, 0x0000, 0x0000, 16, "Rete A" },
	{ 0x390A, 0x0000, 0x0000, 0x0000, 16, "Arte" },
	{ 0x3910, 0x0000, 0x0000, 0x0000, 16, "TRS TV" },
	{ 0x3920, 0x0000, 0x0000, 0x0000, 16, "RaiNews24" },
	{ 0x3921, 0x0000, 0x0000, 0x0000, 16, "Rai Med" },
	{ 0x3922, 0x0000, 0x0000, 0x0000, 16, "Rai Sport" },
	{ 0x3923, 0x0000, 0x0000, 0x0000, 16, "Rai Educational" },
	{ 0x3924, 0x0000, 0x0000, 0x0000, 16, "Rai Edu Lab" },
	{ 0x3925, 0x0000, 0x0000, 0x0000, 16, "Rai Nettuno 1" },
	{ 0x3926, 0x0000, 0x0000, 0x0000, 16, "Rai Nettuno 2" },
	{ 0x3927, 0x0000, 0x0000, 0x0000, 16, "Camera Deputati" },
	{ 0x3928, 0x0000, 0x0000, 0x0000, 16, "Rai Mosaico" },
	{ 0x3930, 0x0000, 0x0000, 0x0000, 16, "Discovery Italy" },
	{ 0x3933, 0x0000, 0x0000, 0x0000, 16, "MTV Italia" },
	{ 0x3934, 0x0000, 0x0000, 0x0000, 16, "MTV Brand New" },
	{ 0x3935, 0x0000, 0x0000, 0x0000, 16, "MTV Hits" },
	{ 0x3938, 0x0000, 0x0000, 0x0000, 16, "RTV38" },
	{ 0x3939, 0x0000, 0x0000, 0x0000, 16, "GAY TV" },
	{ 0x3940, 0x0000, 0x0000, 0x0000, 16, "Video Italia" },
	{ 0x3941, 0x0000, 0x0000, 0x0000, 16, "SAT 2000" },
	{ 0x3950, 0x0000, 0x0000, 0x0000, 16, "RaiSat Album" },
	{ 0x3951, 0x0000, 0x0000, 0x0000, 16, "RaiSat Art" },
	{ 0x3952, 0x0000, 0x0000, 0x0000, 16, "RaiSat Cinema" },
	{ 0x3953, 0x0000, 0x0000, 0x0000, 16, "RaiSat Fiction" },
	{ 0x3954, 0x0000, 0x0000, 0x0000, 16, "RaiSat GamberoRosso" },
	{ 0x3955, 0x0000, 0x0000, 0x0000, 16, "RaiSat Ragazzi" },
	{ 0x3956, 0x0000, 0x0000, 0x0000, 16, "RaiSat Show" },
	{ 0x3957, 0x0000, 0x0000, 0x0000, 16, "RaiSat G. Rosso interattivo" },
	{ 0x3961, 0x0000, 0x0000, 0x0000, 16, "Discovery Civilisations" },
	{ 0x3962, 0x0000, 0x0000, 0x0000, 16, "Discovery Travel and Adventure" },
	{ 0x3963, 0x0000, 0x0000, 0x0000, 16, "Discovery Science" },
	{ 0x3985, 0x0000, 0x0000, 0x0000, 16, "FOX Kids" },
	{ 0x3986, 0x0000, 0x0000, 0x0000, 16, "PEOPLE TV - RETE 7" },
	{ 0x3987, 0x0000, 0x0000, 0x0000, 16, "FOX Kids +1" },
	{ 0x3988, 0x0000, 0x0000, 0x0000, 16, "LA7" },
	{ 0x3989, 0x0000, 0x0000, 0x0000, 16, "PrimaTV" },
	{ 0x398A, 0x0000, 0x0000, 0x0000, 16, "SportItalia" },
	{ 0x3991, 0x0000, 0x0000, 0x0000, 16, "Marcopolo" },
	{ 0x3992, 0x0000, 0x0000, 0x0000, 16, "Alice" },
	{ 0x3993, 0x0000, 0x0000, 0x0000, 16, "Nuvolari" },
	{ 0x3994, 0x0000, 0x0000, 0x0000, 16, "Leonardo" },
	{ 0x3997, 0x0000, 0x0000, 0x0000, 16, "Tele+1" },
	{ 0x3998, 0x0000, 0x0000, 0x0000, 16, "Tele+2" },
	{ 0x3999, 0x0000, 0x0000, 0x0000, 16, "Tele+3" },
	{ 0x39B1, 0x0000, 0x0000, 0x0000, 16, "Sailing Channel" },
	{ 0x39CA, 0x0000, 0x0000, 0x0000, 16, "VIDEOLINA" },
	{ 0x3E00, 0x0000, 0x0000, 0x0000,  7, "TVE1" },
	{ 0x4000, 0x0000, 0x0000, 0x0000, 17, "RTL Télé Letzebuerg" },
	{ 0x4101, 0x24C1, 0x3441, 0x04C1,  3, "SRG Schweizer Fernsehen SF 1" },
	{ 0x4102, 0x24C2, 0x3442, 0x04C2,  3, "SSR Télévis. Suisse TSR 1" },
	{ 0x4103, 0x24C3, 0x3443, 0x04C3,  3, "SSR Televis. svizzera TSI 1" },
	{ 0x4107, 0x24C7, 0x3447, 0x04C7,  3, "SRG Schweizer Fernsehen SF 2" },
	{ 0x4108, 0x24C8, 0x3448, 0x04C8,  3, "SSR Télévis. Suisse TSR 2" },
	{ 0x4109, 0x24C9, 0x3449, 0x04C9,  3, "SSR Televis. svizzera TSI 2" },
	{ 0x410A, 0x24CA, 0x344A, 0x04CA,  3, "SRG SSR Sat Access" },
	{ 0x4121, 0x2421, 0x0000, 0x0000,  3, "U1" },
	{ 0x4201, 0x32C1, 0x3C21, 0x0000,  4, "CT 1" },
	{ 0x4202, 0x32C2, 0x3C22, 0x0000,  4, "CT 2" },
	{ 0x4203, 0x32C3, 0x3C23, 0x0000,  4, "NOVA TV" },
	{ 0x4204, 0x0000, 0x0000, 0x0000,  4, "Prima tv" },
	{ 0x4205, 0x0000, 0x0000, 0x0000,  4, "TV Praha" },
	{ 0x4206, 0x0000, 0x0000, 0x0000,  4, "TV HK" },
	{ 0x4207, 0x0000, 0x0000, 0x0000,  4, "TV Pardubice" },
	{ 0x4208, 0x0000, 0x0000, 0x0000,  4, "TV Brno" },
	{ 0x4211, 0x32D1, 0x3B01, 0x0000,  4, "CT1 Brno" },
	{ 0x4212, 0x32D2, 0x3B04, 0x0000,  4, "CT2 Brno" },
	{ 0x4221, 0x32E1, 0x3B02, 0x0000,  4, "CT1 Ostravia" },
	{ 0x4222, 0x32E2, 0x3B05, 0x0000,  4, "CT2 Ostravia" },
	{ 0x4231, 0x32F1, 0x3C25, 0x0000,  4, "CT1 Regional" },
	{ 0x4232, 0x32F2, 0x3B03, 0x0000,  4, "CT2 Regional" },
	{ 0x42A1, 0x35A1, 0x3521, 0x0000, 24, "STV1" },
	{ 0x42A2, 0x35A2, 0x3522, 0x0000, 24, "STV2" },
	{ 0x42A3, 0x35A3, 0x3523, 0x0000, 24, "STV1 Kosice" },
	{ 0x42A4, 0x35A4, 0x3524, 0x0000, 24, "STV2 Kosice" },
	{ 0x42A5, 0x35A5, 0x3525, 0x0000, 24, "STV1 B. Bystrica" },
	{ 0x42A6, 0x35A6, 0x3526, 0x0000, 24, "STV2 B. Bystrica" },
	{ 0x4301, 0x0000, 0x0000, 0x0AC1,  1, "ORF 1" },
	{ 0x4302, 0x0000, 0x0000, 0x0AC2,  1, "ORF 2" },
	{ 0x430C, 0x0000, 0x0000, 0x0ACA,  1, "ATV+" },
	{ 0x4401, 0x5BFA, 0x3B7A, 0x0000, 10, "UK GOLD" },
	{ 0x4402, 0x2C01, 0x3C01, 0x0000, 10, "UK LIVING" },
	{ 0x4403, 0x2C3C, 0x3C3C, 0x0000, 10, "WIRE TV" },
	{ 0x4404, 0x5BF0, 0x3B70, 0x0000, 10, "CHILDREN'S CHANNEL" },
	{ 0x4405, 0x5BEF, 0x3B6F, 0x0000, 10, "BRAVO" },
	{ 0x4406, 0x5BF7, 0x3B77, 0x0000, 10, "LEARNING CHANNEL" },
	{ 0x4407, 0x5BF2, 0x3B72, 0x0000, 10, "DISCOVERY" },
	{ 0x4408, 0x5BF3, 0x3B73, 0x0000, 10, "FAMILY CHANNEL" },
	{ 0x4409, 0x5BF8, 0x3B78, 0x0000, 10, "Live TV" },
	{ 0x4420, 0x0000, 0x0000, 0x0000, 10, "Discovery Home & Leisure" },
	{ 0x4440, 0x2C40, 0x3C40, 0x0000, 10, "BBC2" },
	{ 0x4441, 0x2C41, 0x3C41, 0x0000, 10, "BBC1 NI" },
	{ 0x4442, 0x2C42, 0x3C42, 0x0000, 10, "BBC2 Wales" },
	{ 0x4444, 0x2C44, 0x3C44, 0x0000, 10, "BBC2 Scotland" },
	{ 0x4457, 0x2C57, 0x3C57, 0x0000, 10, "BBC World" },
	{ 0x4468, 0x2C68, 0x3C68, 0x0000, 10, "BBC Prime" },
	{ 0x4469, 0x2C69, 0x3C69, 0x0000, 10, "BBC News 24" },
	{ 0x447B, 0x2C7B, 0x3C7B, 0x0000, 10, "BBC1 Scotland" },
	{ 0x447D, 0x2C7D, 0x3C7D, 0x0000, 10, "BBC1 Wales" },
	{ 0x447E, 0x2C7E, 0x3C7E, 0x0000, 10, "BBC2 NI" },
	{ 0x447F, 0x2C7F, 0x3C7F, 0x0000, 10, "BBC1" },
	{ 0x44C1, 0x0000, 0x0000, 0x0000, 10, "TNT / Cartoon Network" },
	{ 0x44D1, 0x5BCC, 0x3B4C, 0x0000, 10, "DISNEY CHANNEL UK" },
	{ 0x4502, 0x2902, 0x3902, 0x0000,  6, "TV2" },
	{ 0x4503, 0x2904, 0x3904, 0x0000,  6, "TV2 Zulu" },
	{ 0x4504, 0x0000, 0x0000, 0x0000,  6, "Discovery Denmark" },
	{ 0x4505, 0x2905, 0x0000, 0x0000,  6, "TV2 Charlie" },
	{ 0x4600, 0x4E00, 0x3E00, 0x0000, 22, "SVT Test Transmissions" },
	{ 0x4601, 0x4E01, 0x3E01, 0x0000, 22, "SVT 1" },
	{ 0x4602, 0x4E02, 0x3E02, 0x0000, 22, "SVT 2" },
	{ 0x4640, 0x4E40, 0x3E40, 0x0000, 22, "TV 4" },
	{ 0x4701, 0x0000, 0x0000, 0x0000, 19, "NRK1" },
	{ 0x4702, 0x0000, 0x0000, 0x0000, 19, "TV 2" },
	{ 0x4703, 0x0000, 0x0000, 0x0000, 19, "NRK2" },
	{ 0x4704, 0x0000, 0x0000, 0x0000, 19, "TV Norge" },
	{ 0x4720, 0x0000, 0x0000, 0x0000, 19, "Discovery Nordic" },
	{ 0x4801, 0x0000, 0x0000, 0x0000, 20, "TVP1" },
	{ 0x4802, 0x0000, 0x0000, 0x0000, 20, "TVP2" },
	{ 0x4810, 0x0000, 0x0000, 0x0000, 20, "TV Polonia" },
	{ 0x4820, 0x0000, 0x0000, 0x0000, 20, "TVN" },
	{ 0x4821, 0x0000, 0x0000, 0x0000, 20, "TVN Siedem" },
	{ 0x4822, 0x0000, 0x0000, 0x0000, 20, "TVN24" },
	{ 0x4830, 0x0000, 0x0000, 0x0000, 20, "Discovery Poland" },
	{ 0x4880, 0x0000, 0x0000, 0x0000, 20, "TVP Warszawa" },
	{ 0x4881, 0x0000, 0x0000, 0x0000, 20, "TVP Bialystok" },
	{ 0x4882, 0x0000, 0x0000, 0x0000, 20, "TVP Bydgoszcz" },
	{ 0x4883, 0x0000, 0x0000, 0x0000, 20, "TVP Gdansk" },
	{ 0x4884, 0x0000, 0x0000, 0x0000, 20, "TVP Katowice" },
	{ 0x4886, 0x0000, 0x0000, 0x0000, 20, "TVP Krakow" },
	{ 0x4887, 0x0000, 0x0000, 0x0000, 20, "TVP Lublin" },
	{ 0x4888, 0x0000, 0x0000, 0x0000, 20, "TVP Lodz" },
	{ 0x4890, 0x0000, 0x0000, 0x0000, 20, "TVP Rzeszow" },
	{ 0x4891, 0x0000, 0x0000, 0x0000, 20, "TVP Poznan" },
	{ 0x4892, 0x0000, 0x0000, 0x0000, 20, "TVP Szczecin" },
	{ 0x4893, 0x0000, 0x0000, 0x0000, 20, "TVP Wroclaw" },
	{ 0x4901, 0x0000, 0x3D41, 0x0DC1,  5, "ARD" },
	{ 0x4902, 0x0000, 0x3D42, 0x0DC2,  5, "ZDF" },
	{ 0x4908, 0x0000, 0x0000, 0x0DC8,  5, "Phoenix" },
	{ 0x490A, 0x0000, 0x3D05, 0x0D85,  5, "Arte" },
	{ 0x490C, 0x0000, 0x0000, 0x0D8E,  5, "VOX" },
	{ 0x4941, 0x0000, 0x0000, 0x0D41,  5, "FESTIVAL" },
	{ 0x4942, 0x0000, 0x0000, 0x0D42,  5, "MUXX" },
	{ 0x4943, 0x0000, 0x0000, 0x0D43,  5, "EXTRA" },
	{ 0x4944, 0x0000, 0x0000, 0x0000,  5, "BR-Alpha" },
	{ 0x4982, 0x0000, 0x0000, 0x0D82,  5, "ORB-3" },
	{ 0x49BF, 0x0000, 0x0000, 0x0D7F,  5, "Home Shopping Europe" },
	{ 0x49C7, 0x0000, 0x0000, 0x0DC7,  5, "3sat" },
	{ 0x49C9, 0x0000, 0x0000, 0x0DC9,  5, "Kinderkanal" },
	{ 0x49CB, 0x0000, 0x3D4B, 0x0DCB,  5, "BR-3" },
	{ 0x49CF, 0x2903, 0x3903, 0x0000,  6, "DR2" },
	{ 0x49D4, 0x0000, 0x0000, 0x0DD5,  5, "NDR-3 Dreiländerweit" },
	{ 0x49D9, 0x0000, 0x0000, 0x0DDA,  5, "RB-3" },
	{ 0x49DC, 0x0000, 0x0000, 0x0DDC,  5, "SFB-3" },
	{ 0x49DF, 0x0000, 0x0000, 0x0DDF,  5, "SR-1 Regional" },
	{ 0x49E1, 0x0000, 0x0000, 0x0DE1,  5, "SW 3 Baden-Württemberg" },
	{ 0x49E4, 0x0000, 0x0000, 0x0DE4,  5, "SW 3 Rheinland-Pfalz" },
	{ 0x49E6, 0x0000, 0x0000, 0x0DE6,  5, "WDR-3" },
	{ 0x49FE, 0x0000, 0x0000, 0x0DFE,  5, "MDR-3" },
	{ 0x49FF, 0x0000, 0x0000, 0x0DCF,  5, "Hessen 3" },
	{ 0x4D54, 0x2C14, 0x3C14, 0x0000, 10, "MTV" },
	{ 0x4D58, 0x2C20, 0x3C20, 0x0000, 10, "VH-1" },
	{ 0x4D59, 0x2C21, 0x3C21, 0x0000, 10, "VH-1 German" },
	{ 0x4D5A, 0x5BF4, 0x3B74, 0x0000, 10, "GRANADA PLUS" },
	{ 0x4D5B, 0x5BF5, 0x3B75, 0x0000, 10, "GRANADA Timeshare" },
	{ 0x5AAF, 0x2C3F, 0x3C3F, 0x0000, 10, "HTV" },
	{ 0x5C44, 0x0000, 0x0000, 0x0000, 10, "QVC UK" },
	{ 0x5C49, 0x0000, 0x0000, 0x0D7D,  5, "QVC" },
	{ 0x7392, 0x2901, 0x3901, 0x0000,  6, "DR1" },
	{ 0x7700, 0x0000, 0x0000, 0x07C0, 27, "1+1" },
	{ 0x7705, 0x0000, 0x0000, 0x07C5, 27, "M1" },
	{ 0x7707, 0x0000, 0x0000, 0x0000, 27, "ICTV" },
	{ 0x7708, 0x0000, 0x0000, 0x07C8, 27, "Novy Kanal" },
	{ 0x82DD, 0x2C1D, 0x3C1D, 0x0000, 10, "CARLTON TV" },
	{ 0x82E1, 0x2C05, 0x3C05, 0x0000, 10, "CARLTON SELECT" },
	{ 0x833B, 0x2C3D, 0x3C3D, 0x0000, 10, "ULSTER TV" },
	{ 0x884B, 0x2C0B, 0x3C0B, 0x0000, 10, "LWT" },
	{ 0x8E71, 0x2C31, 0x3C31, 0x0E86, 10, "NBC Europe" },
	{ 0x8E72, 0x2C35, 0x3C35, 0x0000, 10, "CNBC Europe" },
	{ 0x9001, 0x4301, 0x3301, 0x0000, 26, "TRT-1" },
	{ 0x9002, 0x4302, 0x3302, 0x0000, 26, "TRT-2" },
	{ 0x9003, 0x4303, 0x3303, 0x0000, 26, "TRT-3" },
	{ 0x9004, 0x4304, 0x3304, 0x0000, 26, "TRT-4" },
	{ 0x9005, 0x4305, 0x3305, 0x0000, 26, "TRT-INT" },
	{ 0x9006, 0x4306, 0x3306, 0x0000, 26, "AVRASYA" },
	{ 0x9007, 0x0000, 0x0000, 0x0000, 26, "Show TV" },
	{ 0x9008, 0x0000, 0x0000, 0x0000, 26, "Cine 5" },
	{ 0x9009, 0x0000, 0x0000, 0x0000, 26, "Super Sport" },
	{ 0x900A, 0x0000, 0x0000, 0x0000, 26, "ATV" },
	{ 0x900B, 0x0000, 0x0000, 0x0000, 26, "KANAL D" },
	{ 0x900C, 0x0000, 0x0000, 0x0000, 26, "EURO D" },
	{ 0x900D, 0x0000, 0x0000, 0x0000, 26, "EKO TV" },
	{ 0x900E, 0x0000, 0x0000, 0x0000, 26, "BRAVO TV" },
	{ 0x900F, 0x0000, 0x0000, 0x0000, 26, "GALAKSI TV" },
	{ 0x9010, 0x0000, 0x0000, 0x0000, 26, "FUN TV" },
	{ 0x9011, 0x0000, 0x0000, 0x0000, 26, "TEMPO TV" },
	{ 0x9014, 0x0000, 0x0000, 0x0000, 26, "TGRT" },
	{ 0x9020, 0x0000, 0x0000, 0x0000, 26, "STAR TV" },
	{ 0x9021, 0x0000, 0x0000, 0x0000, 26, "STARMAX" },
	{ 0x9022, 0x0000, 0x0000, 0x0000, 26, "KANAL 6" },
	{ 0x9023, 0x0000, 0x0000, 0x0000, 26, "STAR 4" },
	{ 0x9024, 0x0000, 0x0000, 0x0000, 26, "STAR 5" },
	{ 0x9025, 0x0000, 0x0000, 0x0000, 26, "STAR 6" },
	{ 0x9026, 0x0000, 0x0000, 0x0000, 26, "STAR 7" },
	{ 0x9027, 0x0000, 0x0000, 0x0000, 26, "STAR 8" },
	{ 0x9602, 0x2C02, 0x3C02, 0x0000, 10, "CHANNEL 5 (1)" },
	{ 0xA460, 0x0000, 0x0000, 0x0000, 10, "Nickelodeon UK" },
	{ 0xA465, 0x0000, 0x0000, 0x0000, 10, "Paramount Comedy Channel UK" },
	{ 0xA55A, 0x0000, 0x0000, 0x0000,  7, "Canal+" },
	{ 0xA82C, 0x2C2C, 0x3C2C, 0x0000, 10, "TYNE TEES TV" },
	{ 0xAAE1, 0x0000, 0x0000, 0x0000, 23, "SLO1" },
	{ 0xAAE2, 0x0000, 0x0000, 0x0000, 23, "SLO2" },
	{ 0xAAE3, 0x0000, 0x0000, 0x0000, 23, "KC" },
	{ 0xAAE4, 0x0000, 0x0000, 0x0000, 23, "TLM" },
	{ 0xAAF1, 0x0000, 0x0000, 0x0000, 23, "SLO3" },
	{ 0xADD8, 0x2C18, 0x3C18, 0x0000, 10, "GRANADA TV" },
	{ 0xADDC, 0x5BD2, 0x3B52, 0x0000, 10, "GMTV" },
	{ 0xB4C7, 0x2C07, 0x3C07, 0x0000, 10, "S4C" },
	{ 0xB7F7, 0x2C27, 0x3C27, 0x0000, 10, "BORDER TV" },
	{ 0xBA01, 0x0000, 0x0000, 0x0000,  7, "ETB 1" },
	{ 0xC47B, 0x2C3B, 0x3C3B, 0x0000, 10, "CHANNEL 5 (4)" },
	{ 0xC4F4, 0x42F4, 0x3274, 0x0000, 10, "FilmFour" },
	{ 0xC8DE, 0x2C1E, 0x3C1E, 0x0000, 10, "ITV NETWORK" },
	{ 0xCA03, 0x0000, 0x0000, 0x0000,  7, "TV3" },
	{ 0xCA33, 0x0000, 0x0000, 0x0000,  7, "C33" },
	{ 0xE100, 0x0000, 0x0000, 0x0000,  7, "TVE2" },
	{ 0xE200, 0x0000, 0x0000, 0x0000,  7, "TVE Internacional Europa" },
	{ 0xF101, 0x2FE2, 0x3F62, 0x0000,  9, "Eurosport" },
	{ 0xF33A, 0x2C3A, 0x3C3A, 0x0000, 10, "GRAMPIAN TV" },
	{ 0xF500, 0x2FE5, 0x3F65, 0x0000,  9, "TV5" },
	{ 0xF9D2, 0x2C12, 0x3C12, 0x0000, 10, "SCOTTISH TV" },
	{ 0xFA04, 0x0000, 0x0000, 0x0000, 16, "Rete 4" },
	{ 0xFA05, 0x0000, 0x0000, 0x0000, 16, "Canale 5" },
	{ 0xFA06, 0x0000, 0x0000, 0x0000, 16, "Italia 1" },
	{ 0xFA08, 0x0000, 0x0000, 0x0000, 16, "TMC" },
	{ 0xFA2C, 0x2C2D, 0x3C2D, 0x0000, 10, "YORKSHIRE TV" },
	{ 0xFB9C, 0x2C1C, 0x3C1C, 0x0000, 10, "ANGLIA TV" },
	{ 0xFCD1, 0x2C11, 0x3C11, 0x0000, 10, "CHANNEL 4" },
	{ 0xFCE4, 0x2C24, 0x3C24, 0x0000, 10, "CHANNEL TV" },
	{ 0xFCF3, 0x2C13, 0x3C13, 0x0000, 10, "RACING CHANNEL" },
	{ 0xFCF4, 0x5BF6, 0x3B76, 0x0000, 10, "HISTORY CHANNEL" },
	{ 0xFCF5, 0x2C15, 0x3C15, 0x0000, 10, "SCI FI CHANNEL" },
	{ 0xFCF6, 0x5BF9, 0x3B79, 0x0000, 10, "SKY TRAVEL" },
	{ 0xFCF7, 0x2C17, 0x3C17, 0x0000, 10, "SKY SOAPS" },
	{ 0xFCF8, 0x2C08, 0x3C08, 0x0000, 10, "SKY SPORTS 2" },
	{ 0xFCF9, 0x2C19, 0x3C19, 0x0000, 10, "SKY GOLD" },
	{ 0xFCFA, 0x2C1A, 0x3C1A, 0x0000, 10, "SKY SPORTS" },
	{ 0xFCFB, 0x2C1B, 0x3C1B, 0x0000, 10, "MOVIE CHANNEL" },
	{ 0xFCFC, 0x2C0C, 0x3C0C, 0x0000, 10, "SKY MOVIES PLUS" },
	{ 0xFCFD, 0x2C0D, 0x3C0D, 0x0000, 10, "SKY NEWS" },
	{ 0xFCFE, 0x2C0E, 0x3C0E, 0x0000, 10, "SKY ONE" },
	{ 0xFCFF, 0x2C0F, 0x3C0F, 0x0000, 10, "SKY TWO" },
	{ 0xFE01, 0x2FE1, 0x3F61, 0x0000,  9, "Euronews" },
};

/* 519 */

static const uint16_t
lookup_cni_8302 [] = {
	151, /* 1601 */
	152, /* 1602 */
	124, /* 1604 */
	155, /* 1605 */
	156, /* 1606 */
	132, /* 2101 */
	133, /* 2102 */
	134, /* 2103 */
	323, /* 2421 */
	316, /* 24C1 */
	317, /* 24C2 */
	318, /* 24C3 */
	319, /* 24C7 */
	320, /* 24C8 */
	321, /* 24C9 */
	322, /* 24CA */
	250, /* 2601 */
	251, /* 2602 */
	252, /* 260F */
	434, /* 2901 */
	370, /* 2902 */
	416, /* 2903 */
	371, /* 2904 */
	373, /* 2905 */
	348, /* 2C01 */
	471, /* 2C02 */
	440, /* 2C05 */
	483, /* 2C07 */
	510, /* 2C08 */
	128, /* 2C09 */
	442, /* 2C0B */
	514, /* 2C0C */
	515, /* 2C0D */
	516, /* 2C0E */
	517, /* 2C0F */
	503, /* 2C11 */
	496, /* 2C12 */
	505, /* 2C13 */
	426, /* 2C14 */
	507, /* 2C15 */
	509, /* 2C17 */
	481, /* 2C18 */
	511, /* 2C19 */
	512, /* 2C1A */
	513, /* 2C1B */
	502, /* 2C1C */
	439, /* 2C1D */
	488, /* 2C1E */
	427, /* 2C20 */
	428, /* 2C21 */
	504, /* 2C24 */
	264, /* 2C25 */
	484, /* 2C27 */
	130, /* 2C2B */
	475, /* 2C2C */
	501, /* 2C2D */
	129, /* 2C30 */
	443, /* 2C31 */
	127, /* 2C34 */
	444, /* 2C35 */
	131, /* 2C37 */
	494, /* 2C3A */
	486, /* 2C3B */
	349, /* 2C3C */
	441, /* 2C3D */
	431, /* 2C3F */
	357, /* 2C40 */
	358, /* 2C41 */
	359, /* 2C42 */
	360, /* 2C44 */
	361, /* 2C57 */
	362, /* 2C68 */
	363, /* 2C69 */
	364, /* 2C7B */
	365, /* 2C7D */
	366, /* 2C7E */
	367, /* 2C7F */
	229, /* 2F01 */
	230, /* 2F02 */
	231, /* 2F03 */
	232, /* 2F04 */
	233, /* 2F05 */
	234, /* 2F06 */
	209, /* 2F0A */
	210, /* 2F11 */
	211, /* 2F12 */
	212, /* 2F20 */
	213, /* 2F21 */
	214, /* 2F22 */
	217, /* 2FC1 */
	218, /* 2FC2 */
	219, /* 2FC3 */
	220, /* 2FC4 */
	221, /* 2FC5 */
	222, /* 2FC6 */
	223, /* 2FC7 */
	224, /* 2FC8 */
	225, /* 2FC9 */
	226, /* 2FCA */
	227, /* 2FCB */
	228, /* 2FCC */
	518, /* 2FE1 */
	493, /* 2FE2 */
	495, /* 2FE5 */
	324, /* 32C1 */
	325, /* 32C2 */
	326, /* 32C3 */
	332, /* 32D1 */
	333, /* 32D2 */
	334, /* 32E1 */
	335, /* 32E2 */
	336, /* 32F1 */
	337, /* 32F2 */
	338, /* 35A1 */
	339, /* 35A2 */
	340, /* 35A3 */
	341, /* 35A4 */
	342, /* 35A5 */
	343, /* 35A6 */
	246, /* 4201 */
	247, /* 4202 */
	248, /* 4203 */
	487, /* 42F4 */
	445, /* 4301 */
	446, /* 4302 */
	447, /* 4303 */
	448, /* 4304 */
	449, /* 4305 */
	450, /* 4306 */
	135, /* 4801 */
	136, /* 4802 */
	137, /* 4803 */
	138, /* 4804 */
	139, /* 4805 */
	140, /* 4806 */
	141, /* 4820 */
	374, /* 4E00 */
	375, /* 4E01 */
	376, /* 4E02 */
	377, /* 4E40 */
	369, /* 5BCC */
	482, /* 5BD2 */
	351, /* 5BEF */
	350, /* 5BF0 */
	122, /* 5BF1 */
	353, /* 5BF2 */
	354, /* 5BF3 */
	429, /* 5BF4 */
	430, /* 5BF5 */
	506, /* 5BF6 */
	352, /* 5BF7 */
	355, /* 5BF8 */
	508, /* 5BF9 */
	347, /* 5BFA */
};

static const uint16_t
lookup_cni_pdc_b [] = {
	132, /* 3101 */
	133, /* 3102 */
	134, /* 3103 */
	246, /* 3201 */
	247, /* 3202 */
	248, /* 3203 */
	487, /* 3274 */
	445, /* 3301 */
	446, /* 3302 */
	447, /* 3303 */
	448, /* 3304 */
	449, /* 3305 */
	450, /* 3306 */
	316, /* 3441 */
	317, /* 3442 */
	318, /* 3443 */
	319, /* 3447 */
	320, /* 3448 */
	321, /* 3449 */
	322, /* 344A */
	338, /* 3521 */
	339, /* 3522 */
	340, /* 3523 */
	341, /* 3524 */
	342, /* 3525 */
	343, /* 3526 */
	250, /* 3601 */
	152, /* 3602 */
	151, /* 3603 */
	124, /* 3604 */
	155, /* 3605 */
	156, /* 3606 */
	251, /* 3607 */
	252, /* 3614 */
	135, /* 3801 */
	136, /* 3802 */
	137, /* 3803 */
	138, /* 3804 */
	139, /* 3805 */
	140, /* 3806 */
	141, /* 3820 */
	434, /* 3901 */
	370, /* 3902 */
	416, /* 3903 */
	371, /* 3904 */
	332, /* 3B01 */
	334, /* 3B02 */
	337, /* 3B03 */
	333, /* 3B04 */
	335, /* 3B05 */
	369, /* 3B4C */
	482, /* 3B52 */
	351, /* 3B6F */
	350, /* 3B70 */
	122, /* 3B71 */
	353, /* 3B72 */
	354, /* 3B73 */
	429, /* 3B74 */
	430, /* 3B75 */
	506, /* 3B76 */
	352, /* 3B77 */
	355, /* 3B78 */
	508, /* 3B79 */
	347, /* 3B7A */
	348, /* 3C01 */
	471, /* 3C02 */
	440, /* 3C05 */
	483, /* 3C07 */
	510, /* 3C08 */
	128, /* 3C09 */
	442, /* 3C0B */
	514, /* 3C0C */
	515, /* 3C0D */
	516, /* 3C0E */
	517, /* 3C0F */
	503, /* 3C11 */
	496, /* 3C12 */
	505, /* 3C13 */
	426, /* 3C14 */
	507, /* 3C15 */
	509, /* 3C17 */
	481, /* 3C18 */
	511, /* 3C19 */
	512, /* 3C1A */
	513, /* 3C1B */
	502, /* 3C1C */
	439, /* 3C1D */
	488, /* 3C1E */
	427, /* 3C20 */
	428, /* 3C21 */
	325, /* 3C22 */
	326, /* 3C23 */
	504, /* 3C24 */
	336, /* 3C25 */
	484, /* 3C27 */
	130, /* 3C2B */
	475, /* 3C2C */
	501, /* 3C2D */
	129, /* 3C30 */
	443, /* 3C31 */
	127, /* 3C34 */
	444, /* 3C35 */
	131, /* 3C37 */
	494, /* 3C3A */
	486, /* 3C3B */
	349, /* 3C3C */
	441, /* 3C3D */
	431, /* 3C3F */
	357, /* 3C40 */
	358, /* 3C41 */
	359, /* 3C42 */
	360, /* 3C44 */
	361, /* 3C57 */
	362, /* 3C68 */
	363, /* 3C69 */
	364, /* 3C7B */
	365, /* 3C7D */
	366, /* 3C7E */
	367, /* 3C7F */
	405, /* 3D05 */
	402, /* 3D41 */
	403, /* 3D42 */
	415, /* 3D4B */
	374, /* 3E00 */
	375, /* 3E01 */
	376, /* 3E02 */
	377, /* 3E40 */
	229, /* 3F01 */
	230, /* 3F02 */
	231, /* 3F03 */
	232, /* 3F04 */
	233, /* 3F05 */
	234, /* 3F06 */
	209, /* 3F0A */
	210, /* 3F11 */
	211, /* 3F12 */
	212, /* 3F20 */
	213, /* 3F21 */
	214, /* 3F22 */
	217, /* 3F41 */
	218, /* 3F42 */
	219, /* 3F43 */
	220, /* 3F44 */
	221, /* 3F45 */
	222, /* 3F46 */
	223, /* 3F47 */
	224, /* 3F48 */
	225, /* 3F49 */
	226, /* 3F4A */
	227, /* 3F4B */
	228, /* 3F4C */
	518, /* 3F61 */
	493, /* 3F62 */
	495, /* 3F65 */
};

static const uint16_t
lookup_cni_vps [] = {
	  0, /* 0481 */
	  1, /* 0482 */
	  2, /* 0483 */
	  3, /* 0484 */
	  4, /* 0485 */
	  5, /* 0486 */
	  6, /* 0487 */
	  7, /* 0488 */
	316, /* 04C1 */
	317, /* 04C2 */
	318, /* 04C3 */
	319, /* 04C7 */
	320, /* 04C8 */
	321, /* 04C9 */
	322, /* 04CA */
	435, /* 07C0 */
	436, /* 07C5 */
	438, /* 07C8 */
	344, /* 0AC1 */
	345, /* 0AC2 */
	  8, /* 0AC3 */
	346, /* 0ACA */
	  9, /* 0ACB */
	 10, /* 0ACC */
	 11, /* 0ACD */
	 12, /* 0ACE */
	 13, /* 0ACF */
	 14, /* 0AD0 */
	 15, /* 0AD1 */
	 16, /* 0AD2 */
	 17, /* 0AD3 */
	125, /* 0D14 */
	407, /* 0D41 */
	408, /* 0D42 */
	409, /* 0D43 */
	 18, /* 0D78 */
	 19, /* 0D7A */
	 20, /* 0D7C */
	433, /* 0D7D */
	 21, /* 0D7E */
	412, /* 0D7F */
	 22, /* 0D81 */
	411, /* 0D82 */
	405, /* 0D85 */
	 23, /* 0D87 */
	 24, /* 0D88 */
	 25, /* 0D89 */
	 26, /* 0D8A */
	 27, /* 0D8B */
	 28, /* 0D8C */
	 29, /* 0D8D */
	406, /* 0D8E */
	126, /* 0D8F */
	 30, /* 0D90 */
	 31, /* 0D91 */
	 32, /* 0D92 */
	 33, /* 0D94 */
	 34, /* 0D95 */
	 35, /* 0D96 */
	 36, /* 0D97 */
	 37, /* 0D98 */
	 38, /* 0D99 */
	 39, /* 0D9A */
	 40, /* 0D9B */
	 41, /* 0D9C */
	 42, /* 0D9D */
	 43, /* 0D9E */
	 44, /* 0D9F */
	 45, /* 0DA0 */
	 46, /* 0DA1 */
	 47, /* 0DA2 */
	 48, /* 0DA3 */
	 49, /* 0DA4 */
	 50, /* 0DA5 */
	 51, /* 0DA6 */
	 52, /* 0DA7 */
	 53, /* 0DA8 */
	 54, /* 0DA9 */
	 55, /* 0DAA */
	 56, /* 0DAB */
	 57, /* 0DAC */
	 58, /* 0DAD */
	 59, /* 0DAE */
	 60, /* 0DAF */
	 61, /* 0DB0 */
	 62, /* 0DB1 */
	 63, /* 0DB2 */
	 64, /* 0DB3 */
	 65, /* 0DB4 */
	 66, /* 0DB5 */
	 67, /* 0DB6 */
	 68, /* 0DB7 */
	 69, /* 0DB8 */
	 70, /* 0DB9 */
	 71, /* 0DBA */
	 72, /* 0DBB */
	 73, /* 0DBD */
	 74, /* 0DBE */
	 75, /* 0DBF */
	402, /* 0DC1 */
	403, /* 0DC2 */
	 76, /* 0DC3 */
	 77, /* 0DC4 */
	 78, /* 0DC5 */
	413, /* 0DC7 */
	404, /* 0DC8 */
	414, /* 0DC9 */
	 79, /* 0DCA */
	415, /* 0DCB */
	 80, /* 0DCC */
	 81, /* 0DCD */
	 82, /* 0DCE */
	425, /* 0DCF */
	 83, /* 0DD0 */
	 84, /* 0DD1 */
	 85, /* 0DD2 */
	 86, /* 0DD3 */
	 87, /* 0DD4 */
	417, /* 0DD5 */
	 88, /* 0DD6 */
	 89, /* 0DD7 */
	 90, /* 0DD8 */
	 91, /* 0DD9 */
	418, /* 0DDA */
	 92, /* 0DDB */
	419, /* 0DDC */
	 93, /* 0DDD */
	 94, /* 0DDE */
	420, /* 0DDF */
	 95, /* 0DE0 */
	421, /* 0DE1 */
	 96, /* 0DE2 */
	 97, /* 0DE3 */
	422, /* 0DE4 */
	 98, /* 0DE5 */
	423, /* 0DE6 */
	 99, /* 0DE7 */
	100, /* 0DE8 */
	101, /* 0DE9 */
	102, /* 0DEA */
	103, /* 0DEB */
	104, /* 0DEC */
	105, /* 0DED */
	106, /* 0DEE */
	107, /* 0DEF */
	108, /* 0DF0 */
	109, /* 0DF1 */
	110, /* 0DF2 */
	111, /* 0DF3 */
	112, /* 0DF4 */
	113, /* 0DF5 */
	114, /* 0DF6 */
	115, /* 0DF7 */
	116, /* 0DF8 */
	117, /* 0DF9 */
	118, /* 0DFA */
	119, /* 0DFB */
	120, /* 0DFC */
	121, /* 0DFD */
	424, /* 0DFE */
	443, /* 0E86 */
};

static const struct ttx_header
ttx_header_table [] = {
	{ "MTV", "### MTVtext   ##.##.##  " },
	{ "TW1", "###?TW1  " },
	{ "UPC Telekabel", "###?Wiener?Kabel?Text  " },
};

