from OFS.SimpleItem import Item
from Acquisition import Implicit

from Products.ZPatterns.Providers import NullProvider
from Products.ZPatterns.Agents import AgentMixin, GTMixin
from Products.ZPatterns.AttributeProviders import GAPMixin, NOT_FOUND
from Products.ZPatterns.Expressions import NamespaceStack, pushProxy, popProxy
from DocumentTemplate.DT_Util import InstanceDict
      

class Compute(GAPMixin,NullProvider,Item,Implicit):
    """
    Compiler output for "WITH fromexpr COMPUTE assignments"
    """

    def __init__(self,fromexpr,assignlist,is_query=None,defaults=()):
        self._fromex = fromexpr
        self.Attributes = assignlist
        if defaults: self.Defaults = defaults
        if is_query: self.IsQuery = is_query    


class Trigger(GTMixin,AgentMixin,NullProvider,Item,Implicit):
    """
    Compiler output for WHEN ... STORE/CALL ... SAVING ... type statements
    """
    
    def __init__(self,events,saveattrs,callexpr,mementos,onlySave=None):
        self._mementos = mementos
        self.handle_set_for = saveattrs
        self._expr = callexpr
        self.applicable_events = events
        if onlySave: self._onlySaveAttrs=1








class Initialize(NullProvider,Item,Implicit):

    def __init__(self,computelist):
        self.Attributes = computelist

    def namesForRegistration(self,container):
        return { 'provides': ('handlers',) }

    def _objectCreating(self,client):
        
        t = NamespaceStack()
        pushProxy(self)

        try:            
            data = {'self':client, 'NOT_FOUND':NOT_FOUND, 'RESULT':client}

            t._push(InstanceDict(client, t))
            t._push(data)
        
            try:
                c = client._getCache()
                for a,e in self.Attributes:
                    c[a] = e.eval(t)
            finally:
                t._pop(2)

        finally:
            popProxy(self)







            
                




class PersistAttrs(NullProvider,Item,Implicit):
    """
    Compiler output for "STORE attrs IN SELF" statements
    """

    def __init__(self,attrlist):
        self.Attributes = attrlist

    def namesForRegistration(self,container):
        return {
            'provides':('attributes',),
            'setattr': self.Attributes, 'delattr': self.Attributes
        }

    def _SetAttributeFor(self,client,name,value):
        """Set the attribute and return true if successful"""
        client.__dict__[name]=value; client._p_changed = 1
        return 1

    def _DelAttributeFor(self,client,name):
        """Delete the attribute and return true if successful"""
        if client._v_changedAttrs_[name] is NOT_FOUND: del client._v_changedAttrs_[name]        
        return 1    # Nothing else to do, since DataSkin has already deleted persistent attr

