# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is RDFGrabber version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by EEA are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
#

from objects import resource

# Useful RDF constants

# SYNTAX
RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#"

TYPE = resource(RDFNS + "type")
PROPERTY = resource(RDFNS + "Property")
STATEMENT = resource(RDFNS + "Statement")
SUBJECT = resource(RDFNS + "subject")
PREDICATE = resource(RDFNS + "predicate")
OBJECT = resource(RDFNS + "object")

# SCHEMA
RDFSNS = "http://www.w3.org/2000/01/rdf-schema#"

CLASS = resource(RDFSNS + "Class")
RESOURCE = resource(RDFSNS + "Resource")
SUBCLASSOF = resource(RDFSNS + "subClassOf")
LABEL = resource(RDFSNS + "label")
COMMENT = resource(RDFSNS + "comment")
RANGE = resource(RDFSNS + "range")
DOMAIN = resource(RDFSNS + "domain")
LITERAL = resource(RDFSNS + "Literal")
CONTAINER = resource(RDFSNS + "Container")

