###################################################################################################
# _pathhandler.py
#
# $Id: _pathhandler.py,v 1.3 2004/02/24 19:57:21 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.3 $
#
# Implementation of class PathHandler (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
import copy
# Product Imports.
import zmscontainerobject


###################################################################################################
###################################################################################################
###
###   class PathHandler:
###
###   Based on the Zope-Product PathHandler (http://www.zope.org/Members/NIP/PathHandler).
###
###################################################################################################
###################################################################################################
class PathHandler: 
        
    # ------------------------------------------------------------------------------------------
    #  PathHandler.__bobo_traverse__
    # ------------------------------------------------------------------------------------------
    def __bobo_traverse__(self, TraversalRequest, name):
      # If this is the first time this __bob_traverse__ method has been called
      # in handling this traversal request, store the path_to_handle
      
      if not TraversalRequest.has_key('path_to_handle'):
          # Make a reversed copy of the TraversalRequestNameStack
          TraversalRequestNameStackReversed=copy.copy(TraversalRequest['TraversalRequestNameStack'])
          TraversalRequestNameStackReversed.reverse()
          
          # Set path_to_handle in the TraversalRequest.
          TraversalRequest['path_to_handle']=[name]+TraversalRequestNameStackReversed
      
      # Root.
      ob_ids = self.REQUEST.get('ZMS_OBJECT_IDS',[])
      if len(ob_ids) == 0:
        if self.getConfProperty('Portal.Master'):
          ob_ids.append(self.aq_parent.id)
	  ob_ids.append(self.id)
        self.REQUEST.set('ZMS_OBJECT_IDS',ob_ids)
      
      # If the name is in the list of attributes, call it.
      ob = getattr(self,name,None)
      if ob is not None:
        if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys():
          ob_ids.append(ob.id)
          self.REQUEST.set('ZMS_OBJECT_IDS',ob_ids)
          if self.REQUEST.get('URL','').find('/manage') < 0 and name == TraversalRequest['path_to_handle'][-1]:
            ob = zmscontainerobject.getPageWithElements(ob,self.REQUEST)
        return ob
      
      # otherwise do some 'magic'
      else:
	ob = self.pathob([name],self.REQUEST)
        if ob is not None:
          if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys():
            ob_ids.append(ob.id)
            self.REQUEST.set('ZMS_OBJECT_IDS',ob_ids)
            if self.REQUEST.get('URL','').find('/manage') < 0 and name == TraversalRequest['path_to_handle'][-1]:
              ob = zmscontainerobject.getPageWithElements(ob,self.REQUEST)
          return ob
        
        # If there's no more names left to handle, return the path handling method
        # to the traversal machinery so it gets called next
	raise "Resource not found",'<h2>Site-Error</h2><b>Sorry, there is no web page matching your request.</b> It is possible you typed the address incorrectly, or that the page no longer exists.<hr><b>Resource<b> <i>'+name+'</i> '+''.join(map(lambda x: x+'/',TraversalRequest['path_to_handle']))+' GET'


    # ------------------------------------------------------------------------------------------
    #  PathHandler.pathob
    # ------------------------------------------------------------------------------------------
    def pathob(self, path_to_handle, REQUEST):
      langs = self.getLangIds()
      path_ob = self
      path_index = 0
      while 1:
        if path_index == len(path_to_handle):
          return path_ob
        path_item = path_to_handle[path_index].lower()
        if path_index == 0 and path_item in langs:
          REQUEST.set('lang',path_item)
        else:
          obs = path_ob.getChildNodes(REQUEST)
          path_ob = None
          for ob in obs:
            if path_item == ob.id or \
               path_item == ob.getDeclId(REQUEST):
              path_ob = ob
          if path_ob is None: 
            break
        path_index = path_index + 1
      return None

###################################################################################################
