/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseChild() {
        super.releaseChild();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.parent = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n = this.parent.indexOf(this);
        if (n != this.parent.getSelectionIndex()) {
            if (control3 != null) {
                control3.setVisible(false);
            }
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientArea());
            control3.setVisible(true);
        }
        if (control2 != null) {
            control2.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
        if (OS.COMCTL32_MAJOR >= 6 && this.text.indexOf(38) != -1) {
            this.setText(this.text);
        }
        int n2 = this.parent.handle;
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 2;
        tCITEM.iImage = this.parent.imageIndex(image);
        OS.SendMessage(n2, OS.TCM_SETITEM, n, tCITEM);
    }

    public void setText(String string) {
        int n;
        int n2;
        int n3;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        if (OS.COMCTL32_MAJOR >= 6 && this.image != null && this.text.indexOf(38) != -1) {
            n2 = string.length();
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            int n4 = 0;
            n = 0;
            n4 = 0;
            while (n4 < n2) {
                if (cArray[n4] != '&') {
                    cArray[n++] = cArray[n4];
                }
                ++n4;
            }
            if (n < n4) {
                string = new String(cArray, 0, n);
            }
        }
        n2 = this.parent.handle;
        int n5 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        n = tCHAR.length() * TCHAR.sizeof;
        int n6 = OS.HeapAlloc(n5, 8, n);
        OS.MoveMemory(n6, tCHAR, n);
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 1;
        tCITEM.pszText = n6;
        OS.SendMessage(n2, OS.TCM_SETITEM, n3, tCITEM);
        OS.HeapFree(n5, 0, n6);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

